/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.metadata.datatransfer.export;

import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RepositoryUtility;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RepositoryVersionImpl;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.datatransfer.export.ExportTable;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.datatransfer.export.RowIterator;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.datatransfer.export.TableReader;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.datatransfer.export.format.CSVTableFormatter;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.datatransfer.export.format.TableFormatter;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class MetadataExporter {
    private static final String GroupNameBase = "group";
    public static final int MaxProjectNamesInGroup = 10;
    public static final int MaxGroupNamesInCall = 5;
    private String schema;
    private Connection connection;
    private OutputStream os;
    private TableFormatter formatter;
    public static final String versionManifestEntry = "Schema-Version";
    public static final String appNameManifestEntry = "Application-Name";
    public static final String appVersionManifestEntry = "Application-Version";

    public MetadataExporter(Connection connection, String string, String string2, String string3, OutputStream outputStream) throws MetadataException {
        this(connection, string, string2, string3, outputStream, null);
    }

    public MetadataExporter(Connection connection, String string, String string2, String string3, OutputStream outputStream, TableFormatter tableFormatter) throws MetadataException {
        this.schema = string;
        this.connection = connection;
        if (tableFormatter == null) {
            tableFormatter = new CSVTableFormatter();
        }
        this.formatter = tableFormatter;
        this.os = outputStream;
    }

    public void export(String[] stringArray) throws IOException, SQLException, MetadataException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(this.os);
        this.writeManifest(zipOutputStream);
        ExportTable[] exportTableArray = ExportTable.getExportTables(this.connection, this.schema);
        int n2 = 1;
        for (int i10 = 0; i10 < stringArray.length; i10 += 10) {
            String string = stringArray[i10];
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            String string10 = null;
            if (stringArray.length > i10 + 1) {
                string2 = stringArray[i10 + 1];
            }
            if (stringArray.length > i10 + 2) {
                string3 = stringArray[i10 + 2];
            }
            if (stringArray.length > i10 + 3) {
                string4 = stringArray[i10 + 3];
            }
            if (stringArray.length > i10 + 4) {
                string5 = stringArray[i10 + 4];
            }
            if (stringArray.length > i10 + 5) {
                string6 = stringArray[i10 + 5];
            }
            if (stringArray.length > i10 + 6) {
                string7 = stringArray[i10 + 6];
            }
            if (stringArray.length > i10 + 7) {
                string8 = stringArray[i10 + 7];
            }
            if (stringArray.length > i10 + 8) {
                string9 = stringArray[i10 + 8];
            }
            if (stringArray.length > i10 + 9) {
                string10 = stringArray[i10 + 9];
            }
            RowIteratorProviderByProject rowIteratorProviderByProject = new RowIteratorProviderByProject(this.connection, string, string2, string3, string4, string5, string6, string7, string8, string9, string10);
            this.exportZipGroup(rowIteratorProviderByProject, n2, zipOutputStream, exportTableArray);
            ++n2;
        }
        zipOutputStream.close();
    }

    public void exportRuntimeGroups(List<String> list, List<String> list2) throws IOException, SQLException, MetadataException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(this.os);
        this.writeManifest(zipOutputStream);
        ExportTable[] exportTableArray = ExportTable.getExportTables(this.connection, this.schema);
        int n2 = 1;
        for (int i10 = 0; i10 < list.size(); i10 += 5) {
            String string = list.get(i10);
            String string2 = list2.get(i10);
            String string3 = null;
            String string4 = null;
            if (list.size() > i10 + 1) {
                string3 = list.get(i10 + 1);
                string4 = list2.get(i10 + 1);
            }
            String string5 = null;
            String string6 = null;
            if (list.size() > i10 + 2) {
                string5 = list.get(i10 + 2);
                string6 = list2.get(i10 + 2);
            }
            String string7 = null;
            String string8 = null;
            if (list.size() > i10 + 3) {
                string7 = list.get(i10 + 3);
                string8 = list2.get(i10 + 3);
            }
            String string9 = null;
            String string10 = null;
            if (list.size() > i10 + 4) {
                string9 = list.get(i10 + 4);
                string10 = list2.get(i10 + 4);
            }
            RowIteratorProviderByGroup rowIteratorProviderByGroup = new RowIteratorProviderByGroup(this.connection, string, string2, string3, string4, string5, string6, string7, string8, string9, string10);
            this.exportZipGroup(rowIteratorProviderByGroup, n2, zipOutputStream, exportTableArray);
            ++n2;
        }
        zipOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportZipGroup(RowIteratorProvider rowIteratorProvider, int n2, ZipOutputStream zipOutputStream, ExportTable[] exportTableArray) throws MetadataException, IOException, SQLException {
        String string = GroupNameBase + n2;
        ZipEntry zipEntry = new ZipEntry(string + "/");
        zipOutputStream.putNextEntry(zipEntry);
        for (int i10 = 0; i10 < exportTableArray.length; ++i10) {
            RowIterator rowIterator = null;
            try {
                rowIterator = rowIteratorProvider.getIteratorFor(exportTableArray[i10]);
                this.exportTable(rowIterator, string, exportTableArray[i10], zipOutputStream);
                continue;
            }
            finally {
                if (rowIterator != null) {
                    rowIterator.close();
                }
            }
        }
        zipOutputStream.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportTable(RowIterator rowIterator, String string, ExportTable exportTable, ZipOutputStream zipOutputStream) throws SQLException, IOException {
        TableReader tableReader = null;
        try {
            tableReader = new TableReader(rowIterator, exportTable);
            ZipEntry zipEntry = new ZipEntry(string + "/" + exportTable.getTableName());
            zipOutputStream.putNextEntry(zipEntry);
            this.formatter.format(tableReader, zipOutputStream);
        }
        finally {
            try {
                zipOutputStream.closeEntry();
            }
            catch (Exception exception) {}
        }
    }

    private void writeManifest(ZipOutputStream zipOutputStream) throws IOException, MetadataException {
        zipOutputStream.putNextEntry(new ZipEntry("META-INF/"));
        zipOutputStream.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
        zipOutputStream.write(("Schema-Version: " + this.getSchemaVersion() + "\n").getBytes("UTF-8"));
        zipOutputStream.closeEntry();
    }

    private String getSchemaVersion() throws MetadataException {
        String string = "";
        RepositoryVersionImpl repositoryVersionImpl = RepositoryUtility.getPQRepositoryVersion(this.connection, this.schema);
        string = repositoryVersionImpl.getVersion() + "." + repositoryVersionImpl.getRelease() + "." + repositoryVersionImpl.getMod();
        return string;
    }

    private static class RowIteratorProviderByGroup
    implements RowIteratorProvider {
        private Connection c;
        private String g1;
        private String g2;
        private String g3;
        private String g4;
        private String g5;
        private String v1;
        private String v2;
        private String v3;
        private String v4;
        private String v5;

        public RowIteratorProviderByGroup(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
            this.c = connection;
            this.g1 = string;
            this.v1 = string2;
            this.g2 = string3;
            this.v2 = string4;
            this.g3 = string5;
            this.v3 = string6;
            this.g4 = string7;
            this.v4 = string8;
            this.g5 = string9;
            this.v5 = string10;
        }

        @Override
        public RowIterator getIteratorFor(ExportTable exportTable) throws MetadataException {
            return exportTable.getDataForGroups(this.c, this.g1, this.v1, this.g2, this.v2, this.g3, this.v3, this.g4, this.v4, this.g5, this.v5);
        }
    }

    private static class RowIteratorProviderByProject
    implements RowIteratorProvider {
        private String p1;
        private String p2;
        private String p3;
        private String p4;
        private String p5;
        private String p6;
        private String p7;
        private String p8;
        private String p9;
        private String p10 = null;
        private Connection c = null;

        public RowIteratorProviderByProject(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
            this.c = connection;
            this.p1 = string;
            this.p2 = string2;
            this.p3 = string3;
            this.p4 = string4;
            this.p5 = string5;
            this.p6 = string6;
            this.p7 = string7;
            this.p8 = string8;
            this.p9 = string9;
            this.p10 = string10;
        }

        @Override
        public RowIterator getIteratorFor(ExportTable exportTable) throws MetadataException {
            return exportTable.getDataForProjects(this.c, this.p1, this.p2, this.p3, this.p4, this.p5, this.p6, this.p7, this.p8, this.p9, this.p10);
        }
    }

    private static interface RowIteratorProvider {
        public RowIterator getIteratorFor(ExportTable var1) throws MetadataException;
    }
}

