/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import java.nio.ByteBuffer;
import java.util.Arrays;
import net.jpountz.lz4.LZ4ByteBufferUtils;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4UnsafeUtils;
import net.jpountz.lz4.LZ4Utils;
import net.jpountz.util.ByteBufferUtils;
import net.jpountz.util.UnsafeUtils;

final class LZ4HCJavaUnsafeCompressor
extends LZ4Compressor {
    public static final LZ4Compressor INSTANCE = new LZ4HCJavaUnsafeCompressor();
    private final int maxAttempts;
    final int compressionLevel;

    LZ4HCJavaUnsafeCompressor() {
        this(9);
    }

    LZ4HCJavaUnsafeCompressor(int n2) {
        this.maxAttempts = 1 << n2 - 1;
        this.compressionLevel = n2;
    }

    @Override
    public int compress(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        UnsafeUtils.checkRange(byArray, n2, n3);
        UnsafeUtils.checkRange(byArray2, n4, n5);
        int n6 = n2 + n3;
        int n7 = n4 + n5;
        int n8 = n6 - 12;
        int n9 = n6 - 5;
        int n10 = n2;
        int n11 = n4;
        int n12 = n10++;
        HashTable hashTable = new HashTable(n2);
        LZ4Utils.Match match = new LZ4Utils.Match();
        LZ4Utils.Match match2 = new LZ4Utils.Match();
        LZ4Utils.Match match3 = new LZ4Utils.Match();
        LZ4Utils.Match match4 = new LZ4Utils.Match();
        block0: while (n10 < n8) {
            if (!hashTable.insertAndFindBestMatch(byArray, n10, n9, match2)) {
                ++n10;
                continue;
            }
            LZ4Utils.copyTo(match2, match);
            block1: while (true) {
                assert (match2.start >= n12);
                if (match2.end() >= n8 || !hashTable.insertAndFindWiderMatch(byArray, match2.end() - 2, match2.start + 1, n9, match2.len, match3)) {
                    n11 = LZ4UnsafeUtils.encodeSequence(byArray, n12, match2.start, match2.ref, match2.len, byArray2, n11, n7);
                    n12 = n10 = match2.end();
                    continue block0;
                }
                if (match.start < match2.start && match3.start < match2.start + match.len) {
                    LZ4Utils.copyTo(match, match2);
                }
                assert (match3.start > match2.start);
                if (match3.start - match2.start < 3) {
                    LZ4Utils.copyTo(match3, match2);
                    continue;
                }
                while (true) {
                    int n13;
                    if (match3.start - match2.start < 18) {
                        int n14;
                        n13 = match2.len;
                        if (n13 > 18) {
                            n13 = 18;
                        }
                        if (match2.start + n13 > match3.end() - 4) {
                            n13 = match3.start - match2.start + match3.len - 4;
                        }
                        if ((n14 = n13 - (match3.start - match2.start)) > 0) {
                            match3.fix(n14);
                        }
                    }
                    if (match3.start + match3.len >= n8 || !hashTable.insertAndFindWiderMatch(byArray, match3.end() - 3, match3.start, n9, match3.len, match4)) {
                        if (match3.start < match2.end()) {
                            match2.len = match3.start - match2.start;
                        }
                        n11 = LZ4UnsafeUtils.encodeSequence(byArray, n12, match2.start, match2.ref, match2.len, byArray2, n11, n7);
                        n12 = n10 = match2.end();
                        n11 = LZ4UnsafeUtils.encodeSequence(byArray, n12, match3.start, match3.ref, match3.len, byArray2, n11, n7);
                        n12 = n10 = match3.end();
                        continue block0;
                    }
                    if (match4.start < match2.end() + 3) {
                        if (match4.start >= match2.end()) {
                            if (match3.start < match2.end()) {
                                n13 = match2.end() - match3.start;
                                match3.fix(n13);
                                if (match3.len < 4) {
                                    LZ4Utils.copyTo(match4, match3);
                                }
                            }
                            n11 = LZ4UnsafeUtils.encodeSequence(byArray, n12, match2.start, match2.ref, match2.len, byArray2, n11, n7);
                            n12 = n10 = match2.end();
                            LZ4Utils.copyTo(match4, match2);
                            LZ4Utils.copyTo(match3, match);
                            continue block1;
                        }
                        LZ4Utils.copyTo(match4, match3);
                        continue;
                    }
                    if (match3.start < match2.end()) {
                        if (match3.start - match2.start < 15) {
                            if (match2.len > 18) {
                                match2.len = 18;
                            }
                            if (match2.end() > match3.end() - 4) {
                                match2.len = match3.end() - match2.start - 4;
                            }
                            n13 = match2.end() - match3.start;
                            match3.fix(n13);
                        } else {
                            match2.len = match3.start - match2.start;
                        }
                    }
                    n11 = LZ4UnsafeUtils.encodeSequence(byArray, n12, match2.start, match2.ref, match2.len, byArray2, n11, n7);
                    n12 = n10 = match2.end();
                    LZ4Utils.copyTo(match3, match2);
                    LZ4Utils.copyTo(match4, match3);
                }
                break;
            }
        }
        n11 = LZ4UnsafeUtils.lastLiterals(byArray, n12, n6 - n12, byArray2, n11, n7);
        return n11 - n4;
    }

    @Override
    public int compress(ByteBuffer byteBuffer, int n2, int n3, ByteBuffer byteBuffer2, int n4, int n5) {
        if (byteBuffer.hasArray() && byteBuffer2.hasArray()) {
            return this.compress(byteBuffer.array(), n2 + byteBuffer.arrayOffset(), n3, byteBuffer2.array(), n4 + byteBuffer2.arrayOffset(), n5);
        }
        byteBuffer = ByteBufferUtils.inNativeByteOrder(byteBuffer);
        byteBuffer2 = ByteBufferUtils.inNativeByteOrder(byteBuffer2);
        ByteBufferUtils.checkRange(byteBuffer, n2, n3);
        ByteBufferUtils.checkRange(byteBuffer2, n4, n5);
        int n6 = n2 + n3;
        int n7 = n4 + n5;
        int n8 = n6 - 12;
        int n9 = n6 - 5;
        int n10 = n2;
        int n11 = n4;
        int n12 = n10++;
        HashTable hashTable = new HashTable(n2);
        LZ4Utils.Match match = new LZ4Utils.Match();
        LZ4Utils.Match match2 = new LZ4Utils.Match();
        LZ4Utils.Match match3 = new LZ4Utils.Match();
        LZ4Utils.Match match4 = new LZ4Utils.Match();
        block0: while (n10 < n8) {
            if (!hashTable.insertAndFindBestMatch(byteBuffer, n10, n9, match2)) {
                ++n10;
                continue;
            }
            LZ4Utils.copyTo(match2, match);
            block1: while (true) {
                assert (match2.start >= n12);
                if (match2.end() >= n8 || !hashTable.insertAndFindWiderMatch(byteBuffer, match2.end() - 2, match2.start + 1, n9, match2.len, match3)) {
                    n11 = LZ4ByteBufferUtils.encodeSequence(byteBuffer, n12, match2.start, match2.ref, match2.len, byteBuffer2, n11, n7);
                    n12 = n10 = match2.end();
                    continue block0;
                }
                if (match.start < match2.start && match3.start < match2.start + match.len) {
                    LZ4Utils.copyTo(match, match2);
                }
                assert (match3.start > match2.start);
                if (match3.start - match2.start < 3) {
                    LZ4Utils.copyTo(match3, match2);
                    continue;
                }
                while (true) {
                    int n13;
                    if (match3.start - match2.start < 18) {
                        int n14;
                        n13 = match2.len;
                        if (n13 > 18) {
                            n13 = 18;
                        }
                        if (match2.start + n13 > match3.end() - 4) {
                            n13 = match3.start - match2.start + match3.len - 4;
                        }
                        if ((n14 = n13 - (match3.start - match2.start)) > 0) {
                            match3.fix(n14);
                        }
                    }
                    if (match3.start + match3.len >= n8 || !hashTable.insertAndFindWiderMatch(byteBuffer, match3.end() - 3, match3.start, n9, match3.len, match4)) {
                        if (match3.start < match2.end()) {
                            match2.len = match3.start - match2.start;
                        }
                        n11 = LZ4ByteBufferUtils.encodeSequence(byteBuffer, n12, match2.start, match2.ref, match2.len, byteBuffer2, n11, n7);
                        n12 = n10 = match2.end();
                        n11 = LZ4ByteBufferUtils.encodeSequence(byteBuffer, n12, match3.start, match3.ref, match3.len, byteBuffer2, n11, n7);
                        n12 = n10 = match3.end();
                        continue block0;
                    }
                    if (match4.start < match2.end() + 3) {
                        if (match4.start >= match2.end()) {
                            if (match3.start < match2.end()) {
                                n13 = match2.end() - match3.start;
                                match3.fix(n13);
                                if (match3.len < 4) {
                                    LZ4Utils.copyTo(match4, match3);
                                }
                            }
                            n11 = LZ4ByteBufferUtils.encodeSequence(byteBuffer, n12, match2.start, match2.ref, match2.len, byteBuffer2, n11, n7);
                            n12 = n10 = match2.end();
                            LZ4Utils.copyTo(match4, match2);
                            LZ4Utils.copyTo(match3, match);
                            continue block1;
                        }
                        LZ4Utils.copyTo(match4, match3);
                        continue;
                    }
                    if (match3.start < match2.end()) {
                        if (match3.start - match2.start < 15) {
                            if (match2.len > 18) {
                                match2.len = 18;
                            }
                            if (match2.end() > match3.end() - 4) {
                                match2.len = match3.end() - match2.start - 4;
                            }
                            n13 = match2.end() - match3.start;
                            match3.fix(n13);
                        } else {
                            match2.len = match3.start - match2.start;
                        }
                    }
                    n11 = LZ4ByteBufferUtils.encodeSequence(byteBuffer, n12, match2.start, match2.ref, match2.len, byteBuffer2, n11, n7);
                    n12 = n10 = match2.end();
                    LZ4Utils.copyTo(match3, match2);
                    LZ4Utils.copyTo(match4, match3);
                }
                break;
            }
        }
        n11 = LZ4ByteBufferUtils.lastLiterals(byteBuffer, n12, n6 - n12, byteBuffer2, n11, n7);
        return n11 - n4;
    }

    private class HashTable {
        static final int MASK = 65535;
        int nextToUpdate;
        private final int base;
        private final int[] hashTable;
        private final short[] chainTable;

        HashTable(int n2) {
            this.base = n2;
            this.nextToUpdate = n2;
            this.hashTable = new int[32768];
            Arrays.fill(this.hashTable, -1);
            this.chainTable = new short[65536];
        }

        private int hashPointer(byte[] byArray, int n2) {
            int n3 = UnsafeUtils.readInt(byArray, n2);
            return this.hashPointer(n3);
        }

        private int hashPointer(ByteBuffer byteBuffer, int n2) {
            int n3 = ByteBufferUtils.readInt(byteBuffer, n2);
            return this.hashPointer(n3);
        }

        private int hashPointer(int n2) {
            int n3 = LZ4Utils.hashHC(n2);
            return this.hashTable[n3];
        }

        private int next(int n2) {
            return n2 - (this.chainTable[n2 & 0xFFFF] & 0xFFFF);
        }

        private void addHash(byte[] byArray, int n2) {
            int n3 = UnsafeUtils.readInt(byArray, n2);
            this.addHash(n3, n2);
        }

        private void addHash(ByteBuffer byteBuffer, int n2) {
            int n3 = ByteBufferUtils.readInt(byteBuffer, n2);
            this.addHash(n3, n2);
        }

        private void addHash(int n2, int n3) {
            int n4 = LZ4Utils.hashHC(n2);
            int n5 = n3 - this.hashTable[n4];
            assert (n5 > 0) : n5;
            if (n5 >= 65536) {
                n5 = 65535;
            }
            this.chainTable[n3 & 0xFFFF] = (short)n5;
            this.hashTable[n4] = n3;
        }

        void insert(int n2, byte[] byArray) {
            while (this.nextToUpdate < n2) {
                this.addHash(byArray, this.nextToUpdate);
                ++this.nextToUpdate;
            }
        }

        void insert(int n2, ByteBuffer byteBuffer) {
            while (this.nextToUpdate < n2) {
                this.addHash(byteBuffer, this.nextToUpdate);
                ++this.nextToUpdate;
            }
        }

        boolean insertAndFindBestMatch(byte[] byArray, int n2, int n3, LZ4Utils.Match match) {
            int n4;
            int n5;
            match.start = n2;
            match.len = 0;
            int n6 = 0;
            int n7 = 0;
            this.insert(n2, byArray);
            int n8 = this.hashPointer(byArray, n2);
            if (n8 >= n2 - 4 && n8 <= n2 && n8 >= this.base) {
                if (LZ4UnsafeUtils.readIntEquals(byArray, n8, n2)) {
                    n6 = n2 - n8;
                    n7 = match.len = 4 + LZ4UnsafeUtils.commonBytes(byArray, n8 + 4, n2 + 4, n3);
                    match.ref = n8;
                }
                n8 = this.next(n8);
            }
            for (n5 = 0; n5 < LZ4HCJavaUnsafeCompressor.this.maxAttempts && n8 >= Math.max(this.base, n2 - 65536 + 1) && n8 <= n2; ++n5) {
                if (LZ4UnsafeUtils.readIntEquals(byArray, n8, n2) && (n4 = 4 + LZ4UnsafeUtils.commonBytes(byArray, n8 + 4, n2 + 4, n3)) > match.len) {
                    match.ref = n8;
                    match.len = n4;
                }
                n8 = this.next(n8);
            }
            if (n7 != 0) {
                n4 = n2 + n7 - 3;
                for (n5 = n2; n5 < n4 - n6; ++n5) {
                    this.chainTable[n5 & 0xFFFF] = (short)n6;
                }
                do {
                    this.chainTable[n5 & 0xFFFF] = (short)n6;
                    this.hashTable[LZ4Utils.hashHC((int)UnsafeUtils.readInt((byte[])byArray, (int)n5))] = n5;
                } while (++n5 < n4);
                this.nextToUpdate = n4;
            }
            return match.len != 0;
        }

        boolean insertAndFindWiderMatch(byte[] byArray, int n2, int n3, int n4, int n5, LZ4Utils.Match match) {
            match.len = n5;
            this.insert(n2, byArray);
            int n6 = n2 - n3;
            int n7 = this.hashPointer(byArray, n2);
            for (int i10 = 0; i10 < LZ4HCJavaUnsafeCompressor.this.maxAttempts && n7 >= Math.max(this.base, n2 - 65536 + 1) && n7 <= n2; ++i10) {
                if (LZ4UnsafeUtils.readIntEquals(byArray, n7, n2)) {
                    int n8 = 4 + LZ4UnsafeUtils.commonBytes(byArray, n7 + 4, n2 + 4, n4);
                    int n9 = LZ4UnsafeUtils.commonBytesBackward(byArray, n7, n2, this.base, n3);
                    int n10 = n9 + n8;
                    if (n10 > match.len) {
                        match.len = n10;
                        match.ref = n7 - n9;
                        match.start = n2 - n9;
                    }
                }
                n7 = this.next(n7);
            }
            return match.len > n5;
        }

        boolean insertAndFindBestMatch(ByteBuffer byteBuffer, int n2, int n3, LZ4Utils.Match match) {
            int n4;
            int n5;
            match.start = n2;
            match.len = 0;
            int n6 = 0;
            int n7 = 0;
            this.insert(n2, byteBuffer);
            int n8 = this.hashPointer(byteBuffer, n2);
            if (n8 >= n2 - 4 && n8 <= n2 && n8 >= this.base) {
                if (LZ4ByteBufferUtils.readIntEquals(byteBuffer, n8, n2)) {
                    n6 = n2 - n8;
                    n7 = match.len = 4 + LZ4ByteBufferUtils.commonBytes(byteBuffer, n8 + 4, n2 + 4, n3);
                    match.ref = n8;
                }
                n8 = this.next(n8);
            }
            for (n5 = 0; n5 < LZ4HCJavaUnsafeCompressor.this.maxAttempts && n8 >= Math.max(this.base, n2 - 65536 + 1) && n8 <= n2; ++n5) {
                if (LZ4ByteBufferUtils.readIntEquals(byteBuffer, n8, n2) && (n4 = 4 + LZ4ByteBufferUtils.commonBytes(byteBuffer, n8 + 4, n2 + 4, n3)) > match.len) {
                    match.ref = n8;
                    match.len = n4;
                }
                n8 = this.next(n8);
            }
            if (n7 != 0) {
                n4 = n2 + n7 - 3;
                for (n5 = n2; n5 < n4 - n6; ++n5) {
                    this.chainTable[n5 & 0xFFFF] = (short)n6;
                }
                do {
                    this.chainTable[n5 & 0xFFFF] = (short)n6;
                    this.hashTable[LZ4Utils.hashHC((int)ByteBufferUtils.readInt((ByteBuffer)byteBuffer, (int)n5))] = n5;
                } while (++n5 < n4);
                this.nextToUpdate = n4;
            }
            return match.len != 0;
        }

        boolean insertAndFindWiderMatch(ByteBuffer byteBuffer, int n2, int n3, int n4, int n5, LZ4Utils.Match match) {
            match.len = n5;
            this.insert(n2, byteBuffer);
            int n6 = n2 - n3;
            int n7 = this.hashPointer(byteBuffer, n2);
            for (int i10 = 0; i10 < LZ4HCJavaUnsafeCompressor.this.maxAttempts && n7 >= Math.max(this.base, n2 - 65536 + 1) && n7 <= n2; ++i10) {
                if (LZ4ByteBufferUtils.readIntEquals(byteBuffer, n7, n2)) {
                    int n8 = 4 + LZ4ByteBufferUtils.commonBytes(byteBuffer, n7 + 4, n2 + 4, n4);
                    int n9 = LZ4ByteBufferUtils.commonBytesBackward(byteBuffer, n7, n2, this.base, n3);
                    int n10 = n9 + n8;
                    if (n10 > match.len) {
                        match.len = n10;
                        match.ref = n7 - n9;
                        match.start = n2 - n9;
                    }
                }
                n7 = this.next(n7);
            }
            return match.len > n5;
        }
    }
}

