/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.beetl.sql.core.BeetlSQLException;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.db.AbstractDBStyle;
import org.beetl.sql.core.db.TableDesc;
import org.beetl.sql.core.query.GroupBy;
import org.beetl.sql.core.query.OrderBy;
import org.beetl.sql.core.query.Query;
import org.beetl.sql.core.query.interfacer.QueryConditionI;
import org.beetl.sql.core.query.interfacer.StrongValue;

public class QueryCondition<T>
implements QueryConditionI<T> {
    public final String AND = "AND";
    public final String OR = "OR";
    public final String WHERE = "WHERE";
    public final String IN = "IN";
    public final String NOT_IN = "NOT IN";
    public final String BETWEEN = "BETWEEN";
    public final String NOT_BETWEEN = "NOT BETWEEN";
    public SQLManager sqlManager;
    protected StringBuilder sql = null;
    protected List<Object> params = new ArrayList<Object>();
    protected long startRow = -1L;
    protected long pageSize = -1L;
    protected OrderBy orderBy = null;
    protected GroupBy groupBy = null;

    protected QueryCondition() {
    }

    protected void clear() {
        this.sql = null;
        this.params = new ArrayList<Object>();
        this.startRow = -1L;
        this.pageSize = -1L;
        this.orderBy = null;
        this.groupBy = null;
    }

    protected String getCol(String colName) {
        return " " + this.sqlManager.getDbStyle().getKeyWordHandler().getCol(colName) + " ";
    }

    public String getTableName(Class<?> c) {
        String tname = this.sqlManager.getNc().getTableName(c);
        TableDesc desc = this.sqlManager.getMetaDataManager().getTable(tname);
        String tabeName2 = desc.getName();
        int index = -1;
        AbstractDBStyle style = (AbstractDBStyle)this.sqlManager.getDbStyle();
        index = tabeName2.indexOf(style.STATEMENT_START);
        if (index != -1) {
            tabeName2 = tabeName2.substring(0, index) + "\\" + tabeName2.substring(index);
        }
        if (desc.getSchema() != null) {
            return style.getKeyWordHandler().getTable(desc.getSchema()) + "." + style.getKeyWordHandler().getTable(tabeName2);
        }
        return style.getKeyWordHandler().getTable(tabeName2);
    }

    public Query<T> appendSql(String sqlPart) {
        if (this.sql == null) {
            this.sql = new StringBuilder();
        }
        this.sql.append(sqlPart);
        return (Query)this;
    }

    public Query<T> addParam(Collection<?> objects) {
        this.params.addAll(objects);
        return (Query)this;
    }

    public Query<T> addPreParam(List<Object> objects) {
        objects.addAll(this.params);
        this.params = objects;
        return (Query)this;
    }

    public Query<T> addParam(Object object) {
        this.params.add(object);
        return (Query)this;
    }

    protected void appendAndSql(String column, Object value, String opt) {
        this.appendSqlBase(column, value, opt, "AND");
    }

    protected void appendOrSql(String column, Object value, String opt) {
        this.appendSqlBase(column, value, opt, "OR");
    }

    protected void appendSqlBase(String column, Object value, String opt, String link) {
        if (value instanceof StrongValue) {
            if (!((StrongValue)value).isEffective()) {
                return;
            }
            value = ((StrongValue)value).getValue();
        }
        if (this.getSql().indexOf("WHERE") < 0) {
            link = "WHERE";
        }
        this.appendSql(link).appendSql(this.getCol(column)).appendSql(opt);
        if (value != null) {
            this.appendSql(" ? ");
            this.addParam(value);
        }
    }

    protected void appendInSql(String column, Object value, String opt, String link) {
        if (value instanceof StrongValue) {
            if (!((StrongValue)value).isEffective()) {
                return;
            }
            value = ((StrongValue)value).getValue();
        }
        if (this.getSql().indexOf("WHERE") < 0) {
            link = "WHERE";
        }
        this.appendSql(link).appendSql(this.getCol(column)).appendSql(opt).appendSql(" ( ");
        for (Object o : (Collection)value) {
            this.appendSql(" ? ,");
            this.addParam(o);
        }
        this.getSql().deleteCharAt(this.getSql().length() - 1);
        this.appendSql(" ) ");
    }

    protected void appendBetweenSql(String column, String opt, String link, Object ... value) {
        if (this.getSql().indexOf("WHERE") < 0) {
            link = "WHERE";
        }
        this.appendSql(link).appendSql(this.getCol(column)).appendSql(opt).appendSql(" ? AND ? ");
        this.addParam(value[0]);
        this.addParam(value[1]);
    }

    @Override
    public Query<T> andEq(String column, Object value) {
        this.appendAndSql(column, value, "=");
        return (Query)this;
    }

    @Override
    public Query<T> andNotEq(String column, Object value) {
        this.appendAndSql(column, value, "<>");
        return (Query)this;
    }

    @Override
    public Query<T> andGreat(String column, Object value) {
        this.appendAndSql(column, value, ">");
        return (Query)this;
    }

    @Override
    public Query<T> andGreatEq(String column, Object value) {
        this.appendAndSql(column, value, ">=");
        return (Query)this;
    }

    @Override
    public Query<T> andLess(String column, Object value) {
        this.appendAndSql(column, value, "<");
        return (Query)this;
    }

    @Override
    public Query<T> andLessEq(String column, Object value) {
        this.appendAndSql(column, value, "<=");
        return (Query)this;
    }

    @Override
    public Query<T> andLike(String column, String value) {
        this.appendAndSql(column, value, "LIKE ");
        return (Query)this;
    }

    @Override
    public Query<T> andNotLike(String column, String value) {
        this.appendAndSql(column, value, "NOT LIKE ");
        return (Query)this;
    }

    @Override
    public Query<T> andIsNull(String column) {
        this.appendAndSql(column, null, "IS NULL ");
        return (Query)this;
    }

    @Override
    public Query<T> andIsNotNull(String column) {
        this.appendAndSql(column, null, "IS NOT NULL ");
        return (Query)this;
    }

    @Override
    public Query<T> andIn(String column, Collection<?> value) {
        this.appendInSql(column, value, "IN", "AND");
        return (Query)this;
    }

    @Override
    public Query<T> andNotIn(String column, Collection<?> value) {
        this.appendInSql(column, value, "NOT IN", "AND");
        return (Query)this;
    }

    @Override
    public Query<T> andBetween(String column, Object value1, Object value2) {
        this.appendBetweenSql(column, "BETWEEN", "AND", value1, value2);
        return (Query)this;
    }

    @Override
    public Query<T> andNotBetween(String column, Object value1, Object value2) {
        this.appendBetweenSql(column, "NOT BETWEEN", "AND", value1, value2);
        return (Query)this;
    }

    @Override
    public Query<T> orEq(String column, Object value) {
        this.appendOrSql(column, value, "=");
        return (Query)this;
    }

    @Override
    public Query<T> orNotEq(String column, Object value) {
        this.appendOrSql(column, value, "<>");
        return (Query)this;
    }

    @Override
    public Query<T> orGreat(String column, Object value) {
        this.appendOrSql(column, value, ">");
        return (Query)this;
    }

    @Override
    public Query<T> orGreatEq(String column, Object value) {
        this.appendOrSql(column, value, ">=");
        return (Query)this;
    }

    @Override
    public Query<T> orLess(String column, Object value) {
        this.appendOrSql(column, value, "<");
        return (Query)this;
    }

    @Override
    public Query<T> orLessEq(String column, Object value) {
        this.appendOrSql(column, value, "<=");
        return (Query)this;
    }

    @Override
    public Query<T> orLike(String column, String value) {
        this.appendOrSql(column, value, "LIKE");
        return (Query)this;
    }

    @Override
    public Query<T> orNotLike(String column, String value) {
        this.appendOrSql(column, value, "NOT LIKE");
        return (Query)this;
    }

    @Override
    public Query<T> orIsNull(String column) {
        this.appendOrSql(column, null, "IS NULL ");
        return (Query)this;
    }

    @Override
    public Query<T> orIsNotNull(String column) {
        this.appendOrSql(column, null, "IS NOT NULL ");
        return (Query)this;
    }

    @Override
    public Query<T> orIn(String column, Collection<?> value) {
        this.appendInSql(column, value, "IN", "OR");
        return (Query)this;
    }

    @Override
    public Query<T> orNotIn(String column, Collection<?> value) {
        this.appendInSql(column, value, "NOT IN", "OR");
        return (Query)this;
    }

    @Override
    public Query<T> orBetween(String column, Object value1, Object value2) {
        this.appendBetweenSql(column, "BETWEEN", "OR", value1, value2);
        return (Query)this;
    }

    @Override
    public Query<T> orNotBetween(String column, Object value1, Object value2) {
        this.appendBetweenSql(column, "NOT BETWEEN", "OR", value1, value2);
        return (Query)this;
    }

    @Override
    public Query<T> and(QueryCondition condition) {
        return this.manyCondition(condition, "AND");
    }

    @Override
    public Query<T> or(QueryCondition condition) {
        return this.manyCondition(condition, "OR");
    }

    private Query<T> manyCondition(QueryCondition condition, String link) {
        if (!(condition instanceof QueryCondition)) {
            throw new BeetlSQLException(20, "\u8fde\u63a5\u6761\u4ef6\u5fc5\u987b\u662f\u4e00\u4e2a QueryCondition \u7c7b\u578b");
        }
        int i = condition.getSql().indexOf("WHERE");
        if (i > -1) {
            condition.getSql().delete(i, i + 5);
        }
        if (this.getSql().indexOf("WHERE") < 0) {
            link = "WHERE";
        }
        this.appendSql(link).appendSql(" (").appendSql(condition.getSql().toString()).appendSql(")");
        this.addParam(condition.getParams());
        return (Query)this;
    }

    @Override
    public StringBuilder getSql() {
        if (this.sql == null) {
            return new StringBuilder();
        }
        return this.sql;
    }

    @Override
    public void setSql(StringBuilder sql) {
        this.sql = sql;
    }

    @Override
    public List<Object> getParams() {
        return this.params;
    }
}

