/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.sql.core.BeetlSQLException;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLReady;
import org.beetl.sql.core.annotatoin.Sql;
import org.beetl.sql.core.annotatoin.SqlProvider;
import org.beetl.sql.core.annotatoin.SqlResource;
import org.beetl.sql.core.engine.PageQuery;
import org.beetl.sql.core.kit.StringKit;
import org.beetl.sql.core.mapper.DefaultMapperBuilder;
import org.beetl.sql.core.mapper.MapperInvoke;
import org.beetl.sql.core.mapper.MethodDesc;
import org.beetl.sql.core.mapper.builder.MapperConfig;
import org.beetl.sql.core.mapper.builder.MapperInvokeDataConfig;
import org.beetl.sql.core.mapper.para.PageQueryParamter;

public class MapperJavaProxy
implements InvocationHandler {
    protected SQLManager sqlManager;
    protected Class<?> entityClass;
    protected DefaultMapperBuilder builder;
    protected MapperConfig mapperConfig;
    protected Class mapperInterface;
    private static final Map<Class, Object> PROVIDERS_CACHE = new ConcurrentHashMap<Class, Object>();

    public MapperJavaProxy() {
    }

    public MapperJavaProxy(DefaultMapperBuilder builder, SQLManager sqlManager, Class<?> mapperInterface) {
        this.sqlManager = sqlManager;
        this.builder = builder;
        this.mapperInterface(mapperInterface);
        this.mapperInterface = mapperInterface;
    }

    public MapperJavaProxy mapperInterface(Class<?> mapperInterface) {
        this.onResolveEntityClassFromMapperInterface(mapperInterface);
        return this;
    }

    public MapperJavaProxy entityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
        return this;
    }

    protected void checkArgs() {
    }

    public MapperJavaProxy build() {
        this.checkArgs();
        return this;
    }

    protected void onResolveEntityClassFromMapperInterface(Class<?> mapperInterface) {
        if (mapperInterface.isInterface()) {
            ParameterizedType pt;
            Type[] faces = mapperInterface.getGenericInterfaces();
            if (faces.length > 0 && faces[0] instanceof ParameterizedType && (pt = (ParameterizedType)faces[0]).getActualTypeArguments().length > 0) {
                this.entityClass = (Class)pt.getActualTypeArguments()[0];
            }
        } else {
            throw new IllegalArgumentException("mapperInterface is not interface.");
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> caller = method.getDeclaringClass();
        String methodName = method.getName();
        if (methodName.equals("toString")) {
            return "BeetlSql Mapper " + this.mapperInterface;
        }
        SqlResource resource = this.getSqlResourece(method);
        String sqlId = null;
        if (resource != null) {
            String preffix = resource.value();
            String name = method.getName();
            sqlId = preffix + "." + name;
        } else {
            sqlId = this.builder.getIdGen().getId(method.getDeclaringClass(), this.entityClass, method);
        }
        MapperInvoke invoke = this.sqlManager.getMapperConfig().getAmi(caller, methodName);
        if (invoke != null) {
            return invoke.call(this.sqlManager, this.entityClass, sqlId, method, args);
        }
        Sql sqlAnnotation = method.getAnnotation(Sql.class);
        if (sqlAnnotation != null) {
            MethodDesc desc = null;
            String jdbcSql = sqlAnnotation.value();
            Object ret = null;
            if (jdbcSql != null && jdbcSql.trim().length() != 0) {
                desc = MethodDesc.getMetodDescBySqlReadyProviderWithCache(this.sqlManager, this.entityClass, method, jdbcSql);
                invoke = MapperInvokeDataConfig.getSQLReadyProxy();
                ret = invoke.call(this.sqlManager, this.entityClass, desc.sqlReady, method, args);
            } else {
                SqlProvider sqlProvider = method.getAnnotation(SqlProvider.class);
                SQLReady sqlReady = this.getSQLReadyByProvider(sqlProvider, method, args);
                desc = MethodDesc.getMetodDescBySqlReadyProvider(this.sqlManager, this.entityClass, method, sqlReady.getSql());
                ret = this.executeSqlReady(desc, sqlReady);
            }
            return ret;
        }
        SqlProvider statementProvider = method.getAnnotation(SqlProvider.class);
        if (statementProvider != null) {
            String sqlTemplate = this.getSQLTemplateProvider(statementProvider, method, args);
            MethodDesc desc = MethodDesc.getMetodDescByTemplateProvider(this.sqlManager, this.entityClass, method, sqlTemplate);
            return this.executeSqlTemplate(desc, sqlTemplate, args);
        }
        MethodDesc desc = MethodDesc.getMetodDescBySqlId(this.sqlManager, this.entityClass, method, sqlId);
        invoke = MapperInvokeDataConfig.getMethodDescProxy(desc.type);
        Object ret = invoke.call(this.sqlManager, this.entityClass, sqlId, method, args);
        return ret;
    }

    protected SqlResource getSqlResourece(Method method) {
        SqlResource sqlResource = method.getAnnotation(SqlResource.class);
        if (sqlResource != null) {
            return sqlResource;
        }
        sqlResource = method.getDeclaringClass().getAnnotation(SqlResource.class);
        if (sqlResource != null) {
            return sqlResource;
        }
        sqlResource = this.mapperInterface.getAnnotation(SqlResource.class);
        if (sqlResource != null) {
            return sqlResource;
        }
        return null;
    }

    public String toString() {
        return " Proxy";
    }

    protected Object executeSqlTemplate(MethodDesc desc, String sqlTemplate, Object[] args) {
        int type = desc.type;
        Object para = desc.parameter.get(args);
        if (type == 2 || type == 3) {
            Class returnType = desc.resultType;
            List list = this.sqlManager.execute(sqlTemplate, desc.resultType, para);
            if (type == 2) {
                return list.size() == 0 ? null : list.get(0);
            }
            return list;
        }
        if (type == 6) {
            PageQuery query = (PageQuery)para;
            query = this.sqlManager.executePageQuery(sqlTemplate, desc.resultType, query);
            return query;
        }
        return this.sqlManager.executeUpdate(sqlTemplate, para);
    }

    protected Object executeSqlReady(MethodDesc desc, SQLReady sqlReady) {
        int type = desc.type;
        if (type == 2 || type == 3) {
            Class returnType = desc.resultType;
            List list = this.sqlManager.execute(sqlReady, returnType);
            if (type == 2) {
                return list.size() == 0 ? null : list.get(0);
            }
            return list;
        }
        if (type == 7) {
            PageQueryParamter parameter = (PageQueryParamter)desc.parameter;
            PageQuery pageQuery = (PageQuery)parameter.get(sqlReady.getArgs());
            Object[] jdcbArgs = parameter.getJdbcArgs(sqlReady.getArgs());
            this.sqlManager.execute(new SQLReady(sqlReady.getSql(), jdcbArgs), this.entityClass, pageQuery);
            return pageQuery;
        }
        return this.sqlManager.executeUpdate(sqlReady);
    }

    protected SQLReady getSQLReadyByProvider(SqlProvider sqlProvider, Method owner, Object[] args) {
        Class<?> providerCls = null;
        String providerMethodName = null;
        try {
            Method providerMethod;
            providerCls = sqlProvider.provider();
            Object provider = PROVIDERS_CACHE.get(providerCls);
            providerMethodName = sqlProvider.method();
            if (StringKit.isBlank(providerMethodName)) {
                providerMethodName = owner.getName();
            }
            if (provider == null) {
                provider = providerCls.newInstance();
                PROVIDERS_CACHE.put(providerCls, provider);
            }
            if ((providerMethod = providerCls.getMethod(providerMethodName, owner.getParameterTypes())).getReturnType() != SQLReady.class) {
                throw new BeetlSQLException(23, "SqlProvider\u7c7b[" + providerCls.getName() + "]\u7684\u65b9\u6cd5[" + providerMethodName + "]\u8fd4\u56de\u503c\u5fc5\u987b\u4e3aSqlReady\u7c7b\u578b");
            }
            providerMethod.setAccessible(Boolean.TRUE);
            SQLReady sqlReady = (SQLReady)providerMethod.invoke(provider, args);
            return sqlReady;
        }
        catch (IllegalAccessException e) {
            throw new BeetlSQLException(23, "\u5b9e\u4f8b\u5316" + providerCls.getName() + "\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u516c\u6709\u7684\u65e0\u53c2\u6784\u9020");
        }
        catch (InstantiationException e) {
            throw new BeetlSQLException(23, "\u5b9e\u4f8b\u5316" + providerCls.getName() + "\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u516c\u6709\u7684\u65e0\u53c2\u6784\u9020");
        }
        catch (InvocationTargetException e) {
            throw new BeetlSQLException(23, "\u8c03\u7528Provder\u65b9\u6cd5\u51fa\u9519" + e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new BeetlSQLException(23, "\u672a\u80fd\u4ece" + providerCls.getName() + "\u83b7\u53d6\u5230" + providerMethodName + " \u65b9\u6cd5");
        }
    }

    protected String getSQLTemplateProvider(SqlProvider sqlProvider, Method owner, Object[] args) {
        Class<?> providerCls = null;
        String providerMethodName = null;
        try {
            Method providerMethod;
            providerCls = sqlProvider.provider();
            Object provider = PROVIDERS_CACHE.get(providerCls);
            providerMethodName = sqlProvider.method();
            if (StringKit.isBlank(providerMethodName)) {
                providerMethodName = owner.getName();
            }
            if (provider == null) {
                provider = providerCls.newInstance();
                PROVIDERS_CACHE.put(providerCls, provider);
            }
            if ((providerMethod = providerCls.getMethod(providerMethodName, owner.getParameterTypes())).getReturnType() != String.class) {
                throw new BeetlSQLException(23, "SqlProvider\u7c7b[" + providerCls.getName() + "]\u7684\u65b9\u6cd5[" + providerMethodName + "]\u8fd4\u56de\u503c\u5fc5\u987b\u4e3aSqlReady\u7c7b\u578b");
            }
            providerMethod.setAccessible(Boolean.TRUE);
            String sqlTemplate = (String)providerMethod.invoke(provider, args);
            return sqlTemplate;
        }
        catch (IllegalAccessException e) {
            throw new BeetlSQLException(23, "\u5b9e\u4f8b\u5316" + providerCls.getName() + "\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u516c\u6709\u7684\u65e0\u53c2\u6784\u9020");
        }
        catch (InstantiationException e) {
            throw new BeetlSQLException(23, "\u5b9e\u4f8b\u5316" + providerCls.getName() + "\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u516c\u6709\u7684\u65e0\u53c2\u6784\u9020");
        }
        catch (InvocationTargetException e) {
            throw new BeetlSQLException(23, "\u8c03\u7528Provder\u65b9\u6cd5\u51fa\u9519" + e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new BeetlSQLException(23, "\u672a\u80fd\u4ece" + providerCls.getName() + "\u83b7\u53d6\u5230" + providerMethodName + " \u65b9\u6cd5");
        }
    }
}

