/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.ext.spring;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.beetl.core.GroupTemplate;
import org.beetl.ext.spring.BeetlGroupUtilConfiguration;
import org.beetl.ext.spring.BeetlSpringView;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.web.servlet.view.AbstractTemplateViewResolver;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class BeetlSpringViewResolver
extends AbstractTemplateViewResolver
implements InitializingBean,
BeanNameAware {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String beanName = null;
    private BeetlGroupUtilConfiguration config;
    private GroupTemplate groupTemplate = null;

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setGroupTemplate(GroupTemplate groupTemplate) {
        this.groupTemplate = groupTemplate;
    }

    public BeetlSpringViewResolver() {
        this.setViewClass(BeetlSpringView.class);
    }

    public void afterPropertiesSet() throws NoSuchBeanDefinitionException, NoUniqueBeanDefinitionException, SecurityException, NoSuchFieldException {
        if (this.config == null) {
            this.config = (BeetlGroupUtilConfiguration)this.getApplicationContext().getBean(BeetlGroupUtilConfiguration.class);
            this.groupTemplate = this.config.getGroupTemplate();
        }
        if (this.getContentType() == null) {
            String charset = this.groupTemplate.getConf().getCharset();
            this.setContentType("text/html;charset=" + charset);
        }
    }

    protected Class<BeetlSpringView> requiredViewClass() {
        return BeetlSpringView.class;
    }

    protected AbstractUrlBasedView buildView(String viewName) throws Exception {
        BeetlSpringView beetlView = (BeetlSpringView)super.buildView(viewName);
        beetlView.setGroupTemplate(this.groupTemplate);
        String suffix = this.getSuffix();
        if (suffix != null && suffix.length() != 0 && viewName.contains("#")) {
            String[] split = viewName.split("#");
            if (split.length > 2) {
                throw new Exception("\u89c6\u56fe\u540d\u79f0\u6709\u8bef\uff1a" + viewName);
            }
            beetlView.setUrl(this.getPrefix() + split[0] + this.getSuffix() + "#" + split[1]);
        }
        return beetlView;
    }

    public static String redirect(String url) {
        return "redirect:" + url;
    }

    public static String forward(String url) {
        return "forward:" + url;
    }

    public BeetlGroupUtilConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(BeetlGroupUtilConfiguration config) {
        this.config = config;
        this.groupTemplate = config.getGroupTemplate();
    }

    public void setPrefix(String prefix) {
        this.logger.warn((Object)"Beetl\u4e0d\u5efa\u8bae\u4f7f\u7528\u4f7f\u7528spring\u524d\u7f00\uff0c\u4f1a\u5bfc\u81f4include,layout\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6a21\u677f\uff0c\u8bf7\u4f7f\u7528beetl\u7684\u914d\u7f6eRESOURCE.ROOT\u6765\u914d\u7f6e\u6a21\u677f\u6839\u76ee\u5f55");
        super.setPrefix(prefix);
    }
}

