/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.ext.spring;

import java.util.Collection;
import java.util.Collections;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.JavaScriptUtils;

public class UtilsFunctionPackage {
    public boolean containsAny(Collection<?> source, Collection<?> candidates) {
        return CollectionUtils.containsAny(source, candidates);
    }

    public Object findFirstMatch(Collection<?> source, Collection<?> candidates) {
        return CollectionUtils.findFirstMatch(source, candidates);
    }

    public boolean antMatch(String input, String ... patterns) {
        return PatternMatchUtils.simpleMatch((String[])patterns, (String)input);
    }

    public String fileExtension(String path) {
        return StringUtils.getFilenameExtension((String)path);
    }

    public boolean endsWithIgnoreCase(String input, String suffix) {
        return StringUtils.endsWithIgnoreCase((String)input, (String)suffix);
    }

    public boolean startsWithIgnoreCase(String input, String prefix) {
        return StringUtils.startsWithIgnoreCase((String)input, (String)prefix);
    }

    public boolean isBlank(String input) {
        return !StringUtils.hasText((String)input);
    }

    public String capitalize(String input) {
        return StringUtils.capitalize((String)input);
    }

    public String uncapitalize(String input) {
        return StringUtils.uncapitalize((String)input);
    }

    public String join(Object collection, String delim) {
        return this.joinEx(collection, delim, "", "");
    }

    public String joinEx(Object collection, String delim, String prefix, String suffix) {
        if (collection == null) {
            return StringUtils.collectionToDelimitedString(Collections.emptyList(), (String)delim, (String)prefix, (String)suffix);
        }
        if (collection instanceof Collection) {
            return StringUtils.collectionToDelimitedString((Collection)((Collection)collection), (String)delim, (String)prefix, (String)suffix);
        }
        if (collection.getClass().isArray()) {
            return StringUtils.collectionToDelimitedString((Collection)CollectionUtils.arrayToList((Object)collection), (String)delim, (String)prefix, (String)suffix);
        }
        return StringUtils.collectionToDelimitedString(Collections.singletonList(collection), (String)delim, (String)prefix, (String)suffix);
    }

    public String html(String input) {
        return HtmlUtils.htmlEscape((String)input);
    }

    public String javaScript(String input) {
        return JavaScriptUtils.javaScriptEscape((String)input);
    }
}

