/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.text;

import java.util.Stack;
import org.beetl.core.text.Source;

public class HtmlTagConfig {
    String htmlTagStart = "<#";
    String htmlTagEnd = "</#";
    String htmlTagBindingAttribute = "var";
    char[] start = null;
    char[] end = null;
    String phStart = "${";
    String phEnd = "}";
    Stack<String> htmlTagStack = new Stack();
    Source source = null;

    public HtmlTagConfig(String htmlTagStart, String htmlTagEnd, String htmlTagBindingAttribute) {
        this.htmlTagStart = htmlTagStart;
        this.htmlTagEnd = htmlTagEnd;
        this.htmlTagBindingAttribute = htmlTagBindingAttribute;
        this.start = htmlTagStart.toCharArray();
        this.end = this.htmlTagEnd.toCharArray();
    }

    public HtmlTagConfig() {
        this.start = this.htmlTagStart.toCharArray();
        this.end = this.htmlTagEnd.toCharArray();
    }

    public void init(Source source) {
        this.source = source;
        this.phStart = new String(source.pd.start);
        this.phEnd = new String(source.pd.end);
    }

    public boolean matchTagStart() {
        return this.source.matchAndSKip(this.start);
    }

    public boolean matchTagEnd() {
        return this.source.matchAndSKip(this.end);
    }

    public String getHtmlTagStart() {
        return this.htmlTagStart;
    }

    public void setHtmlTagStart(String htmlTagStart) {
        this.htmlTagStart = htmlTagStart;
    }

    public String getHtmlTagEnd() {
        return this.htmlTagEnd;
    }

    public void setHtmlTagEnd(String htmlTagEnd) {
        this.htmlTagEnd = htmlTagEnd;
    }

    public String getHtmlTagBindingAttribute() {
        return this.htmlTagBindingAttribute;
    }

    public void setHtmlTagBindingAttribute(String htmlTagBindingAttribute) {
        this.htmlTagBindingAttribute = htmlTagBindingAttribute;
    }

    public Stack getHtmlTagStack() {
        return this.htmlTagStack;
    }

    public void setHtmlTagStack(Stack htmlTagStack) {
        this.htmlTagStack = htmlTagStack;
    }
}

