/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.ext.simulate;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beetl.core.GroupTemplate;
import org.beetl.core.exception.ScriptEvalError;
import org.beetl.ext.simulate.BaseSimulate;
import org.beetl.ext.simulate.JsonUtil;
import org.beetl.ext.simulate.SimulateException;
import org.beetl.ext.web.WebRender;

public class WebSimulate
extends BaseSimulate {
    public WebSimulate(GroupTemplate gt) {
        this(gt, null, "/values");
    }

    public WebSimulate(GroupTemplate gt, JsonUtil jsonUtil) {
        this(gt, jsonUtil, "/values");
    }

    public WebSimulate(GroupTemplate gt, JsonUtil jsonUtil, String base) {
        super(gt, jsonUtil, base);
    }

    public void execute(HttpServletRequest req, HttpServletResponse rsp) {
        String path = this.getValuePath(req);
        BaseSimulate.RestPath restPath = this.getRealPath(path, req.getMethod().toLowerCase());
        if (restPath == null) {
            this.handleNullPath(req, rsp);
            return;
        }
        String valueFile = restPath.path;
        WebRender render = new WebRender(this.gt);
        Map paras = this.getScriptParas(req, rsp);
        String commonFile = this.getCommonValueFile(req, rsp);
        Map commonData = new HashMap();
        Map data = new HashMap();
        try {
            if (commonFile != null && this.gt.getResourceLoader().exist(commonFile)) {
                commonData = this.gt.runScript(commonFile, paras);
            }
            paras.put("pathVars", restPath.values);
            if (valueFile != null) {
                data = this.gt.runScript(valueFile, paras);
            }
        }
        catch (ScriptEvalError e) {
            throw new SimulateException("\u4f2a\u6a21\u578b\u811a\u672c\u6709\u9519\uff01", e);
        }
        commonData.putAll(data);
        if (commonData.containsKey("json")) {
            rsp.setContentType("text/json; charset=utf-8");
            Object jsonData = commonData.get("json");
            if (jsonData instanceof String) {
                this.output((String)jsonData, rsp);
            } else {
                if (this.jsonUtil == null) {
                    throw new SimulateException("\u6a21\u62df\u5c5e\u6027\u91c7\u7528\u4e86json\uff0c\u4f46\u6ca1\u6709\u8bbe\u7f6eJsonUtil");
                }
                String str = null;
                try {
                    str = this.jsonUtil.toJson(jsonData);
                }
                catch (Exception e) {
                    throw new SimulateException("\u5e8f\u5217\u5316JSON\u51fa\u9519", e);
                }
                this.output(str, rsp);
            }
            return;
        }
        String ajaxFlag = null;
        if (data.containsKey("ajax")) {
            ajaxFlag = (String)data.get("ajax");
        }
        for (String key : commonData.keySet()) {
            Object value = commonData.get(key);
            this.setValue(key, value, req);
        }
        String renderPath = null;
        renderPath = commonData.containsKey("view") ? (String)commonData.get("view") : this.getRenderPath(req);
        if (ajaxFlag != null) {
            renderPath = renderPath + "#" + ajaxFlag;
        }
        render.render(renderPath, req, rsp, new Object[0]);
    }

    protected String getRenderPath(HttpServletRequest request) {
        return request.getServletPath();
    }

    protected void handleNullPath(HttpServletRequest req, HttpServletResponse rsp) {
        String commonFile = this.getCommonValueFile(req, rsp);
        Map commonData = new HashMap();
        if (commonFile != null && this.gt.getResourceLoader().exist(commonFile)) {
            try {
                commonData = this.gt.runScript(commonFile, new HashMap<String, Object>());
            }
            catch (ScriptEvalError e) {
                throw new SimulateException("\u4f2a\u6a21\u578b\u811a\u672c\u6709\u9519\uff01", e);
            }
        }
        for (String key : commonData.keySet()) {
            Object value = commonData.get(key);
            this.setValue(key, value, req);
        }
        String path = this.getRenderPath(req);
        WebRender render = new WebRender(this.gt);
        render.render(path, req, rsp, null);
    }
}

