/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;
import org.beetl.core.ContextLocalBuffer;

public class DefaultEncoder {
    private final CharsetEncoder charsetEncoder;
    private final double expansionFactor;
    ContextLocalBuffer localBuffer = null;

    public DefaultEncoder(String encoding, ContextLocalBuffer localBuffer) {
        this.charsetEncoder = DefaultEncoder.newEncoder(encoding);
        this.expansionFactor = this.charsetEncoder.maxBytesPerChar();
        this.localBuffer = localBuffer;
    }

    public void write(String str, OutputStream out) throws IOException {
        int len = str.length();
        char[] buffer = this.localBuffer.getCharBuffer(len);
        if (buffer.length != 0) {
            str.getChars(0, len, buffer, 0);
            this.write(buffer, len, out);
        } else {
            this.write(str.toCharArray(), len, out);
        }
    }

    public void write(char[] chars, int len, OutputStream out) throws IOException {
        if (chars != null && len != 0) {
            byte[] buffer = this.localBuffer.getByteBuffer((int)((double)len * this.expansionFactor));
            if (buffer.length != 0) {
                CharsetEncoder encoder = this.charsetEncoder;
                ByteBuffer bb = ByteBuffer.wrap(buffer);
                encoder.reset().encode(CharBuffer.wrap(chars, 0, len), bb, true);
                encoder.flush(bb);
                out.write(buffer, 0, bb.position());
            } else {
                buffer = new byte[(int)((double)len * this.expansionFactor)];
                CharsetEncoder encoder = this.charsetEncoder;
                ByteBuffer bb = ByteBuffer.wrap(buffer);
                encoder.reset().encode(CharBuffer.wrap(chars, 0, len), bb, true);
                encoder.flush(bb);
                out.write(buffer, 0, bb.position());
            }
        }
    }

    private static CharsetEncoder newEncoder(String csn) throws UnsupportedCharsetException {
        return Charset.forName(csn).newEncoder();
    }
}

