/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.waf.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class UpdateValueListRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="name")
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="values")
    private List<String> values = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="description")
    private String description;

    public UpdateValueListRequestBody withName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UpdateValueListRequestBody withType(TypeEnum type) {
        this.type = type;
        return this;
    }

    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public UpdateValueListRequestBody withValues(List<String> values) {
        this.values = values;
        return this;
    }

    public UpdateValueListRequestBody addValuesItem(String valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(valuesItem);
        return this;
    }

    public UpdateValueListRequestBody withValues(Consumer<List<String>> valuesSetter) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        valuesSetter.accept(this.values);
        return this;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public UpdateValueListRequestBody withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateValueListRequestBody that = (UpdateValueListRequestBody)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.values, that.values) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.values, this.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateValueListRequestBody {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class TypeEnum {
        public static final TypeEnum URL = new TypeEnum("url");
        public static final TypeEnum PARAMS = new TypeEnum("params");
        public static final TypeEnum IP = new TypeEnum("ip");
        public static final TypeEnum COOKIE = new TypeEnum("cookie");
        public static final TypeEnum REFERER = new TypeEnum("referer");
        public static final TypeEnum USER_AGENT = new TypeEnum("user-agent");
        public static final TypeEnum HEADER = new TypeEnum("header");
        public static final TypeEnum RESPONSE_CODE = new TypeEnum("response_code");
        public static final TypeEnum RESPONSE_HEADER = new TypeEnum("response_header");
        public static final TypeEnum RESOPNSE_BODY = new TypeEnum("resopnse_body");
        private static final Map<String, TypeEnum> STATIC_FIELDS = TypeEnum.createStaticFields();
        private String value;

        private static Map<String, TypeEnum> createStaticFields() {
            HashMap<String, TypeEnum> map = new HashMap<String, TypeEnum>();
            map.put("url", URL);
            map.put("params", PARAMS);
            map.put("ip", IP);
            map.put("cookie", COOKIE);
            map.put("referer", REFERER);
            map.put("user-agent", USER_AGENT);
            map.put("header", HEADER);
            map.put("response_code", RESPONSE_CODE);
            map.put("response_header", RESPONSE_HEADER);
            map.put("resopnse_body", RESOPNSE_BODY);
            return Collections.unmodifiableMap(map);
        }

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new TypeEnum(value));
        }

        public static TypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeEnum) {
                return this.value.equals(((TypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

