/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.waf.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.waf.v1.model.CloudWafServer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class CreateHostRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="hostname")
    private String hostname;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="policyid")
    private String policyid;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="server")
    private List<CloudWafServer> server = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="certificateid")
    private String certificateid;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="certificatename")
    private String certificatename;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="web_tag")
    private String webTag;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="exclusive_ip")
    private Boolean exclusiveIp;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="paid_type")
    private String paidType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="proxy")
    private Boolean proxy;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="lb_algorithm")
    private LbAlgorithmEnum lbAlgorithm;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="description")
    private String description;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="forward_header_map")
    private Map<String, String> forwardHeaderMap = null;

    public CreateHostRequestBody withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public CreateHostRequestBody withPolicyid(String policyid) {
        this.policyid = policyid;
        return this;
    }

    public String getPolicyid() {
        return this.policyid;
    }

    public void setPolicyid(String policyid) {
        this.policyid = policyid;
    }

    public CreateHostRequestBody withServer(List<CloudWafServer> server) {
        this.server = server;
        return this;
    }

    public CreateHostRequestBody addServerItem(CloudWafServer serverItem) {
        if (this.server == null) {
            this.server = new ArrayList<CloudWafServer>();
        }
        this.server.add(serverItem);
        return this;
    }

    public CreateHostRequestBody withServer(Consumer<List<CloudWafServer>> serverSetter) {
        if (this.server == null) {
            this.server = new ArrayList<CloudWafServer>();
        }
        serverSetter.accept(this.server);
        return this;
    }

    public List<CloudWafServer> getServer() {
        return this.server;
    }

    public void setServer(List<CloudWafServer> server) {
        this.server = server;
    }

    public CreateHostRequestBody withCertificateid(String certificateid) {
        this.certificateid = certificateid;
        return this;
    }

    public String getCertificateid() {
        return this.certificateid;
    }

    public void setCertificateid(String certificateid) {
        this.certificateid = certificateid;
    }

    public CreateHostRequestBody withCertificatename(String certificatename) {
        this.certificatename = certificatename;
        return this;
    }

    public String getCertificatename() {
        return this.certificatename;
    }

    public void setCertificatename(String certificatename) {
        this.certificatename = certificatename;
    }

    public CreateHostRequestBody withWebTag(String webTag) {
        this.webTag = webTag;
        return this;
    }

    public String getWebTag() {
        return this.webTag;
    }

    public void setWebTag(String webTag) {
        this.webTag = webTag;
    }

    public CreateHostRequestBody withExclusiveIp(Boolean exclusiveIp) {
        this.exclusiveIp = exclusiveIp;
        return this;
    }

    public Boolean getExclusiveIp() {
        return this.exclusiveIp;
    }

    public void setExclusiveIp(Boolean exclusiveIp) {
        this.exclusiveIp = exclusiveIp;
    }

    public CreateHostRequestBody withPaidType(String paidType) {
        this.paidType = paidType;
        return this;
    }

    public String getPaidType() {
        return this.paidType;
    }

    public void setPaidType(String paidType) {
        this.paidType = paidType;
    }

    public CreateHostRequestBody withProxy(Boolean proxy) {
        this.proxy = proxy;
        return this;
    }

    public Boolean getProxy() {
        return this.proxy;
    }

    public void setProxy(Boolean proxy) {
        this.proxy = proxy;
    }

    public CreateHostRequestBody withLbAlgorithm(LbAlgorithmEnum lbAlgorithm) {
        this.lbAlgorithm = lbAlgorithm;
        return this;
    }

    public LbAlgorithmEnum getLbAlgorithm() {
        return this.lbAlgorithm;
    }

    public void setLbAlgorithm(LbAlgorithmEnum lbAlgorithm) {
        this.lbAlgorithm = lbAlgorithm;
    }

    public CreateHostRequestBody withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateHostRequestBody withForwardHeaderMap(Map<String, String> forwardHeaderMap) {
        this.forwardHeaderMap = forwardHeaderMap;
        return this;
    }

    public CreateHostRequestBody putForwardHeaderMapItem(String key, String forwardHeaderMapItem) {
        if (this.forwardHeaderMap == null) {
            this.forwardHeaderMap = new HashMap<String, String>();
        }
        this.forwardHeaderMap.put(key, forwardHeaderMapItem);
        return this;
    }

    public CreateHostRequestBody withForwardHeaderMap(Consumer<Map<String, String>> forwardHeaderMapSetter) {
        if (this.forwardHeaderMap == null) {
            this.forwardHeaderMap = new HashMap<String, String>();
        }
        forwardHeaderMapSetter.accept(this.forwardHeaderMap);
        return this;
    }

    public Map<String, String> getForwardHeaderMap() {
        return this.forwardHeaderMap;
    }

    public void setForwardHeaderMap(Map<String, String> forwardHeaderMap) {
        this.forwardHeaderMap = forwardHeaderMap;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateHostRequestBody that = (CreateHostRequestBody)obj;
        return Objects.equals(this.hostname, that.hostname) && Objects.equals(this.policyid, that.policyid) && Objects.equals(this.server, that.server) && Objects.equals(this.certificateid, that.certificateid) && Objects.equals(this.certificatename, that.certificatename) && Objects.equals(this.webTag, that.webTag) && Objects.equals(this.exclusiveIp, that.exclusiveIp) && Objects.equals(this.paidType, that.paidType) && Objects.equals(this.proxy, that.proxy) && Objects.equals(this.lbAlgorithm, that.lbAlgorithm) && Objects.equals(this.description, that.description) && Objects.equals(this.forwardHeaderMap, that.forwardHeaderMap);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.policyid, this.server, this.certificateid, this.certificatename, this.webTag, this.exclusiveIp, this.paidType, this.proxy, this.lbAlgorithm, this.description, this.forwardHeaderMap);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateHostRequestBody {\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    policyid: ").append(this.toIndentedString(this.policyid)).append("\n");
        sb.append("    server: ").append(this.toIndentedString(this.server)).append("\n");
        sb.append("    certificateid: ").append(this.toIndentedString(this.certificateid)).append("\n");
        sb.append("    certificatename: ").append(this.toIndentedString(this.certificatename)).append("\n");
        sb.append("    webTag: ").append(this.toIndentedString(this.webTag)).append("\n");
        sb.append("    exclusiveIp: ").append(this.toIndentedString(this.exclusiveIp)).append("\n");
        sb.append("    paidType: ").append(this.toIndentedString(this.paidType)).append("\n");
        sb.append("    proxy: ").append(this.toIndentedString(this.proxy)).append("\n");
        sb.append("    lbAlgorithm: ").append(this.toIndentedString(this.lbAlgorithm)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    forwardHeaderMap: ").append(this.toIndentedString(this.forwardHeaderMap)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class LbAlgorithmEnum {
        public static final LbAlgorithmEnum IP_HASH = new LbAlgorithmEnum("ip_hash");
        public static final LbAlgorithmEnum ROUND_ROBIN = new LbAlgorithmEnum("round_robin");
        public static final LbAlgorithmEnum SESSION_HASH = new LbAlgorithmEnum("session_hash");
        private static final Map<String, LbAlgorithmEnum> STATIC_FIELDS = LbAlgorithmEnum.createStaticFields();
        private String value;

        private static Map<String, LbAlgorithmEnum> createStaticFields() {
            HashMap<String, LbAlgorithmEnum> map = new HashMap<String, LbAlgorithmEnum>();
            map.put("ip_hash", IP_HASH);
            map.put("round_robin", ROUND_ROBIN);
            map.put("session_hash", SESSION_HASH);
            return Collections.unmodifiableMap(map);
        }

        LbAlgorithmEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LbAlgorithmEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new LbAlgorithmEnum(value));
        }

        public static LbAlgorithmEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof LbAlgorithmEnum) {
                return this.value.equals(((LbAlgorithmEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

