/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.waf.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class AnticrawlerCondition {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="category")
    private CategoryEnum category;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="logic_operation")
    private String logicOperation;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="contents")
    private List<String> contents = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="value_list_id")
    private String valueListId;

    public AnticrawlerCondition withCategory(CategoryEnum category) {
        this.category = category;
        return this;
    }

    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public AnticrawlerCondition withLogicOperation(String logicOperation) {
        this.logicOperation = logicOperation;
        return this;
    }

    public String getLogicOperation() {
        return this.logicOperation;
    }

    public void setLogicOperation(String logicOperation) {
        this.logicOperation = logicOperation;
    }

    public AnticrawlerCondition withContents(List<String> contents) {
        this.contents = contents;
        return this;
    }

    public AnticrawlerCondition addContentsItem(String contentsItem) {
        if (this.contents == null) {
            this.contents = new ArrayList<String>();
        }
        this.contents.add(contentsItem);
        return this;
    }

    public AnticrawlerCondition withContents(Consumer<List<String>> contentsSetter) {
        if (this.contents == null) {
            this.contents = new ArrayList<String>();
        }
        contentsSetter.accept(this.contents);
        return this;
    }

    public List<String> getContents() {
        return this.contents;
    }

    public void setContents(List<String> contents) {
        this.contents = contents;
    }

    public AnticrawlerCondition withValueListId(String valueListId) {
        this.valueListId = valueListId;
        return this;
    }

    public String getValueListId() {
        return this.valueListId;
    }

    public void setValueListId(String valueListId) {
        this.valueListId = valueListId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AnticrawlerCondition that = (AnticrawlerCondition)obj;
        return Objects.equals(this.category, that.category) && Objects.equals(this.logicOperation, that.logicOperation) && Objects.equals(this.contents, that.contents) && Objects.equals(this.valueListId, that.valueListId);
    }

    public int hashCode() {
        return Objects.hash(this.category, this.logicOperation, this.contents, this.valueListId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnticrawlerCondition {\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    logicOperation: ").append(this.toIndentedString(this.logicOperation)).append("\n");
        sb.append("    contents: ").append(this.toIndentedString(this.contents)).append("\n");
        sb.append("    valueListId: ").append(this.toIndentedString(this.valueListId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class CategoryEnum {
        public static final CategoryEnum URL = new CategoryEnum("url");
        public static final CategoryEnum USER_AGENT = new CategoryEnum("user-agent");
        private static final Map<String, CategoryEnum> STATIC_FIELDS = CategoryEnum.createStaticFields();
        private String value;

        private static Map<String, CategoryEnum> createStaticFields() {
            HashMap<String, CategoryEnum> map = new HashMap<String, CategoryEnum>();
            map.put("url", URL);
            map.put("user-agent", USER_AGENT);
            return Collections.unmodifiableMap(map);
        }

        CategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CategoryEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new CategoryEnum(value));
        }

        public static CategoryEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof CategoryEnum) {
                return this.value.equals(((CategoryEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

