/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.vpn.v5.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.vpn.v5.model.QueryResourcesRequestBody;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class ListResourcesByTagsRequest {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="resource_type")
    private ResourceTypeEnum resourceType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="limit")
    private String limit;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="offset")
    private String offset;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="body")
    private QueryResourcesRequestBody body;

    public ListResourcesByTagsRequest withResourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public ResourceTypeEnum getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
    }

    public ListResourcesByTagsRequest withLimit(String limit) {
        this.limit = limit;
        return this;
    }

    public String getLimit() {
        return this.limit;
    }

    public void setLimit(String limit) {
        this.limit = limit;
    }

    public ListResourcesByTagsRequest withOffset(String offset) {
        this.offset = offset;
        return this;
    }

    public String getOffset() {
        return this.offset;
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    public ListResourcesByTagsRequest withBody(QueryResourcesRequestBody body) {
        this.body = body;
        return this;
    }

    public ListResourcesByTagsRequest withBody(Consumer<QueryResourcesRequestBody> bodySetter) {
        if (this.body == null) {
            this.body = new QueryResourcesRequestBody();
            bodySetter.accept(this.body);
        }
        return this;
    }

    public QueryResourcesRequestBody getBody() {
        return this.body;
    }

    public void setBody(QueryResourcesRequestBody body) {
        this.body = body;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ListResourcesByTagsRequest that = (ListResourcesByTagsRequest)obj;
        return Objects.equals(this.resourceType, that.resourceType) && Objects.equals(this.limit, that.limit) && Objects.equals(this.offset, that.offset) && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.resourceType, this.limit, this.offset, this.body);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListResourcesByTagsRequest {\n");
        sb.append("    resourceType: ").append(this.toIndentedString(this.resourceType)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    offset: ").append(this.toIndentedString(this.offset)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ResourceTypeEnum {
        public static final ResourceTypeEnum VPN_GATEWAY = new ResourceTypeEnum("vpn-gateway");
        public static final ResourceTypeEnum VPN_CONNECTION = new ResourceTypeEnum("vpn-connection");
        public static final ResourceTypeEnum CUSTOMER_GATEWAY = new ResourceTypeEnum("customer-gateway");
        public static final ResourceTypeEnum P2C_VPN_GATEWAYS = new ResourceTypeEnum("p2c-vpn-gateways");
        private static final Map<String, ResourceTypeEnum> STATIC_FIELDS = ResourceTypeEnum.createStaticFields();
        private String value;

        private static Map<String, ResourceTypeEnum> createStaticFields() {
            HashMap<String, ResourceTypeEnum> map = new HashMap<String, ResourceTypeEnum>();
            map.put("vpn-gateway", VPN_GATEWAY);
            map.put("vpn-connection", VPN_CONNECTION);
            map.put("customer-gateway", CUSTOMER_GATEWAY);
            map.put("p2c-vpn-gateways", P2C_VPN_GATEWAYS);
            return Collections.unmodifiableMap(map);
        }

        ResourceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResourceTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ResourceTypeEnum(value));
        }

        public static ResourceTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ResourceTypeEnum) {
                return this.value.equals(((ResourceTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

