/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.vpn.v5.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IpsecPolicy {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="authentication_algorithm")
    private AuthenticationAlgorithmEnum authenticationAlgorithm;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="encryption_algorithm")
    private EncryptionAlgorithmEnum encryptionAlgorithm;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="pfs")
    private String pfs;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="transform_protocol")
    private TransformProtocolEnum transformProtocol;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="lifetime_seconds")
    private Integer lifetimeSeconds;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="encapsulation_mode")
    private EncapsulationModeEnum encapsulationMode;

    public IpsecPolicy withAuthenticationAlgorithm(AuthenticationAlgorithmEnum authenticationAlgorithm) {
        this.authenticationAlgorithm = authenticationAlgorithm;
        return this;
    }

    public AuthenticationAlgorithmEnum getAuthenticationAlgorithm() {
        return this.authenticationAlgorithm;
    }

    public void setAuthenticationAlgorithm(AuthenticationAlgorithmEnum authenticationAlgorithm) {
        this.authenticationAlgorithm = authenticationAlgorithm;
    }

    public IpsecPolicy withEncryptionAlgorithm(EncryptionAlgorithmEnum encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        return this;
    }

    public EncryptionAlgorithmEnum getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(EncryptionAlgorithmEnum encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public IpsecPolicy withPfs(String pfs) {
        this.pfs = pfs;
        return this;
    }

    public String getPfs() {
        return this.pfs;
    }

    public void setPfs(String pfs) {
        this.pfs = pfs;
    }

    public IpsecPolicy withTransformProtocol(TransformProtocolEnum transformProtocol) {
        this.transformProtocol = transformProtocol;
        return this;
    }

    public TransformProtocolEnum getTransformProtocol() {
        return this.transformProtocol;
    }

    public void setTransformProtocol(TransformProtocolEnum transformProtocol) {
        this.transformProtocol = transformProtocol;
    }

    public IpsecPolicy withLifetimeSeconds(Integer lifetimeSeconds) {
        this.lifetimeSeconds = lifetimeSeconds;
        return this;
    }

    public Integer getLifetimeSeconds() {
        return this.lifetimeSeconds;
    }

    public void setLifetimeSeconds(Integer lifetimeSeconds) {
        this.lifetimeSeconds = lifetimeSeconds;
    }

    public IpsecPolicy withEncapsulationMode(EncapsulationModeEnum encapsulationMode) {
        this.encapsulationMode = encapsulationMode;
        return this;
    }

    public EncapsulationModeEnum getEncapsulationMode() {
        return this.encapsulationMode;
    }

    public void setEncapsulationMode(EncapsulationModeEnum encapsulationMode) {
        this.encapsulationMode = encapsulationMode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IpsecPolicy that = (IpsecPolicy)obj;
        return Objects.equals(this.authenticationAlgorithm, that.authenticationAlgorithm) && Objects.equals(this.encryptionAlgorithm, that.encryptionAlgorithm) && Objects.equals(this.pfs, that.pfs) && Objects.equals(this.transformProtocol, that.transformProtocol) && Objects.equals(this.lifetimeSeconds, that.lifetimeSeconds) && Objects.equals(this.encapsulationMode, that.encapsulationMode);
    }

    public int hashCode() {
        return Objects.hash(this.authenticationAlgorithm, this.encryptionAlgorithm, this.pfs, this.transformProtocol, this.lifetimeSeconds, this.encapsulationMode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IpsecPolicy {\n");
        sb.append("    authenticationAlgorithm: ").append(this.toIndentedString(this.authenticationAlgorithm)).append("\n");
        sb.append("    encryptionAlgorithm: ").append(this.toIndentedString(this.encryptionAlgorithm)).append("\n");
        sb.append("    pfs: ").append(this.toIndentedString(this.pfs)).append("\n");
        sb.append("    transformProtocol: ").append(this.toIndentedString(this.transformProtocol)).append("\n");
        sb.append("    lifetimeSeconds: ").append(this.toIndentedString(this.lifetimeSeconds)).append("\n");
        sb.append("    encapsulationMode: ").append(this.toIndentedString(this.encapsulationMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class EncapsulationModeEnum {
        public static final EncapsulationModeEnum TUNNEL = new EncapsulationModeEnum("tunnel");
        private static final Map<String, EncapsulationModeEnum> STATIC_FIELDS = EncapsulationModeEnum.createStaticFields();
        private String value;

        private static Map<String, EncapsulationModeEnum> createStaticFields() {
            HashMap<String, EncapsulationModeEnum> map = new HashMap<String, EncapsulationModeEnum>();
            map.put("tunnel", TUNNEL);
            return Collections.unmodifiableMap(map);
        }

        EncapsulationModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EncapsulationModeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new EncapsulationModeEnum(value));
        }

        public static EncapsulationModeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof EncapsulationModeEnum) {
                return this.value.equals(((EncapsulationModeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class TransformProtocolEnum {
        public static final TransformProtocolEnum ESP = new TransformProtocolEnum("esp");
        private static final Map<String, TransformProtocolEnum> STATIC_FIELDS = TransformProtocolEnum.createStaticFields();
        private String value;

        private static Map<String, TransformProtocolEnum> createStaticFields() {
            HashMap<String, TransformProtocolEnum> map = new HashMap<String, TransformProtocolEnum>();
            map.put("esp", ESP);
            return Collections.unmodifiableMap(map);
        }

        TransformProtocolEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TransformProtocolEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new TransformProtocolEnum(value));
        }

        public static TransformProtocolEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof TransformProtocolEnum) {
                return this.value.equals(((TransformProtocolEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class EncryptionAlgorithmEnum {
        public static final EncryptionAlgorithmEnum _3DES = new EncryptionAlgorithmEnum("3des");
        public static final EncryptionAlgorithmEnum AES_128 = new EncryptionAlgorithmEnum("aes-128");
        public static final EncryptionAlgorithmEnum AES_192 = new EncryptionAlgorithmEnum("aes-192");
        public static final EncryptionAlgorithmEnum AES_256 = new EncryptionAlgorithmEnum("aes-256");
        public static final EncryptionAlgorithmEnum AES_128_GCM_16 = new EncryptionAlgorithmEnum("aes-128-gcm-16");
        public static final EncryptionAlgorithmEnum AES_256_GCM_16 = new EncryptionAlgorithmEnum("aes-256-gcm-16");
        public static final EncryptionAlgorithmEnum AES_128_GCM_128 = new EncryptionAlgorithmEnum("aes-128-gcm-128");
        public static final EncryptionAlgorithmEnum AES_256_GCM_128 = new EncryptionAlgorithmEnum("aes-256-gcm-128");
        private static final Map<String, EncryptionAlgorithmEnum> STATIC_FIELDS = EncryptionAlgorithmEnum.createStaticFields();
        private String value;

        private static Map<String, EncryptionAlgorithmEnum> createStaticFields() {
            HashMap<String, EncryptionAlgorithmEnum> map = new HashMap<String, EncryptionAlgorithmEnum>();
            map.put("3des", _3DES);
            map.put("aes-128", AES_128);
            map.put("aes-192", AES_192);
            map.put("aes-256", AES_256);
            map.put("aes-128-gcm-16", AES_128_GCM_16);
            map.put("aes-256-gcm-16", AES_256_GCM_16);
            map.put("aes-128-gcm-128", AES_128_GCM_128);
            map.put("aes-256-gcm-128", AES_256_GCM_128);
            return Collections.unmodifiableMap(map);
        }

        EncryptionAlgorithmEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EncryptionAlgorithmEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new EncryptionAlgorithmEnum(value));
        }

        public static EncryptionAlgorithmEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof EncryptionAlgorithmEnum) {
                return this.value.equals(((EncryptionAlgorithmEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class AuthenticationAlgorithmEnum {
        public static final AuthenticationAlgorithmEnum SHA1 = new AuthenticationAlgorithmEnum("sha1");
        public static final AuthenticationAlgorithmEnum MD5 = new AuthenticationAlgorithmEnum("md5");
        public static final AuthenticationAlgorithmEnum SHA2_256 = new AuthenticationAlgorithmEnum("sha2-256");
        public static final AuthenticationAlgorithmEnum SHA2_384 = new AuthenticationAlgorithmEnum("sha2-384");
        public static final AuthenticationAlgorithmEnum SHA2_512 = new AuthenticationAlgorithmEnum("sha2-512");
        private static final Map<String, AuthenticationAlgorithmEnum> STATIC_FIELDS = AuthenticationAlgorithmEnum.createStaticFields();
        private String value;

        private static Map<String, AuthenticationAlgorithmEnum> createStaticFields() {
            HashMap<String, AuthenticationAlgorithmEnum> map = new HashMap<String, AuthenticationAlgorithmEnum>();
            map.put("sha1", SHA1);
            map.put("md5", MD5);
            map.put("sha2-256", SHA2_256);
            map.put("sha2-384", SHA2_384);
            map.put("sha2-512", SHA2_512);
            return Collections.unmodifiableMap(map);
        }

        AuthenticationAlgorithmEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AuthenticationAlgorithmEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new AuthenticationAlgorithmEnum(value));
        }

        public static AuthenticationAlgorithmEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof AuthenticationAlgorithmEnum) {
                return this.value.equals(((AuthenticationAlgorithmEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

