/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.vpn.v5.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.vpn.v5.model.DeleteResourcesTagsRequestBody;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class BatchDeleteResourceTagsRequest {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="resource_type")
    private ResourceTypeEnum resourceType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="resource_id")
    private String resourceId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="body")
    private DeleteResourcesTagsRequestBody body;

    public BatchDeleteResourceTagsRequest withResourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public ResourceTypeEnum getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
    }

    public BatchDeleteResourceTagsRequest withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public BatchDeleteResourceTagsRequest withBody(DeleteResourcesTagsRequestBody body) {
        this.body = body;
        return this;
    }

    public BatchDeleteResourceTagsRequest withBody(Consumer<DeleteResourcesTagsRequestBody> bodySetter) {
        if (this.body == null) {
            this.body = new DeleteResourcesTagsRequestBody();
            bodySetter.accept(this.body);
        }
        return this;
    }

    public DeleteResourcesTagsRequestBody getBody() {
        return this.body;
    }

    public void setBody(DeleteResourcesTagsRequestBody body) {
        this.body = body;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BatchDeleteResourceTagsRequest that = (BatchDeleteResourceTagsRequest)obj;
        return Objects.equals(this.resourceType, that.resourceType) && Objects.equals(this.resourceId, that.resourceId) && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.resourceType, this.resourceId, this.body);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchDeleteResourceTagsRequest {\n");
        sb.append("    resourceType: ").append(this.toIndentedString(this.resourceType)).append("\n");
        sb.append("    resourceId: ").append(this.toIndentedString(this.resourceId)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ResourceTypeEnum {
        public static final ResourceTypeEnum VPN_GATEWAY = new ResourceTypeEnum("vpn-gateway");
        public static final ResourceTypeEnum VPN_CONNECTION = new ResourceTypeEnum("vpn-connection");
        public static final ResourceTypeEnum CUSTOMER_GATEWAY = new ResourceTypeEnum("customer-gateway");
        public static final ResourceTypeEnum P2C_VPN_GATEWAYS = new ResourceTypeEnum("p2c-vpn-gateways");
        private static final Map<String, ResourceTypeEnum> STATIC_FIELDS = ResourceTypeEnum.createStaticFields();
        private String value;

        private static Map<String, ResourceTypeEnum> createStaticFields() {
            HashMap<String, ResourceTypeEnum> map = new HashMap<String, ResourceTypeEnum>();
            map.put("vpn-gateway", VPN_GATEWAY);
            map.put("vpn-connection", VPN_CONNECTION);
            map.put("customer-gateway", CUSTOMER_GATEWAY);
            map.put("p2c-vpn-gateways", P2C_VPN_GATEWAYS);
            return Collections.unmodifiableMap(map);
        }

        ResourceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResourceTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ResourceTypeEnum(value));
        }

        public static ResourceTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ResourceTypeEnum) {
                return this.value.equals(((ResourceTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

