/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.ugo.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SqlConvertReq {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="source_db_type")
    private SourceDbTypeEnum sourceDbType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="target_db_type")
    private TargetDbTypeEnum targetDbType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="target_db_version")
    private TargetDbVersionEnum targetDbVersion;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="sql_statement")
    private String sqlStatement;

    public SqlConvertReq withSourceDbType(SourceDbTypeEnum sourceDbType) {
        this.sourceDbType = sourceDbType;
        return this;
    }

    public SourceDbTypeEnum getSourceDbType() {
        return this.sourceDbType;
    }

    public void setSourceDbType(SourceDbTypeEnum sourceDbType) {
        this.sourceDbType = sourceDbType;
    }

    public SqlConvertReq withTargetDbType(TargetDbTypeEnum targetDbType) {
        this.targetDbType = targetDbType;
        return this;
    }

    public TargetDbTypeEnum getTargetDbType() {
        return this.targetDbType;
    }

    public void setTargetDbType(TargetDbTypeEnum targetDbType) {
        this.targetDbType = targetDbType;
    }

    public SqlConvertReq withTargetDbVersion(TargetDbVersionEnum targetDbVersion) {
        this.targetDbVersion = targetDbVersion;
        return this;
    }

    public TargetDbVersionEnum getTargetDbVersion() {
        return this.targetDbVersion;
    }

    public void setTargetDbVersion(TargetDbVersionEnum targetDbVersion) {
        this.targetDbVersion = targetDbVersion;
    }

    public SqlConvertReq withSqlStatement(String sqlStatement) {
        this.sqlStatement = sqlStatement;
        return this;
    }

    public String getSqlStatement() {
        return this.sqlStatement;
    }

    public void setSqlStatement(String sqlStatement) {
        this.sqlStatement = sqlStatement;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlConvertReq that = (SqlConvertReq)obj;
        return Objects.equals(this.sourceDbType, that.sourceDbType) && Objects.equals(this.targetDbType, that.targetDbType) && Objects.equals(this.targetDbVersion, that.targetDbVersion) && Objects.equals(this.sqlStatement, that.sqlStatement);
    }

    public int hashCode() {
        return Objects.hash(this.sourceDbType, this.targetDbType, this.targetDbVersion, this.sqlStatement);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SqlConvertReq {\n");
        sb.append("    sourceDbType: ").append(this.toIndentedString(this.sourceDbType)).append("\n");
        sb.append("    targetDbType: ").append(this.toIndentedString(this.targetDbType)).append("\n");
        sb.append("    targetDbVersion: ").append(this.toIndentedString(this.targetDbVersion)).append("\n");
        sb.append("    sqlStatement: ").append(this.toIndentedString(this.sqlStatement)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class TargetDbVersionEnum {
        public static final TargetDbVersionEnum _5_7 = new TargetDbVersionEnum("5.7");
        public static final TargetDbVersionEnum _8_0 = new TargetDbVersionEnum("8.0");
        public static final TargetDbVersionEnum _11 = new TargetDbVersionEnum("11");
        public static final TargetDbVersionEnum _2_0 = new TargetDbVersionEnum("2.0");
        public static final TargetDbVersionEnum ENHANCED_EDITION = new TargetDbVersionEnum("Enhanced Edition");
        private static final Map<String, TargetDbVersionEnum> STATIC_FIELDS = TargetDbVersionEnum.createStaticFields();
        private String value;

        private static Map<String, TargetDbVersionEnum> createStaticFields() {
            HashMap<String, TargetDbVersionEnum> map = new HashMap<String, TargetDbVersionEnum>();
            map.put("5.7", _5_7);
            map.put("8.0", _8_0);
            map.put("11", _11);
            map.put("2.0", _2_0);
            map.put("Enhanced Edition", ENHANCED_EDITION);
            return Collections.unmodifiableMap(map);
        }

        TargetDbVersionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TargetDbVersionEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new TargetDbVersionEnum(value));
        }

        public static TargetDbVersionEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof TargetDbVersionEnum) {
                return this.value.equals(((TargetDbVersionEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class TargetDbTypeEnum {
        public static final TargetDbTypeEnum RDS_FOR_MYSQL = new TargetDbTypeEnum("RDS for MySQL");
        public static final TargetDbTypeEnum GAUSSDB_FOR_MYSQL_ = new TargetDbTypeEnum("GaussDB(for MySQL)");
        public static final TargetDbTypeEnum RDS_FOR_POSTGRESQL = new TargetDbTypeEnum("RDS for PostgreSQL");
        public static final TargetDbTypeEnum GAUSSDB_PRIMARY_STANDBY = new TargetDbTypeEnum("GaussDB Primary/Standby");
        public static final TargetDbTypeEnum GAUSSDB_CENTRALIZED = new TargetDbTypeEnum("GaussDB Centralized");
        private static final Map<String, TargetDbTypeEnum> STATIC_FIELDS = TargetDbTypeEnum.createStaticFields();
        private String value;

        private static Map<String, TargetDbTypeEnum> createStaticFields() {
            HashMap<String, TargetDbTypeEnum> map = new HashMap<String, TargetDbTypeEnum>();
            map.put("RDS for MySQL", RDS_FOR_MYSQL);
            map.put("GaussDB(for MySQL)", GAUSSDB_FOR_MYSQL_);
            map.put("RDS for PostgreSQL", RDS_FOR_POSTGRESQL);
            map.put("GaussDB Primary/Standby", GAUSSDB_PRIMARY_STANDBY);
            map.put("GaussDB Centralized", GAUSSDB_CENTRALIZED);
            return Collections.unmodifiableMap(map);
        }

        TargetDbTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TargetDbTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new TargetDbTypeEnum(value));
        }

        public static TargetDbTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof TargetDbTypeEnum) {
                return this.value.equals(((TargetDbTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class SourceDbTypeEnum {
        public static final SourceDbTypeEnum ORACLE = new SourceDbTypeEnum("ORACLE");
        private static final Map<String, SourceDbTypeEnum> STATIC_FIELDS = SourceDbTypeEnum.createStaticFields();
        private String value;

        private static Map<String, SourceDbTypeEnum> createStaticFields() {
            HashMap<String, SourceDbTypeEnum> map = new HashMap<String, SourceDbTypeEnum>();
            map.put("ORACLE", ORACLE);
            return Collections.unmodifiableMap(map);
        }

        SourceDbTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SourceDbTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new SourceDbTypeEnum(value));
        }

        public static SourceDbTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof SourceDbTypeEnum) {
                return this.value.equals(((SourceDbTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

