/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.ugo.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SourceDBInfo {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="connection_string")
    private String connectionString;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="user_name")
    private String userName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="password")
    private String password;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="source_db_type")
    private SourceDbTypeEnum sourceDbType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="source_db_version")
    private SourceDbVersionEnum sourceDbVersion;

    public SourceDBInfo withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public SourceDBInfo withUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public SourceDBInfo withPassword(String password) {
        this.password = password;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public SourceDBInfo withSourceDbType(SourceDbTypeEnum sourceDbType) {
        this.sourceDbType = sourceDbType;
        return this;
    }

    public SourceDbTypeEnum getSourceDbType() {
        return this.sourceDbType;
    }

    public void setSourceDbType(SourceDbTypeEnum sourceDbType) {
        this.sourceDbType = sourceDbType;
    }

    public SourceDBInfo withSourceDbVersion(SourceDbVersionEnum sourceDbVersion) {
        this.sourceDbVersion = sourceDbVersion;
        return this;
    }

    public SourceDbVersionEnum getSourceDbVersion() {
        return this.sourceDbVersion;
    }

    public void setSourceDbVersion(SourceDbVersionEnum sourceDbVersion) {
        this.sourceDbVersion = sourceDbVersion;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SourceDBInfo that = (SourceDBInfo)obj;
        return Objects.equals(this.connectionString, that.connectionString) && Objects.equals(this.userName, that.userName) && Objects.equals(this.password, that.password) && Objects.equals(this.sourceDbType, that.sourceDbType) && Objects.equals(this.sourceDbVersion, that.sourceDbVersion);
    }

    public int hashCode() {
        return Objects.hash(this.connectionString, this.userName, this.password, this.sourceDbType, this.sourceDbVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceDBInfo {\n");
        sb.append("    connectionString: ").append(this.toIndentedString(this.connectionString)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    sourceDbType: ").append(this.toIndentedString(this.sourceDbType)).append("\n");
        sb.append("    sourceDbVersion: ").append(this.toIndentedString(this.sourceDbVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class SourceDbVersionEnum {
        public static final SourceDbVersionEnum _11G = new SourceDbVersionEnum("11g");
        public static final SourceDbVersionEnum _12C = new SourceDbVersionEnum("12c");
        public static final SourceDbVersionEnum _18C = new SourceDbVersionEnum("18c");
        public static final SourceDbVersionEnum _19C = new SourceDbVersionEnum("19c");
        private static final Map<String, SourceDbVersionEnum> STATIC_FIELDS = SourceDbVersionEnum.createStaticFields();
        private String value;

        private static Map<String, SourceDbVersionEnum> createStaticFields() {
            HashMap<String, SourceDbVersionEnum> map = new HashMap<String, SourceDbVersionEnum>();
            map.put("11g", _11G);
            map.put("12c", _12C);
            map.put("18c", _18C);
            map.put("19c", _19C);
            return Collections.unmodifiableMap(map);
        }

        SourceDbVersionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SourceDbVersionEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new SourceDbVersionEnum(value));
        }

        public static SourceDbVersionEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof SourceDbVersionEnum) {
                return this.value.equals(((SourceDbVersionEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class SourceDbTypeEnum {
        public static final SourceDbTypeEnum ORACLE = new SourceDbTypeEnum("ORACLE");
        private static final Map<String, SourceDbTypeEnum> STATIC_FIELDS = SourceDbTypeEnum.createStaticFields();
        private String value;

        private static Map<String, SourceDbTypeEnum> createStaticFields() {
            HashMap<String, SourceDbTypeEnum> map = new HashMap<String, SourceDbTypeEnum>();
            map.put("ORACLE", ORACLE);
            return Collections.unmodifiableMap(map);
        }

        SourceDbTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SourceDbTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new SourceDbTypeEnum(value));
        }

        public static SourceDbTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof SourceDbTypeEnum) {
                return this.value.equals(((SourceDbTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

