/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.sms.v3.region;

import com.huaweicloud.sdk.core.region.IRegionProvider;
import com.huaweicloud.sdk.core.region.Region;
import com.huaweicloud.sdk.core.region.RegionProviderChain;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class SmsRegion {
    public static final Region AP_SOUTHEAST_1 = new Region("ap-southeast-1", "https://sms.ap-southeast-1.myhuaweicloud.com");
    public static final Region AP_SOUTHEAST_3 = new Region("ap-southeast-3", "https://sms.ap-southeast-3.myhuaweicloud.com");
    public static final Region MY_KUALALUMPUR_1 = new Region("my-kualalumpur-1", "https://sms.my-kualalumpur-1.myhuaweicloud.com");
    public static final Region RU_MOSCOW_1 = new Region("ru-moscow-1", "https://sms-api.ru-moscow-1.myhuaweicloud.com");
    private static final IRegionProvider PROVIDER = RegionProviderChain.getDefaultRegionProviderChain((String)"SMS");
    private static final Map<String, Region> STATIC_FIELDS = SmsRegion.createStaticFields();

    private static Map<String, Region> createStaticFields() {
        HashMap<String, Region> map = new HashMap<String, Region>();
        map.put("ap-southeast-1", AP_SOUTHEAST_1);
        map.put("ap-southeast-3", AP_SOUTHEAST_3);
        map.put("my-kualalumpur-1", MY_KUALALUMPUR_1);
        map.put("ru-moscow-1", RU_MOSCOW_1);
        return Collections.unmodifiableMap(map);
    }

    public static Region valueOf(String regionId) {
        if (StringUtils.isEmpty((CharSequence)regionId)) {
            throw new IllegalArgumentException("Unexpected empty parameter: regionId.");
        }
        Region result = PROVIDER.getRegion(regionId);
        if (Objects.nonNull(result)) {
            return result;
        }
        result = STATIC_FIELDS.get(regionId);
        if (Objects.nonNull(result)) {
            return result;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "region id '%s' is not in the following supported regions of service SMS: [%s]", regionId, STATIC_FIELDS.keySet().stream().sorted().collect(Collectors.joining(", "))));
    }
}

