/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.sis.v1.region;

import com.huaweicloud.sdk.core.region.IRegionProvider;
import com.huaweicloud.sdk.core.region.Region;
import com.huaweicloud.sdk.core.region.RegionProviderChain;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class SisRegion {
    public static final Region CN_NORTH_1 = new Region("cn-north-1", "https://sis-ext.cn-north-1.myhuaweicloud.com");
    public static final Region CN_NORTH_4 = new Region("cn-north-4", "https://sis-ext.cn-north-4.myhuaweicloud.com");
    public static final Region CN_EAST_3 = new Region("cn-east-3", "https://sis-ext.cn-east-3.myhuaweicloud.com");
    private static final IRegionProvider PROVIDER = RegionProviderChain.getDefaultRegionProviderChain((String)"SIS");
    private static final Map<String, Region> STATIC_FIELDS = SisRegion.createStaticFields();

    private static Map<String, Region> createStaticFields() {
        HashMap<String, Region> map = new HashMap<String, Region>();
        map.put("cn-north-1", CN_NORTH_1);
        map.put("cn-north-4", CN_NORTH_4);
        map.put("cn-east-3", CN_EAST_3);
        return Collections.unmodifiableMap(map);
    }

    public static Region valueOf(String regionId) {
        if (StringUtils.isEmpty((CharSequence)regionId)) {
            throw new IllegalArgumentException("Unexpected empty parameter: regionId.");
        }
        Region result = PROVIDER.getRegion(regionId);
        if (Objects.nonNull(result)) {
            return result;
        }
        result = STATIC_FIELDS.get(regionId);
        if (Objects.nonNull(result)) {
            return result;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "region id '%s' is not in the following supported regions of service SIS: [%s]", regionId, STATIC_FIELDS.keySet().stream().sorted().collect(Collectors.joining(", "))));
    }
}

