/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.sis.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class PostCreateVocabReq {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="name")
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="description")
    private String description;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="language")
    private LanguageEnum language;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="contents")
    private List<String> contents = null;

    public PostCreateVocabReq withName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PostCreateVocabReq withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PostCreateVocabReq withLanguage(LanguageEnum language) {
        this.language = language;
        return this;
    }

    public LanguageEnum getLanguage() {
        return this.language;
    }

    public void setLanguage(LanguageEnum language) {
        this.language = language;
    }

    public PostCreateVocabReq withContents(List<String> contents) {
        this.contents = contents;
        return this;
    }

    public PostCreateVocabReq addContentsItem(String contentsItem) {
        if (this.contents == null) {
            this.contents = new ArrayList<String>();
        }
        this.contents.add(contentsItem);
        return this;
    }

    public PostCreateVocabReq withContents(Consumer<List<String>> contentsSetter) {
        if (this.contents == null) {
            this.contents = new ArrayList<String>();
        }
        contentsSetter.accept(this.contents);
        return this;
    }

    public List<String> getContents() {
        return this.contents;
    }

    public void setContents(List<String> contents) {
        this.contents = contents;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PostCreateVocabReq that = (PostCreateVocabReq)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.language, that.language) && Objects.equals(this.contents, that.contents);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.language, this.contents);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostCreateVocabReq {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    contents: ").append(this.toIndentedString(this.contents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class LanguageEnum {
        public static final LanguageEnum CHINESE_MANDARIN = new LanguageEnum("chinese_mandarin");
        private static final Map<String, LanguageEnum> STATIC_FIELDS = LanguageEnum.createStaticFields();
        private String value;

        private static Map<String, LanguageEnum> createStaticFields() {
            HashMap<String, LanguageEnum> map = new HashMap<String, LanguageEnum>();
            map.put("chinese_mandarin", CHINESE_MANDARIN);
            return Collections.unmodifiableMap(map);
        }

        LanguageEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LanguageEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new LanguageEnum(value));
        }

        public static LanguageEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof LanguageEnum) {
                return this.value.equals(((LanguageEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

