/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.osm.v2.region;

import com.huaweicloud.sdk.core.region.IRegionProvider;
import com.huaweicloud.sdk.core.region.Region;
import com.huaweicloud.sdk.core.region.RegionProviderChain;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class OsmRegion {
    public static final Region CN_SOUTH_1 = new Region("cn-south-1", "https://osm.cn-south-1.myhuaweicloud.cn");
    private static final IRegionProvider PROVIDER = RegionProviderChain.getDefaultRegionProviderChain((String)"OSM");
    private static final Map<String, Region> STATIC_FIELDS = OsmRegion.createStaticFields();

    private static Map<String, Region> createStaticFields() {
        HashMap<String, Region> map = new HashMap<String, Region>();
        map.put("cn-south-1", CN_SOUTH_1);
        return Collections.unmodifiableMap(map);
    }

    public static Region valueOf(String regionId) {
        if (StringUtils.isEmpty((CharSequence)regionId)) {
            throw new IllegalArgumentException("Unexpected empty parameter: regionId.");
        }
        Region result = PROVIDER.getRegion(regionId);
        if (Objects.nonNull(result)) {
            return result;
        }
        result = STATIC_FIELDS.get(regionId);
        if (Objects.nonNull(result)) {
            return result;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "region id '%s' is not in the following supported regions of service OSM: [%s]", regionId, STATIC_FIELDS.keySet().stream().sorted().collect(Collectors.joining(", "))));
    }
}

