/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.osm.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.osm.v2.model.RelationTheme;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class QaAskReq {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="question")
    private String question;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="top")
    private Integer top;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="themes")
    private List<RelationTheme> themes = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="source")
    private SourceEnum source;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="session_id")
    private String sessionId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="source_qa_pair_id")
    private String sourceQaPairId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="alternative_answer_enable")
    private Boolean alternativeAnswerEnable;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="product_type_id")
    private String productTypeId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="specify_node_id")
    private String specifyNodeId;

    public QaAskReq withQuestion(String question) {
        this.question = question;
        return this;
    }

    public String getQuestion() {
        return this.question;
    }

    public void setQuestion(String question) {
        this.question = question;
    }

    public QaAskReq withTop(Integer top) {
        this.top = top;
        return this;
    }

    public Integer getTop() {
        return this.top;
    }

    public void setTop(Integer top) {
        this.top = top;
    }

    public QaAskReq withThemes(List<RelationTheme> themes) {
        this.themes = themes;
        return this;
    }

    public QaAskReq addThemesItem(RelationTheme themesItem) {
        if (this.themes == null) {
            this.themes = new ArrayList<RelationTheme>();
        }
        this.themes.add(themesItem);
        return this;
    }

    public QaAskReq withThemes(Consumer<List<RelationTheme>> themesSetter) {
        if (this.themes == null) {
            this.themes = new ArrayList<RelationTheme>();
        }
        themesSetter.accept(this.themes);
        return this;
    }

    public List<RelationTheme> getThemes() {
        return this.themes;
    }

    public void setThemes(List<RelationTheme> themes) {
        this.themes = themes;
    }

    public QaAskReq withSource(SourceEnum source) {
        this.source = source;
        return this;
    }

    public SourceEnum getSource() {
        return this.source;
    }

    public void setSource(SourceEnum source) {
        this.source = source;
    }

    public QaAskReq withSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public QaAskReq withSourceQaPairId(String sourceQaPairId) {
        this.sourceQaPairId = sourceQaPairId;
        return this;
    }

    public String getSourceQaPairId() {
        return this.sourceQaPairId;
    }

    public void setSourceQaPairId(String sourceQaPairId) {
        this.sourceQaPairId = sourceQaPairId;
    }

    public QaAskReq withAlternativeAnswerEnable(Boolean alternativeAnswerEnable) {
        this.alternativeAnswerEnable = alternativeAnswerEnable;
        return this;
    }

    public Boolean getAlternativeAnswerEnable() {
        return this.alternativeAnswerEnable;
    }

    public void setAlternativeAnswerEnable(Boolean alternativeAnswerEnable) {
        this.alternativeAnswerEnable = alternativeAnswerEnable;
    }

    public QaAskReq withProductTypeId(String productTypeId) {
        this.productTypeId = productTypeId;
        return this;
    }

    public String getProductTypeId() {
        return this.productTypeId;
    }

    public void setProductTypeId(String productTypeId) {
        this.productTypeId = productTypeId;
    }

    public QaAskReq withSpecifyNodeId(String specifyNodeId) {
        this.specifyNodeId = specifyNodeId;
        return this;
    }

    public String getSpecifyNodeId() {
        return this.specifyNodeId;
    }

    public void setSpecifyNodeId(String specifyNodeId) {
        this.specifyNodeId = specifyNodeId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QaAskReq that = (QaAskReq)obj;
        return Objects.equals(this.question, that.question) && Objects.equals(this.top, that.top) && Objects.equals(this.themes, that.themes) && Objects.equals(this.source, that.source) && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.sourceQaPairId, that.sourceQaPairId) && Objects.equals(this.alternativeAnswerEnable, that.alternativeAnswerEnable) && Objects.equals(this.productTypeId, that.productTypeId) && Objects.equals(this.specifyNodeId, that.specifyNodeId);
    }

    public int hashCode() {
        return Objects.hash(this.question, this.top, this.themes, this.source, this.sessionId, this.sourceQaPairId, this.alternativeAnswerEnable, this.productTypeId, this.specifyNodeId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QaAskReq {\n");
        sb.append("    question: ").append(this.toIndentedString(this.question)).append("\n");
        sb.append("    top: ").append(this.toIndentedString(this.top)).append("\n");
        sb.append("    themes: ").append(this.toIndentedString(this.themes)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    sourceQaPairId: ").append(this.toIndentedString(this.sourceQaPairId)).append("\n");
        sb.append("    alternativeAnswerEnable: ").append(this.toIndentedString(this.alternativeAnswerEnable)).append("\n");
        sb.append("    productTypeId: ").append(this.toIndentedString(this.productTypeId)).append("\n");
        sb.append("    specifyNodeId: ").append(this.toIndentedString(this.specifyNodeId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class SourceEnum {
        public static final SourceEnum PORTAL = new SourceEnum("PORTAL");
        public static final SourceEnum INCIDENT = new SourceEnum("INCIDENT");
        private static final Map<String, SourceEnum> STATIC_FIELDS = SourceEnum.createStaticFields();
        private String value;

        private static Map<String, SourceEnum> createStaticFields() {
            HashMap<String, SourceEnum> map = new HashMap<String, SourceEnum>();
            map.put("PORTAL", PORTAL);
            map.put("INCIDENT", INCIDENT);
            return Collections.unmodifiableMap(map);
        }

        SourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SourceEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new SourceEnum(value));
        }

        public static SourceEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof SourceEnum) {
                return this.value.equals(((SourceEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

