/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.orgid.v1;

import com.huaweicloud.sdk.core.ClientBuilder;
import com.huaweicloud.sdk.core.HcClient;
import com.huaweicloud.sdk.core.invoker.SyncInvoker;
import com.huaweicloud.sdk.orgid.v1.OrgIDMeta;
import com.huaweicloud.sdk.orgid.v1.model.ShowOauth2TokenRequest;
import com.huaweicloud.sdk.orgid.v1.model.ShowOauth2TokenResponse;
import com.huaweicloud.sdk.orgid.v1.model.ShowOauth2UserInfoRequest;
import com.huaweicloud.sdk.orgid.v1.model.ShowOauth2UserInfoResponse;
import com.huaweicloud.sdk.orgid.v1.model.ValidateServiceRequest;
import com.huaweicloud.sdk.orgid.v1.model.ValidateServiceResponse;

public class OrgIDClient {
    protected HcClient hcClient;

    public OrgIDClient(HcClient hcClient) {
        this.hcClient = hcClient;
    }

    public static ClientBuilder<OrgIDClient> newBuilder() {
        ClientBuilder clientBuilder = new ClientBuilder(OrgIDClient::new, "GlobalCredentials");
        return clientBuilder;
    }

    public ValidateServiceResponse validateService(ValidateServiceRequest request) {
        return (ValidateServiceResponse)((Object)this.hcClient.syncInvokeHttp((Object)request, OrgIDMeta.validateService));
    }

    public SyncInvoker<ValidateServiceRequest, ValidateServiceResponse> validateServiceInvoker(ValidateServiceRequest request) {
        return new SyncInvoker((Object)request, OrgIDMeta.validateService, this.hcClient);
    }

    public ShowOauth2TokenResponse showOauth2Token(ShowOauth2TokenRequest request) {
        return (ShowOauth2TokenResponse)((Object)this.hcClient.syncInvokeHttp((Object)request, OrgIDMeta.showOauth2Token));
    }

    public SyncInvoker<ShowOauth2TokenRequest, ShowOauth2TokenResponse> showOauth2TokenInvoker(ShowOauth2TokenRequest request) {
        return new SyncInvoker((Object)request, OrgIDMeta.showOauth2Token, this.hcClient);
    }

    public ShowOauth2UserInfoResponse showOauth2UserInfo(ShowOauth2UserInfoRequest request) {
        return (ShowOauth2UserInfoResponse)((Object)this.hcClient.syncInvokeHttp((Object)request, OrgIDMeta.showOauth2UserInfo));
    }

    public SyncInvoker<ShowOauth2UserInfoRequest, ShowOauth2UserInfoResponse> showOauth2UserInfoInvoker(ShowOauth2UserInfoRequest request) {
        return new SyncInvoker((Object)request, OrgIDMeta.showOauth2UserInfo, this.hcClient);
    }
}

