/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.orgid.v1;

import com.huaweicloud.sdk.core.ClientBuilder;
import com.huaweicloud.sdk.core.HcClient;
import com.huaweicloud.sdk.core.invoker.AsyncInvoker;
import com.huaweicloud.sdk.orgid.v1.OrgIDMeta;
import com.huaweicloud.sdk.orgid.v1.model.ShowOauth2TokenRequest;
import com.huaweicloud.sdk.orgid.v1.model.ShowOauth2TokenResponse;
import com.huaweicloud.sdk.orgid.v1.model.ShowOauth2UserInfoRequest;
import com.huaweicloud.sdk.orgid.v1.model.ShowOauth2UserInfoResponse;
import com.huaweicloud.sdk.orgid.v1.model.ValidateServiceRequest;
import com.huaweicloud.sdk.orgid.v1.model.ValidateServiceResponse;
import java.util.concurrent.CompletableFuture;

public class OrgIDAsyncClient {
    protected HcClient hcClient;

    public OrgIDAsyncClient(HcClient hcClient) {
        this.hcClient = hcClient;
    }

    public static ClientBuilder<OrgIDAsyncClient> newBuilder() {
        ClientBuilder clientBuilder = new ClientBuilder(OrgIDAsyncClient::new, "GlobalCredentials");
        return clientBuilder;
    }

    public CompletableFuture<ValidateServiceResponse> validateServiceAsync(ValidateServiceRequest request) {
        return this.hcClient.asyncInvokeHttp((Object)request, OrgIDMeta.validateService);
    }

    public AsyncInvoker<ValidateServiceRequest, ValidateServiceResponse> validateServiceAsyncInvoker(ValidateServiceRequest request) {
        return new AsyncInvoker((Object)request, OrgIDMeta.validateService, this.hcClient);
    }

    public CompletableFuture<ShowOauth2TokenResponse> showOauth2TokenAsync(ShowOauth2TokenRequest request) {
        return this.hcClient.asyncInvokeHttp((Object)request, OrgIDMeta.showOauth2Token);
    }

    public AsyncInvoker<ShowOauth2TokenRequest, ShowOauth2TokenResponse> showOauth2TokenAsyncInvoker(ShowOauth2TokenRequest request) {
        return new AsyncInvoker((Object)request, OrgIDMeta.showOauth2Token, this.hcClient);
    }

    public CompletableFuture<ShowOauth2UserInfoResponse> showOauth2UserInfoAsync(ShowOauth2UserInfoRequest request) {
        return this.hcClient.asyncInvokeHttp((Object)request, OrgIDMeta.showOauth2UserInfo);
    }

    public AsyncInvoker<ShowOauth2UserInfoRequest, ShowOauth2UserInfoResponse> showOauth2UserInfoAsyncInvoker(ShowOauth2UserInfoRequest request) {
        return new AsyncInvoker((Object)request, OrgIDMeta.showOauth2UserInfo, this.hcClient);
    }
}

