/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.oms.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.oms.v2.model.StatisticData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class StatisticTypeData {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="data_type")
    private DataTypeEnum dataType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="data")
    private List<StatisticData> data = null;

    public StatisticTypeData withDataType(DataTypeEnum dataType) {
        this.dataType = dataType;
        return this;
    }

    public DataTypeEnum getDataType() {
        return this.dataType;
    }

    public void setDataType(DataTypeEnum dataType) {
        this.dataType = dataType;
    }

    public StatisticTypeData withData(List<StatisticData> data) {
        this.data = data;
        return this;
    }

    public StatisticTypeData addDataItem(StatisticData dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<StatisticData>();
        }
        this.data.add(dataItem);
        return this;
    }

    public StatisticTypeData withData(Consumer<List<StatisticData>> dataSetter) {
        if (this.data == null) {
            this.data = new ArrayList<StatisticData>();
        }
        dataSetter.accept(this.data);
        return this;
    }

    public List<StatisticData> getData() {
        return this.data;
    }

    public void setData(List<StatisticData> data) {
        this.data = data;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StatisticTypeData that = (StatisticTypeData)obj;
        return Objects.equals(this.dataType, that.dataType) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.dataType, this.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StatisticTypeData {\n");
        sb.append("    dataType: ").append(this.toIndentedString(this.dataType)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class DataTypeEnum {
        public static final DataTypeEnum REQUEST = new DataTypeEnum("REQUEST");
        public static final DataTypeEnum SUCCESS = new DataTypeEnum("SUCCESS");
        public static final DataTypeEnum FAILURE = new DataTypeEnum("FAILURE");
        public static final DataTypeEnum SKIP = new DataTypeEnum("SKIP");
        public static final DataTypeEnum SIZE = new DataTypeEnum("SIZE");
        private static final Map<String, DataTypeEnum> STATIC_FIELDS = DataTypeEnum.createStaticFields();
        private String value;

        private static Map<String, DataTypeEnum> createStaticFields() {
            HashMap<String, DataTypeEnum> map = new HashMap<String, DataTypeEnum>();
            map.put("REQUEST", REQUEST);
            map.put("SUCCESS", SUCCESS);
            map.put("FAILURE", FAILURE);
            map.put("SKIP", SKIP);
            map.put("SIZE", SIZE);
            return Collections.unmodifiableMap(map);
        }

        DataTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DataTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new DataTypeEnum(value));
        }

        public static DataTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof DataTypeEnum) {
                return this.value.equals(((DataTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

