/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.oms.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class SmnConfig {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="language")
    private LanguageEnum language;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="topic_urn")
    private String topicUrn;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="trigger_conditions")
    private List<String> triggerConditions = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="message_template_name")
    private String messageTemplateName;

    public SmnConfig withLanguage(LanguageEnum language) {
        this.language = language;
        return this;
    }

    public LanguageEnum getLanguage() {
        return this.language;
    }

    public void setLanguage(LanguageEnum language) {
        this.language = language;
    }

    public SmnConfig withTopicUrn(String topicUrn) {
        this.topicUrn = topicUrn;
        return this;
    }

    public String getTopicUrn() {
        return this.topicUrn;
    }

    public void setTopicUrn(String topicUrn) {
        this.topicUrn = topicUrn;
    }

    public SmnConfig withTriggerConditions(List<String> triggerConditions) {
        this.triggerConditions = triggerConditions;
        return this;
    }

    public SmnConfig addTriggerConditionsItem(String triggerConditionsItem) {
        if (this.triggerConditions == null) {
            this.triggerConditions = new ArrayList<String>();
        }
        this.triggerConditions.add(triggerConditionsItem);
        return this;
    }

    public SmnConfig withTriggerConditions(Consumer<List<String>> triggerConditionsSetter) {
        if (this.triggerConditions == null) {
            this.triggerConditions = new ArrayList<String>();
        }
        triggerConditionsSetter.accept(this.triggerConditions);
        return this;
    }

    public List<String> getTriggerConditions() {
        return this.triggerConditions;
    }

    public void setTriggerConditions(List<String> triggerConditions) {
        this.triggerConditions = triggerConditions;
    }

    public SmnConfig withMessageTemplateName(String messageTemplateName) {
        this.messageTemplateName = messageTemplateName;
        return this;
    }

    public String getMessageTemplateName() {
        return this.messageTemplateName;
    }

    public void setMessageTemplateName(String messageTemplateName) {
        this.messageTemplateName = messageTemplateName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SmnConfig that = (SmnConfig)obj;
        return Objects.equals(this.language, that.language) && Objects.equals(this.topicUrn, that.topicUrn) && Objects.equals(this.triggerConditions, that.triggerConditions) && Objects.equals(this.messageTemplateName, that.messageTemplateName);
    }

    public int hashCode() {
        return Objects.hash(this.language, this.topicUrn, this.triggerConditions, this.messageTemplateName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SmnConfig {\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    topicUrn: ").append(this.toIndentedString(this.topicUrn)).append("\n");
        sb.append("    triggerConditions: ").append(this.toIndentedString(this.triggerConditions)).append("\n");
        sb.append("    messageTemplateName: ").append(this.toIndentedString(this.messageTemplateName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class LanguageEnum {
        public static final LanguageEnum ZH_CN = new LanguageEnum("zh-cn");
        public static final LanguageEnum EN_US = new LanguageEnum("en-us");
        private static final Map<String, LanguageEnum> STATIC_FIELDS = LanguageEnum.createStaticFields();
        private String value;

        private static Map<String, LanguageEnum> createStaticFields() {
            HashMap<String, LanguageEnum> map = new HashMap<String, LanguageEnum>();
            map.put("zh-cn", ZH_CN);
            map.put("en-us", EN_US);
            return Collections.unmodifiableMap(map);
        }

        LanguageEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LanguageEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new LanguageEnum(value));
        }

        public static LanguageEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof LanguageEnum) {
                return this.value.equals(((LanguageEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

