/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.kvs.v1.config;

import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.http.HttpConfig;
import com.huaweicloud.sdk.kvs.v1.ManagedKvsClient;
import com.huaweicloud.sdk.kvs.v1.config.KvsSdkConfig;
import com.huaweicloud.sdk.kvs.v1.model.Credential;
import com.huaweicloud.sdk.kvs.v1.model.Endpoint;
import java.io.File;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.ConfigurationBuilderEvent;
import org.apache.commons.configuration2.builder.ReloadingFileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.FileBasedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.event.Event;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.reloading.PeriodicReloadingTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KvsSdkConfigManager {
    private static final Logger LOG = LoggerFactory.getLogger(KvsSdkConfigManager.class);
    private final Boolean isAsyncClient;
    ReloadingFileBasedConfigurationBuilder<PropertiesConfiguration> configBuilder;
    private KvsSdkConfig sdkConfig;
    private final Credential credential = new Credential();
    private final ConcurrentLinkedDeque<Endpoint> endpoints = new ConcurrentLinkedDeque();

    public KvsSdkConfigManager(final String configFilePath, Boolean isAsyncClient, final ConcurrentHashMap<Integer, ManagedKvsClient> kvsClientMap, final ConcurrentHashMap<Long, ConcurrentHashMap<Integer, ManagedKvsClient>> oldKvsClientMaps, HttpConfig customizeHttpConfig) throws ConfigurationException {
        this.isAsyncClient = isAsyncClient;
        Parameters params = new Parameters();
        File propertiesFile = new File(configFilePath);
        this.configBuilder = new ReloadingFileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((FileBasedBuilderParameters)params.fileBased().setFile(propertiesFile)).setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','))});
        LOG.info("load KVS-SDK config file: " + configFilePath);
        this.reloadConfig(kvsClientMap, oldKvsClientMaps);
        if (customizeHttpConfig != null) {
            this.sdkConfig.setCustomizeHttpConfig(customizeHttpConfig);
        }
        this.configBuilder.addEventListener(ConfigurationBuilderEvent.RESET, new EventListener(){

            public void onEvent(Event event) {
                try {
                    LOG.info("load KVS-SDK config file: " + configFilePath);
                    KvsSdkConfigManager.this.reloadConfig(kvsClientMap, oldKvsClientMaps);
                }
                catch (ConfigurationException e) {
                    LOG.error("reload kvs sdk config file throw exception!", (Throwable)e);
                    throw new SdkException((Throwable)e);
                }
            }
        });
        PeriodicReloadingTrigger trigger = new PeriodicReloadingTrigger(this.configBuilder.getReloadingController(), null, (long)this.sdkConfig.getReloadInterval().intValue(), TimeUnit.SECONDS);
        trigger.start();
    }

    public KvsSdkConfig getConfig() {
        return this.sdkConfig;
    }

    private void reloadConfig(ConcurrentHashMap<Integer, ManagedKvsClient> kvsClientMap, ConcurrentHashMap<Long, ConcurrentHashMap<Integer, ManagedKvsClient>> oldKvsClientMaps) throws ConfigurationException {
        PropertiesConfiguration config = (PropertiesConfiguration)this.configBuilder.getConfiguration();
        this.sdkConfig = new KvsSdkConfig(config, this.isAsyncClient);
        this.reloadAKSKConfig(kvsClientMap, oldKvsClientMaps);
        this.reloadEndPointConfig(kvsClientMap);
    }

    private void reloadAKSKConfig(ConcurrentHashMap<Integer, ManagedKvsClient> kvsClientMap, ConcurrentHashMap<Long, ConcurrentHashMap<Integer, ManagedKvsClient>> oldKvsClientMaps) {
        if (this.credential.getAk() == null || !this.credential.getAk().equals(this.sdkConfig.getAK()) || this.credential.getSk() == null || !this.credential.getSk().equals(this.sdkConfig.getSK())) {
            this.credential.setAk(this.sdkConfig.getAK());
            this.credential.setSk(this.sdkConfig.getSK());
            this.credential.setStsToken(this.sdkConfig.getStsToken());
            ConcurrentHashMap<Integer, ManagedKvsClient> newKvsClientMap = new ConcurrentHashMap<Integer, ManagedKvsClient>(kvsClientMap);
            this.endpoints.clear();
            kvsClientMap.clear();
            oldKvsClientMaps.put(System.currentTimeMillis(), newKvsClientMap);
        }
    }

    private void reloadEndPointConfig(ConcurrentHashMap<Integer, ManagedKvsClient> kvsClientMap) {
        for (Endpoint endpoint : this.getNewEndpoints()) {
            ManagedKvsClient newKvsClient = new ManagedKvsClient(endpoint, this.sdkConfig);
            this.endpoints.add(endpoint);
            kvsClientMap.put(kvsClientMap.size() + 1, newKvsClient);
        }
    }

    private List<Endpoint> getNewEndpoints() {
        List<Endpoint> newEndpointList = this.sdkConfig.loadEndPointList();
        return newEndpointList.stream().filter(newEndpoint -> !this.endpoints.stream().map(Endpoint::getName).collect(Collectors.toList()).contains(newEndpoint.getName())).collect(Collectors.toList());
    }
}

