/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.kvs.v1;

import com.huaweicloud.sdk.core.exception.ConnectionException;
import com.huaweicloud.sdk.core.exception.RequestTimeoutException;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.http.HttpConfig;
import com.huaweicloud.sdk.core.invoker.SyncInvoker;
import com.huaweicloud.sdk.kvs.v1.AbstractMultiChannelKvsClient;
import com.huaweicloud.sdk.kvs.v1.IKvsClient;
import com.huaweicloud.sdk.kvs.v1.KvsClientHeartbeatKeeper;
import com.huaweicloud.sdk.kvs.v1.ManagedKvsClient;
import com.huaweicloud.sdk.kvs.v1.config.KvsSdkConfig;
import com.huaweicloud.sdk.kvs.v1.config.KvsSdkConfigManager;
import com.huaweicloud.sdk.kvs.v1.model.BatchWriteKvRequest;
import com.huaweicloud.sdk.kvs.v1.model.BatchWriteKvResponse;
import com.huaweicloud.sdk.kvs.v1.model.CheckHealthRequest;
import com.huaweicloud.sdk.kvs.v1.model.CheckHealthResponse;
import com.huaweicloud.sdk.kvs.v1.model.CreateTableRequest;
import com.huaweicloud.sdk.kvs.v1.model.CreateTableResponse;
import com.huaweicloud.sdk.kvs.v1.model.DeleteKvRequest;
import com.huaweicloud.sdk.kvs.v1.model.DeleteKvResponse;
import com.huaweicloud.sdk.kvs.v1.model.DescribeTableRequest;
import com.huaweicloud.sdk.kvs.v1.model.DescribeTableResponse;
import com.huaweicloud.sdk.kvs.v1.model.GetKvRequest;
import com.huaweicloud.sdk.kvs.v1.model.GetKvResponse;
import com.huaweicloud.sdk.kvs.v1.model.ListStoreRequest;
import com.huaweicloud.sdk.kvs.v1.model.ListStoreResponse;
import com.huaweicloud.sdk.kvs.v1.model.ListTableRequest;
import com.huaweicloud.sdk.kvs.v1.model.ListTableResponse;
import com.huaweicloud.sdk.kvs.v1.model.PutKvRequest;
import com.huaweicloud.sdk.kvs.v1.model.PutKvResponse;
import com.huaweicloud.sdk.kvs.v1.model.ScanKvRequest;
import com.huaweicloud.sdk.kvs.v1.model.ScanKvResponse;
import com.huaweicloud.sdk.kvs.v1.model.ScanSkeyKvRequest;
import com.huaweicloud.sdk.kvs.v1.model.ScanSkeyKvResponse;
import com.huaweicloud.sdk.kvs.v1.model.UpdateKvRequest;
import com.huaweicloud.sdk.kvs.v1.model.UpdateKvResponse;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiChannelKvsClient
extends AbstractMultiChannelKvsClient
implements IKvsClient {
    private static final Logger LOG = LoggerFactory.getLogger(MultiChannelKvsClient.class);
    private final KvsSdkConfigManager configManager;
    private final KvsClientHeartbeatKeeper heartbeatKeeper;
    private final Integer totalTimeoutMs;
    private final Timer oldClientMapCleanTimer;

    public MultiChannelKvsClient(String configFilePath) throws ConfigurationException {
        this(configFilePath, null);
    }

    public MultiChannelKvsClient(String configFilePath, HttpConfig customizeHttpConfig) throws ConfigurationException {
        this.configManager = new KvsSdkConfigManager(configFilePath, false, this.kvsClientMap, this.oldKvsClientMaps, customizeHttpConfig);
        KvsSdkConfig config = this.configManager.getConfig();
        this.totalTimeoutMs = config.getConnectionTimeout() * 1000 + config.getReadTimeout() * 1000;
        this.heartbeatKeeper = new KvsClientHeartbeatKeeper(this.kvsClientMap, config.getHeartbeatInterval() * 1000, config.getHeartbeatThreadPoolSize());
        this.oldClientMapCleanTimer = new Timer("oldClientMapCleanTimer");
        this.oldClientMapCleanTimer.schedule((TimerTask)new oldClientMapCleanTask(), this.totalTimeoutMs.intValue(), (long)this.totalTimeoutMs.intValue());
    }

    public void close() {
        this.heartbeatKeeper.close();
        this.oldClientMapCleanTimer.cancel();
        this.oldClientMapCleanTimer.purge();
        LOG.info("MultiChannelKvsClient is closed !");
    }

    public KvsSdkConfig getConfig() {
        return this.configManager.getConfig();
    }

    public ConcurrentHashMap<Long, ConcurrentHashMap<Integer, ManagedKvsClient>> getOldKvsClientMaps() {
        return this.oldKvsClientMaps;
    }

    @Override
    public CreateTableResponse createTable(CreateTableRequest request) {
        int retryCount = 0;
        while (retryCount < this.getConfig().getApiRetryCount()) {
            ManagedKvsClient client = this.getKvsClientByPolling(retryCount);
            try {
                return client.getKvsClient().createTable(request);
            }
            catch (ConnectionException | RequestTimeoutException e) {
                client.setIsUsable(false);
                LOG.warn("this is client " + client.getEndpointName() + " createTable throwing Exception " + ++retryCount + " time. errorInfo: " + e, e);
            }
        }
        throw new SdkException("retry createTable " + retryCount + " times, and failed!");
    }

    @Override
    public SyncInvoker<CreateTableRequest, CreateTableResponse> createTableInvoker(CreateTableRequest request) {
        return this.getKvsClientByPolling().getKvsClient().createTableInvoker(request);
    }

    @Override
    public DescribeTableResponse describeTable(DescribeTableRequest request) {
        int retryCount = 0;
        while (retryCount < this.getConfig().getApiRetryCount()) {
            ManagedKvsClient client = this.getKvsClientByPolling(retryCount);
            try {
                return client.getKvsClient().describeTable(request);
            }
            catch (ConnectionException | RequestTimeoutException e) {
                client.setIsUsable(false);
                LOG.warn("this is client " + client.getEndpointName() + " describeTable throwing Exception " + ++retryCount + " time. errorInfo: " + e, e);
            }
        }
        throw new SdkException("retry describeTable " + retryCount + " times, and failed!");
    }

    @Override
    public SyncInvoker<DescribeTableRequest, DescribeTableResponse> describeTableInvoker(DescribeTableRequest request) {
        return this.getKvsClientByPolling().getKvsClient().describeTableInvoker(request);
    }

    @Override
    public ListStoreResponse listStore(ListStoreRequest request) {
        int retryCount = 0;
        while (retryCount < this.getConfig().getApiRetryCount()) {
            ManagedKvsClient client = this.getKvsClientByPolling(retryCount);
            try {
                return client.getKvsClient().listStore(request);
            }
            catch (ConnectionException | RequestTimeoutException e) {
                client.setIsUsable(false);
                LOG.warn("this is client " + client.getEndpointName() + " listStore throwing Exception " + ++retryCount + " time. errorInfo: " + e, e);
            }
        }
        throw new SdkException("retry listStore " + retryCount + " times, and failed!");
    }

    @Override
    public SyncInvoker<ListStoreRequest, ListStoreResponse> listStoreInvoker(ListStoreRequest request) {
        return this.getKvsClientByPolling().getKvsClient().listStoreInvoker(request);
    }

    @Override
    public ListTableResponse listTable(ListTableRequest request) {
        int retryCount = 0;
        while (retryCount < this.getConfig().getApiRetryCount()) {
            ManagedKvsClient client = this.getKvsClientByPolling(retryCount);
            try {
                return client.getKvsClient().listTable(request);
            }
            catch (ConnectionException | RequestTimeoutException e) {
                client.setIsUsable(false);
                LOG.warn("this is client " + client.getEndpointName() + " listTable throwing Exception " + ++retryCount + " time. errorInfo: " + e, e);
            }
        }
        throw new SdkException("retry listTable " + retryCount + " times, and failed!");
    }

    @Override
    public SyncInvoker<ListTableRequest, ListTableResponse> listTableInvoker(ListTableRequest request) {
        return this.getKvsClientByPolling().getKvsClient().listTableInvoker(request);
    }

    @Override
    public CheckHealthResponse checkHealth(CheckHealthRequest request) {
        int retryCount = 0;
        while (retryCount < this.getConfig().getApiRetryCount()) {
            ManagedKvsClient client = this.getKvsClientByPolling(retryCount);
            try {
                return client.getKvsClient().checkHealth(request);
            }
            catch (ConnectionException | RequestTimeoutException e) {
                client.setIsUsable(false);
                LOG.warn("this is client " + client.getEndpointName() + " checkHealth throwing Exception " + ++retryCount + " time. errorInfo: " + e, e);
            }
        }
        throw new SdkException("retry checkHealth " + retryCount + " times, and failed!");
    }

    @Override
    public SyncInvoker<CheckHealthRequest, CheckHealthResponse> checkHealthInvoker(CheckHealthRequest request) {
        return this.getKvsClientByPolling().getKvsClient().checkHealthInvoker(request);
    }

    @Override
    public BatchWriteKvResponse batchWriteKv(BatchWriteKvRequest request) {
        int retryCount = 0;
        while (retryCount < this.getConfig().getApiRetryCount()) {
            ManagedKvsClient client = this.getKvsClientByPolling(retryCount);
            try {
                return client.getKvsClient().batchWriteKv(request);
            }
            catch (ConnectionException | RequestTimeoutException e) {
                client.setIsUsable(false);
                LOG.warn("this is client " + client.getEndpointName() + " batchWriteKv throwing Exception " + ++retryCount + " time. errorInfo: " + e, e);
            }
        }
        throw new SdkException("retry batchWriteKv " + retryCount + " times, and failed!");
    }

    @Override
    public SyncInvoker<BatchWriteKvRequest, BatchWriteKvResponse> batchWriteKvInvoker(BatchWriteKvRequest request) {
        return this.getKvsClientByPolling().getKvsClient().batchWriteKvInvoker(request);
    }

    @Override
    public DeleteKvResponse deleteKv(DeleteKvRequest request) {
        int retryCount = 0;
        while (retryCount < this.getConfig().getApiRetryCount()) {
            ManagedKvsClient client = this.getKvsClientByPolling(retryCount);
            try {
                return client.getKvsClient().deleteKv(request);
            }
            catch (ConnectionException | RequestTimeoutException e) {
                client.setIsUsable(false);
                LOG.warn("this is client " + client.getEndpointName() + " deleteKv throwing Exception " + ++retryCount + " time. errorInfo: " + e, e);
            }
        }
        throw new SdkException("retry deleteKv " + retryCount + " times, and failed!");
    }

    @Override
    public SyncInvoker<DeleteKvRequest, DeleteKvResponse> deleteKvInvoker(DeleteKvRequest request) {
        return this.getKvsClientByPolling().getKvsClient().deleteKvInvoker(request);
    }

    @Override
    public GetKvResponse getKv(GetKvRequest request) {
        int retryCount = 0;
        while (retryCount < this.getConfig().getApiRetryCount()) {
            ManagedKvsClient client = this.getKvsClientByPolling(retryCount);
            try {
                return client.getKvsClient().getKv(request);
            }
            catch (ConnectionException | RequestTimeoutException e) {
                client.setIsUsable(false);
                LOG.warn("this is client " + client.getEndpointName() + " getKv throwing Exception " + ++retryCount + " time. errorInfo: " + e, e);
            }
        }
        throw new SdkException("retry getKv " + retryCount + " times, and failed!");
    }

    @Override
    public SyncInvoker<GetKvRequest, GetKvResponse> getKvInvoker(GetKvRequest request) {
        return this.getKvsClientByPolling().getKvsClient().getKvInvoker(request);
    }

    @Override
    public PutKvResponse putKv(PutKvRequest request) {
        int retryCount = 0;
        while (retryCount < this.getConfig().getApiRetryCount()) {
            ManagedKvsClient client = this.getKvsClientByPolling(retryCount);
            try {
                return client.getKvsClient().putKv(request);
            }
            catch (ConnectionException | RequestTimeoutException e) {
                client.setIsUsable(false);
                LOG.warn("this is client " + client.getEndpointName() + " putKv throwing Exception " + ++retryCount + " time. errorInfo: " + e, e);
            }
        }
        throw new SdkException("retry putKv " + retryCount + " times, and failed!");
    }

    @Override
    public SyncInvoker<PutKvRequest, PutKvResponse> putKvInvoker(PutKvRequest request) {
        return this.getKvsClientByPolling().getKvsClient().putKvInvoker(request);
    }

    @Override
    public ScanKvResponse scanKv(ScanKvRequest request) {
        int retryCount = 0;
        while (retryCount < this.getConfig().getApiRetryCount()) {
            ManagedKvsClient client = this.getKvsClientByPolling(retryCount);
            try {
                return client.getKvsClient().scanKv(request);
            }
            catch (ConnectionException | RequestTimeoutException e) {
                client.setIsUsable(false);
                LOG.warn("this is client " + client.getEndpointName() + " scanKv throwing Exception " + ++retryCount + " time. errorInfo: " + e, e);
            }
        }
        throw new SdkException("retry scanKv " + retryCount + " times, and failed!");
    }

    @Override
    public SyncInvoker<ScanKvRequest, ScanKvResponse> scanKvInvoker(ScanKvRequest request) {
        return this.getKvsClientByPolling().getKvsClient().scanKvInvoker(request);
    }

    @Override
    public ScanSkeyKvResponse scanSkeyKv(ScanSkeyKvRequest request) {
        int retryCount = 0;
        while (retryCount < this.getConfig().getApiRetryCount()) {
            ManagedKvsClient client = this.getKvsClientByPolling(retryCount);
            try {
                return client.getKvsClient().scanSkeyKv(request);
            }
            catch (ConnectionException | RequestTimeoutException e) {
                client.setIsUsable(false);
                LOG.warn("this is client " + client.getEndpointName() + " scanSkeyKv throwing Exception " + ++retryCount + " time. errorInfo: " + e, e);
            }
        }
        throw new SdkException("retry scanSkeyKv " + retryCount + " times, and failed!");
    }

    @Override
    public SyncInvoker<ScanSkeyKvRequest, ScanSkeyKvResponse> scanSkeyKvInvoker(ScanSkeyKvRequest request) {
        return this.getKvsClientByPolling().getKvsClient().scanSkeyKvInvoker(request);
    }

    @Override
    public UpdateKvResponse updateKv(UpdateKvRequest request) {
        int retryCount = 0;
        while (retryCount < this.getConfig().getApiRetryCount()) {
            ManagedKvsClient client = this.getKvsClientByPolling(retryCount);
            try {
                return client.getKvsClient().updateKv(request);
            }
            catch (ConnectionException | RequestTimeoutException e) {
                client.setIsUsable(false);
                LOG.warn("this is client " + client.getEndpointName() + " updateKv throwing Exception " + ++retryCount + " time. errorInfo: " + e, e);
            }
        }
        throw new SdkException("retry updateKv " + retryCount + " times, and failed!");
    }

    @Override
    public SyncInvoker<UpdateKvRequest, UpdateKvResponse> updateKvInvoker(UpdateKvRequest request) {
        return this.getKvsClientByPolling().getKvsClient().updateKvInvoker(request);
    }

    private class oldClientMapCleanTask
    extends TimerTask {
        private oldClientMapCleanTask() {
        }

        @Override
        public void run() {
            MultiChannelKvsClient.this.oldKvsClientMaps = (ConcurrentHashMap)MultiChannelKvsClient.this.oldKvsClientMaps.entrySet().stream().filter(entry -> System.currentTimeMillis() < (Long)entry.getKey() + (long)MultiChannelKvsClient.this.totalTimeoutMs.intValue()).collect(Collectors.toConcurrentMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }
}

