/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.kvs.v1;

import com.huaweicloud.sdk.core.exception.ConnectionException;
import com.huaweicloud.sdk.core.exception.RequestTimeoutException;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.http.HttpConfig;
import com.huaweicloud.sdk.core.invoker.AsyncInvoker;
import com.huaweicloud.sdk.kvs.v1.AbstractMultiChannelKvsClient;
import com.huaweicloud.sdk.kvs.v1.IKvsAsyncClient;
import com.huaweicloud.sdk.kvs.v1.KvsClientHeartbeatKeeper;
import com.huaweicloud.sdk.kvs.v1.ManagedKvsClient;
import com.huaweicloud.sdk.kvs.v1.config.KvsSdkConfig;
import com.huaweicloud.sdk.kvs.v1.config.KvsSdkConfigManager;
import com.huaweicloud.sdk.kvs.v1.model.BatchWriteKvRequest;
import com.huaweicloud.sdk.kvs.v1.model.BatchWriteKvResponse;
import com.huaweicloud.sdk.kvs.v1.model.CheckHealthRequest;
import com.huaweicloud.sdk.kvs.v1.model.CheckHealthResponse;
import com.huaweicloud.sdk.kvs.v1.model.CreateTableRequest;
import com.huaweicloud.sdk.kvs.v1.model.CreateTableResponse;
import com.huaweicloud.sdk.kvs.v1.model.DeleteKvRequest;
import com.huaweicloud.sdk.kvs.v1.model.DeleteKvResponse;
import com.huaweicloud.sdk.kvs.v1.model.DescribeTableRequest;
import com.huaweicloud.sdk.kvs.v1.model.DescribeTableResponse;
import com.huaweicloud.sdk.kvs.v1.model.GetKvRequest;
import com.huaweicloud.sdk.kvs.v1.model.GetKvResponse;
import com.huaweicloud.sdk.kvs.v1.model.ListStoreRequest;
import com.huaweicloud.sdk.kvs.v1.model.ListStoreResponse;
import com.huaweicloud.sdk.kvs.v1.model.ListTableRequest;
import com.huaweicloud.sdk.kvs.v1.model.ListTableResponse;
import com.huaweicloud.sdk.kvs.v1.model.PutKvRequest;
import com.huaweicloud.sdk.kvs.v1.model.PutKvResponse;
import com.huaweicloud.sdk.kvs.v1.model.ScanKvRequest;
import com.huaweicloud.sdk.kvs.v1.model.ScanKvResponse;
import com.huaweicloud.sdk.kvs.v1.model.ScanSkeyKvRequest;
import com.huaweicloud.sdk.kvs.v1.model.ScanSkeyKvResponse;
import com.huaweicloud.sdk.kvs.v1.model.UpdateKvRequest;
import com.huaweicloud.sdk.kvs.v1.model.UpdateKvResponse;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiChannelKvsAsyncClient
extends AbstractMultiChannelKvsClient
implements IKvsAsyncClient {
    private static final Logger LOG = LoggerFactory.getLogger(MultiChannelKvsAsyncClient.class);
    private final KvsSdkConfigManager configManager;
    private final KvsClientHeartbeatKeeper heartbeatKeeper;
    private final Integer totalTimeoutMs;
    private final Timer oldClientMapCleanTimer;

    public MultiChannelKvsAsyncClient(String configFilePath) throws ConfigurationException {
        this(configFilePath, null);
    }

    public MultiChannelKvsAsyncClient(String configFilePath, HttpConfig customizeHttpConfig) throws ConfigurationException {
        this.configManager = new KvsSdkConfigManager(configFilePath, false, this.kvsClientMap, this.oldKvsClientMaps, customizeHttpConfig);
        KvsSdkConfig config = this.configManager.getConfig();
        this.totalTimeoutMs = config.getConnectionTimeout() * 1000 + config.getReadTimeout() * 1000;
        this.heartbeatKeeper = new KvsClientHeartbeatKeeper(this.kvsClientMap, config.getHeartbeatInterval() * 1000, config.getHeartbeatThreadPoolSize());
        this.oldClientMapCleanTimer = new Timer("oldClientMapCleanTimer");
        this.oldClientMapCleanTimer.schedule((TimerTask)new oldClientMapCleanTask(), this.totalTimeoutMs.intValue(), (long)this.totalTimeoutMs.intValue());
    }

    public void close() {
        this.heartbeatKeeper.close();
        this.oldClientMapCleanTimer.cancel();
        this.oldClientMapCleanTimer.purge();
        LOG.info("MultiChannelKvsAsyncClient is closed !");
    }

    public KvsSdkConfig getConfig() {
        return this.configManager.getConfig();
    }

    public ConcurrentHashMap<Long, ConcurrentHashMap<Integer, ManagedKvsClient>> getOldKvsClientMaps() {
        return this.oldKvsClientMaps;
    }

    @Override
    public CompletableFuture<CreateTableResponse> createTableAsync(CreateTableRequest request) {
        int retryCount = 0;
        while (retryCount < this.getConfig().getApiRetryCount()) {
            ManagedKvsClient client = this.getKvsClientByPolling(retryCount);
            try {
                return client.getKvsAsyncClient().createTableAsync(request);
            }
            catch (ConnectionException | RequestTimeoutException e) {
                client.setIsUsable(false);
                LOG.warn("this is client " + client.getEndpointName() + " createTable throwing Exception " + ++retryCount + " time. errorInfo: " + e, e);
            }
        }
        throw new SdkException("retry createTable " + retryCount + " times, and failed!");
    }

    @Override
    public AsyncInvoker<CreateTableRequest, CreateTableResponse> createTableAsyncInvoker(CreateTableRequest request) {
        return this.getKvsClientByPolling().getKvsAsyncClient().createTableAsyncInvoker(request);
    }

    @Override
    public CompletableFuture<DescribeTableResponse> describeTableAsync(DescribeTableRequest request) {
        int retryCount = 0;
        while (retryCount < this.getConfig().getApiRetryCount()) {
            ManagedKvsClient client = this.getKvsClientByPolling(retryCount);
            try {
                return client.getKvsAsyncClient().describeTableAsync(request);
            }
            catch (ConnectionException | RequestTimeoutException e) {
                client.setIsUsable(false);
                LOG.warn("this is client " + client.getEndpointName() + " describeTable throwing Exception " + ++retryCount + " time. errorInfo: " + e, e);
            }
        }
        throw new SdkException("retry describeTable " + retryCount + " times, and failed!");
    }

    @Override
    public AsyncInvoker<DescribeTableRequest, DescribeTableResponse> describeTableAsyncInvoker(DescribeTableRequest request) {
        return this.getKvsClientByPolling().getKvsAsyncClient().describeTableAsyncInvoker(request);
    }

    @Override
    public CompletableFuture<ListStoreResponse> listStoreAsync(ListStoreRequest request) {
        int retryCount = 0;
        while (retryCount < this.getConfig().getApiRetryCount()) {
            ManagedKvsClient client = this.getKvsClientByPolling(retryCount);
            try {
                return client.getKvsAsyncClient().listStoreAsync(request);
            }
            catch (ConnectionException | RequestTimeoutException e) {
                client.setIsUsable(false);
                LOG.warn("this is client " + client.getEndpointName() + " listStore throwing Exception " + ++retryCount + " time. errorInfo: " + e, e);
            }
        }
        throw new SdkException("retry listStore " + retryCount + " times, and failed!");
    }

    @Override
    public AsyncInvoker<ListStoreRequest, ListStoreResponse> listStoreAsyncInvoker(ListStoreRequest request) {
        return this.getKvsClientByPolling().getKvsAsyncClient().listStoreAsyncInvoker(request);
    }

    @Override
    public CompletableFuture<ListTableResponse> listTableAsync(ListTableRequest request) {
        int retryCount = 0;
        while (retryCount < this.getConfig().getApiRetryCount()) {
            ManagedKvsClient client = this.getKvsClientByPolling(retryCount);
            try {
                return client.getKvsAsyncClient().listTableAsync(request);
            }
            catch (ConnectionException | RequestTimeoutException e) {
                client.setIsUsable(false);
                LOG.warn("this is client " + client.getEndpointName() + " listTable throwing Exception " + ++retryCount + " time. errorInfo: " + e, e);
            }
        }
        throw new SdkException("retry listTable " + retryCount + " times, and failed!");
    }

    @Override
    public AsyncInvoker<ListTableRequest, ListTableResponse> listTableAsyncInvoker(ListTableRequest request) {
        return this.getKvsClientByPolling().getKvsAsyncClient().listTableAsyncInvoker(request);
    }

    @Override
    public CompletableFuture<CheckHealthResponse> checkHealthAsync(CheckHealthRequest request) {
        int retryCount = 0;
        while (retryCount < this.getConfig().getApiRetryCount()) {
            ManagedKvsClient client = this.getKvsClientByPolling(retryCount);
            try {
                return client.getKvsAsyncClient().checkHealthAsync(request);
            }
            catch (ConnectionException | RequestTimeoutException e) {
                client.setIsUsable(false);
                LOG.warn("this is client " + client.getEndpointName() + " checkHealth throwing Exception " + ++retryCount + " time. errorInfo: " + e, e);
            }
        }
        throw new SdkException("retry checkHealth " + retryCount + " times, and failed!");
    }

    @Override
    public AsyncInvoker<CheckHealthRequest, CheckHealthResponse> checkHealthAsyncInvoker(CheckHealthRequest request) {
        return this.getKvsClientByPolling().getKvsAsyncClient().checkHealthAsyncInvoker(request);
    }

    @Override
    public CompletableFuture<BatchWriteKvResponse> batchWriteKvAsync(BatchWriteKvRequest request) {
        int retryCount = 0;
        while (retryCount < this.getConfig().getApiRetryCount()) {
            ManagedKvsClient client = this.getKvsClientByPolling(retryCount);
            try {
                return client.getKvsAsyncClient().batchWriteKvAsync(request);
            }
            catch (ConnectionException | RequestTimeoutException e) {
                client.setIsUsable(false);
                LOG.warn("this is client " + client.getEndpointName() + " batchWriteKv throwing Exception " + ++retryCount + " time. errorInfo: " + e, e);
            }
        }
        throw new SdkException("retry batchWriteKv " + retryCount + " times, and failed!");
    }

    @Override
    public AsyncInvoker<BatchWriteKvRequest, BatchWriteKvResponse> batchWriteKvAsyncInvoker(BatchWriteKvRequest request) {
        return this.getKvsClientByPolling().getKvsAsyncClient().batchWriteKvAsyncInvoker(request);
    }

    @Override
    public CompletableFuture<DeleteKvResponse> deleteKvAsync(DeleteKvRequest request) {
        int retryCount = 0;
        while (retryCount < this.getConfig().getApiRetryCount()) {
            ManagedKvsClient client = this.getKvsClientByPolling(retryCount);
            try {
                return client.getKvsAsyncClient().deleteKvAsync(request);
            }
            catch (ConnectionException | RequestTimeoutException e) {
                client.setIsUsable(false);
                LOG.warn("this is client " + client.getEndpointName() + " deleteKv throwing Exception " + ++retryCount + " time. errorInfo: " + e, e);
            }
        }
        throw new SdkException("retry deleteKv " + retryCount + " times, and failed!");
    }

    @Override
    public AsyncInvoker<DeleteKvRequest, DeleteKvResponse> deleteKvAsyncInvoker(DeleteKvRequest request) {
        return this.getKvsClientByPolling().getKvsAsyncClient().deleteKvAsyncInvoker(request);
    }

    @Override
    public CompletableFuture<GetKvResponse> getKvAsync(GetKvRequest request) {
        int retryCount = 0;
        while (retryCount < this.getConfig().getApiRetryCount()) {
            ManagedKvsClient client = this.getKvsClientByPolling(retryCount);
            try {
                return client.getKvsAsyncClient().getKvAsync(request);
            }
            catch (ConnectionException | RequestTimeoutException e) {
                client.setIsUsable(false);
                LOG.warn("this is client " + client.getEndpointName() + " getKv throwing Exception " + ++retryCount + " time. errorInfo: " + e, e);
            }
        }
        throw new SdkException("retry getKv " + retryCount + " times, and failed!");
    }

    @Override
    public AsyncInvoker<GetKvRequest, GetKvResponse> getKvAsyncInvoker(GetKvRequest request) {
        return this.getKvsClientByPolling().getKvsAsyncClient().getKvAsyncInvoker(request);
    }

    @Override
    public CompletableFuture<PutKvResponse> putKvAsync(PutKvRequest request) {
        int retryCount = 0;
        while (retryCount < this.getConfig().getApiRetryCount()) {
            ManagedKvsClient client = this.getKvsClientByPolling(retryCount);
            try {
                return client.getKvsAsyncClient().putKvAsync(request);
            }
            catch (ConnectionException | RequestTimeoutException e) {
                client.setIsUsable(false);
                LOG.warn("this is client " + client.getEndpointName() + " putKv throwing Exception " + ++retryCount + " time. errorInfo: " + e, e);
            }
        }
        throw new SdkException("retry putKv " + retryCount + " times, and failed!");
    }

    @Override
    public AsyncInvoker<PutKvRequest, PutKvResponse> putKvAsyncInvoker(PutKvRequest request) {
        return this.getKvsClientByPolling().getKvsAsyncClient().putKvAsyncInvoker(request);
    }

    @Override
    public CompletableFuture<ScanKvResponse> scanKvAsync(ScanKvRequest request) {
        int retryCount = 0;
        while (retryCount < this.getConfig().getApiRetryCount()) {
            ManagedKvsClient client = this.getKvsClientByPolling(retryCount);
            try {
                return client.getKvsAsyncClient().scanKvAsync(request);
            }
            catch (ConnectionException | RequestTimeoutException e) {
                client.setIsUsable(false);
                LOG.warn("this is client " + client.getEndpointName() + " scanKv throwing Exception " + ++retryCount + " time. errorInfo: " + e, e);
            }
        }
        throw new SdkException("retry scanKv " + retryCount + " times, and failed!");
    }

    @Override
    public AsyncInvoker<ScanKvRequest, ScanKvResponse> scanKvAsyncInvoker(ScanKvRequest request) {
        return this.getKvsClientByPolling().getKvsAsyncClient().scanKvAsyncInvoker(request);
    }

    @Override
    public CompletableFuture<ScanSkeyKvResponse> scanSkeyKvAsync(ScanSkeyKvRequest request) {
        int retryCount = 0;
        while (retryCount < this.getConfig().getApiRetryCount()) {
            ManagedKvsClient client = this.getKvsClientByPolling(retryCount);
            try {
                return client.getKvsAsyncClient().scanSkeyKvAsync(request);
            }
            catch (ConnectionException | RequestTimeoutException e) {
                client.setIsUsable(false);
                LOG.warn("this is client " + client.getEndpointName() + " scanSkeyKv throwing Exception " + ++retryCount + " time. errorInfo: " + e, e);
            }
        }
        throw new SdkException("retry scanSkeyKv " + retryCount + " times, and failed!");
    }

    @Override
    public AsyncInvoker<ScanSkeyKvRequest, ScanSkeyKvResponse> scanSkeyKvAsyncInvoker(ScanSkeyKvRequest request) {
        return this.getKvsClientByPolling().getKvsAsyncClient().scanSkeyKvAsyncInvoker(request);
    }

    @Override
    public CompletableFuture<UpdateKvResponse> updateKvAsync(UpdateKvRequest request) {
        int retryCount = 0;
        while (retryCount < this.getConfig().getApiRetryCount()) {
            ManagedKvsClient client = this.getKvsClientByPolling(retryCount);
            try {
                return client.getKvsAsyncClient().updateKvAsync(request);
            }
            catch (ConnectionException | RequestTimeoutException e) {
                client.setIsUsable(false);
                LOG.warn("this is client " + client.getEndpointName() + " updateKv throwing Exception " + ++retryCount + " time. errorInfo: " + e, e);
            }
        }
        throw new SdkException("retry updateKv " + retryCount + " times, and failed!");
    }

    @Override
    public AsyncInvoker<UpdateKvRequest, UpdateKvResponse> updateKvAsyncInvoker(UpdateKvRequest request) {
        return this.getKvsClientByPolling().getKvsAsyncClient().updateKvAsyncInvoker(request);
    }

    private class oldClientMapCleanTask
    extends TimerTask {
        private oldClientMapCleanTask() {
        }

        @Override
        public void run() {
            MultiChannelKvsAsyncClient.this.oldKvsClientMaps = (ConcurrentHashMap)MultiChannelKvsAsyncClient.this.oldKvsClientMaps.entrySet().stream().filter(entry -> System.currentTimeMillis() < (Long)entry.getKey() + (long)MultiChannelKvsAsyncClient.this.totalTimeoutMs.intValue()).collect(Collectors.toConcurrentMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }
}

