/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.kvs.v1;

import com.huaweicloud.sdk.core.auth.BasicCredentials;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.http.HttpConfig;
import com.huaweicloud.sdk.core.region.Region;
import com.huaweicloud.sdk.kvs.v1.KvsAsyncClient;
import com.huaweicloud.sdk.kvs.v1.KvsClient;
import com.huaweicloud.sdk.kvs.v1.config.KvsSdkConfig;
import com.huaweicloud.sdk.kvs.v1.model.Credential;
import com.huaweicloud.sdk.kvs.v1.model.Endpoint;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;

public class ManagedKvsClient {
    private final Endpoint endpoint;
    private final Credential credential;
    private final Boolean isAsyncClient;
    private KvsAsyncClient kvsAsyncClient;
    private KvsClient kvsClient;
    private final AtomicBoolean isUsable = new AtomicBoolean(true);

    public ManagedKvsClient(Endpoint endpoint, KvsSdkConfig config) {
        this.endpoint = endpoint;
        this.credential = new Credential().withAk(config.getAK()).withSk(config.getSK()).withStsToken(config.getStsToken());
        this.isAsyncClient = config.isAsyncClient();
        BasicCredentials credentials = ((BasicCredentials)((BasicCredentials)new BasicCredentials().withAk(this.credential.getAk())).withSk(this.credential.getSk())).withProjectId(config.getProjectId());
        if (this.credential.getStsToken() != null && !this.credential.getStsToken().isEmpty()) {
            credentials.withSecurityToken(this.credential.getStsToken());
        }
        Region region = new Region(config.getRegionId(), "https://" + endpoint.getName() + "." + config.getRegionId() + ".myhuaweicloud.com");
        HttpConfig httpConfig = config.getCustomizeHttpConfig();
        if (httpConfig == null) {
            httpConfig = this.getHttpConfigBySdkConfig(config);
        }
        if (this.isAsyncClient.booleanValue()) {
            this.kvsAsyncClient = (KvsAsyncClient)KvsAsyncClient.newBuilder().withCredential((ICredential)credentials).withRegion(region).withHttpConfig(httpConfig).build();
        } else {
            this.kvsClient = (KvsClient)KvsClient.newBuilder().withCredential((ICredential)credentials).withRegion(region).withHttpConfig(httpConfig).build();
        }
    }

    private HttpConfig getHttpConfigBySdkConfig(KvsSdkConfig config) {
        HttpConfig httpConfig = HttpConfig.getDefaultHttpConfig();
        if (config.getCaCertificatePath() != null && !config.getCaCertificatePath().isEmpty()) {
            SSLContext sslContext = this.getSslContext(config.getCaCertificatePath());
            httpConfig.withSSLSocketFactory(sslContext.getSocketFactory());
        } else {
            httpConfig.withIgnoreSSLVerification(true);
        }
        httpConfig.withConnectionPool(new ConnectionPool(config.getConnectionPoolSize().intValue(), (long)config.getConnectionPoolKeepAliveDuration().intValue(), TimeUnit.MINUTES));
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(config.getDispatcherMaxRequests().intValue());
        dispatcher.setMaxRequestsPerHost(config.getDispatcherMaxRequestsPerHost().intValue());
        httpConfig.setDispatcher(dispatcher);
        httpConfig.setConnectionTimeout(config.getConnectionTimeout().intValue());
        httpConfig.setReadTimeout(config.getReadTimeout().intValue());
        if (config.getExecutorThreadPoolSize() != 0) {
            httpConfig.setExecutorService(Executors.newFixedThreadPool(config.getExecutorThreadPoolSize()));
        }
        return httpConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SSLContext getSslContext(String truststorePath) {
        try (InputStream is = Files.newInputStream(Paths.get(truststorePath, new String[0]), new OpenOption[0]);){
            SSLContext sc = SSLContext.getInstance("TLSv1.2");
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(null);
            keystore.setCertificateEntry("ca-certificate", cf.generateCertificate(is));
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init(keystore);
            SecureRandom secureRandom = SecureRandom.getInstanceStrong();
            sc.init(null, factory.getTrustManagers(), secureRandom);
            SSLContext sSLContext = sc;
            return sSLContext;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new SdkException((Throwable)e);
        }
    }

    public Boolean isAsyncClient() {
        return this.isAsyncClient;
    }

    public KvsAsyncClient getKvsAsyncClient() {
        return this.kvsAsyncClient;
    }

    public KvsClient getKvsClient() {
        return this.kvsClient;
    }

    public String getEndpointName() {
        return this.endpoint.getName();
    }

    public Integer getEndPointWeight() {
        return this.endpoint.getWeight();
    }

    public Boolean isUsable() {
        return this.isUsable.get();
    }

    public void setIsUsable(Boolean isUsable) {
        this.isUsable.set(isUsable);
    }

    public Credential getAksk() {
        return this.credential;
    }
}

