/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.kvs.v1;

import com.huaweicloud.sdk.core.exception.ExceptionHandler;
import com.huaweicloud.sdk.core.exception.SdkErrorMessage;
import com.huaweicloud.sdk.core.exception.ServiceResponseException;
import com.huaweicloud.sdk.core.http.HttpRequest;
import com.huaweicloud.sdk.core.http.HttpResponse;
import com.mongodb.MongoClient;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.bson.BsonBinaryReader;
import org.bson.BsonReader;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;

public class KvsExceptionHandler
implements ExceptionHandler {
    public void handleException(HttpRequest httpRequest, HttpResponse httpResponse) {
        if (httpResponse.getStatusCode() >= 400) {
            throw ServiceResponseException.mapException((int)httpResponse.getStatusCode(), (SdkErrorMessage)this.parseErrorMessage(httpResponse.getBodyAsBytes(), httpResponse));
        }
    }

    private SdkErrorMessage parseErrorMessage(byte[] buf, HttpResponse httpResponse) {
        if (buf == null) {
            return null;
        }
        BsonBinaryReader reader = new BsonBinaryReader(ByteBuffer.wrap(buf, 0, buf.length));
        PojoCodecProvider pojoCodecProvider = PojoCodecProvider.builder().automatic(true).build();
        CodecRegistry codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClient.getDefaultCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{pojoCodecProvider})});
        SdkErrorMessage sdkErrorMessage = (SdkErrorMessage)this.decodeBody(codecRegistry, (BsonReader)reader);
        if (Objects.isNull(sdkErrorMessage.getRequestId()) && Objects.nonNull(httpResponse.getHeader("X-Request-Id"))) {
            sdkErrorMessage.setRequestId(httpResponse.getHeader("X-Request-Id"));
        }
        return sdkErrorMessage;
    }

    protected Object decodeBody(CodecRegistry codecRegistry, BsonReader reader) {
        return codecRegistry.get(SdkErrorMessage.class).decode(reader, DecoderContext.builder().build());
    }
}

