/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.kvs.v1;

import com.huaweicloud.sdk.core.auth.BasicCredentials;
import com.huaweicloud.sdk.core.http.HttpClient;
import com.huaweicloud.sdk.core.http.HttpRequest;
import java.util.function.Function;

public class KvsCredentials
extends BasicCredentials {
    private String projectId;
    private boolean enableBodySignature = true;

    public KvsCredentials withProjectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    public KvsCredentials withEnableBodySignature(Boolean useBodySignature) {
        this.enableBodySignature = useBodySignature;
        return this;
    }

    public void setEnableBodySignature(Boolean enableBodySignature) {
        this.enableBodySignature = enableBodySignature;
    }

    public Boolean isEnableBodySignature() {
        return this.enableBodySignature;
    }

    public HttpRequest syncProcessAuthRequest(HttpRequest httpRequest, HttpClient httpClient) {
        if (!this.enableBodySignature) {
            httpRequest = httpRequest.builder().addHeader("X-Sdk-Content-Sha256", "UNSIGNED-PAYLOAD").build();
        }
        return super.syncProcessAuthRequest(httpRequest, httpClient);
    }

    public KvsCredentials withAk(String ak) {
        this.setAk(ak);
        return this;
    }

    public KvsCredentials withSk(String sk) {
        this.setSk(sk);
        return this;
    }

    public KvsCredentials withSecurityToken(String securityToken) {
        this.setSecurityToken(securityToken);
        return this;
    }

    public KvsCredentials withIdpId(String idpId) {
        this.setIdpId(idpId);
        return this;
    }

    public KvsCredentials withIdTokenFile(String idTokenFile) {
        this.setIdTokenFile(idTokenFile);
        return this;
    }

    public KvsCredentials withIamEndpoint(String iamEndpoint) {
        this.setIamEndpoint(iamEndpoint);
        return this;
    }

    public KvsCredentials withDerivedPredicate(Function<HttpRequest, Boolean> derivedPredicate) {
        this.setDerivedPredicate(derivedPredicate);
        return this;
    }

    public KvsCredentials deepClone() {
        KvsCredentials credentials = new KvsCredentials().withProjectId(this.projectId).withAk(this.getAk()).withSk(this.getSk()).withIdpId(this.getIdpId()).withIdTokenFile(this.getIdTokenFile()).withDerivedPredicate((Function<HttpRequest, Boolean>)this.getDerivedPredicate()).withIamEndpoint(this.getIamEndpoint()).withSecurityToken(this.getSecurityToken());
        credentials.processDerivedAuthParams(this.derivedAuthServiceName, this.regionId);
        return credentials;
    }
}

