/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.kvs.v1;

import com.huaweicloud.sdk.core.exception.ConnectionException;
import com.huaweicloud.sdk.core.exception.RequestTimeoutException;
import com.huaweicloud.sdk.kvs.v1.ManagedKvsClient;
import com.huaweicloud.sdk.kvs.v1.model.CheckHealthRequest;
import com.huaweicloud.sdk.kvs.v1.model.CheckHealthRequestBody;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KvsClientHeartbeatKeeper {
    private static final Logger LOG = LoggerFactory.getLogger(KvsClientHeartbeatKeeper.class);
    private final ConcurrentHashMap<Integer, ManagedKvsClient> kvsClientMap;
    private final ThreadPoolExecutor healthCheckThreadPool;
    private final Timer heartbeatTimer;

    public KvsClientHeartbeatKeeper(ConcurrentHashMap<Integer, ManagedKvsClient> kvsClientMap, Integer heartBeatCheckIntervalMs, Integer heartBeatCheckThreadPoolSize) {
        this.kvsClientMap = kvsClientMap;
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(heartBeatCheckThreadPoolSize * 100);
        this.healthCheckThreadPool = new ThreadPoolExecutor(heartBeatCheckThreadPoolSize, heartBeatCheckThreadPoolSize, 0L, TimeUnit.MILLISECONDS, queue, Executors.defaultThreadFactory(), new ThreadPoolExecutor.DiscardPolicy());
        this.heartbeatTimer = new Timer("heartbeatKeeper");
        this.heartbeatTimer.schedule((TimerTask)new HeartbeatKeeperTask(), heartBeatCheckIntervalMs.intValue(), (long)heartBeatCheckIntervalMs.intValue());
    }

    public void close() {
        this.healthCheckThreadPool.shutdown();
        this.heartbeatTimer.cancel();
        this.heartbeatTimer.purge();
        LOG.info("KvsClientHeartbeatKeeper is closed !");
    }

    private static class HeathCheckTask
    implements Runnable {
        ManagedKvsClient client;

        public HeathCheckTask(ManagedKvsClient client) {
            this.client = client;
        }

        @Override
        public void run() {
            boolean isUsable = true;
            try {
                CheckHealthRequestBody body = new CheckHealthRequestBody().withVersion(1);
                if (!this.client.isAsyncClient().booleanValue()) {
                    this.client.getKvsClient().checkHealth(new CheckHealthRequest().withBody(body));
                } else {
                    this.client.getKvsAsyncClient().checkHealthAsync(new CheckHealthRequest().withBody(body)).get();
                }
            }
            catch (ConnectionException | RequestTimeoutException e) {
                LOG.warn("Network channel throw Exception, set " + this.client.getEndpointName() + " client to unusable, errorInfo: " + e, e);
                isUsable = false;
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("get healthCheckResponse from future of AsyncClient failed !", (Throwable)e);
            }
            this.client.setIsUsable(isUsable);
        }
    }

    private class HeartbeatKeeperTask
    extends TimerTask {
        private HeartbeatKeeperTask() {
        }

        @Override
        public void run() {
            KvsClientHeartbeatKeeper.this.kvsClientMap.forEach((sortNum, managedKvsClient) -> KvsClientHeartbeatKeeper.this.healthCheckThreadPool.execute(new HeathCheckTask((ManagedKvsClient)managedKvsClient)));
        }
    }
}

