/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.kvs.v1;

import com.huaweicloud.sdk.core.ClientBuilder;
import com.huaweicloud.sdk.core.HcClient;
import com.huaweicloud.sdk.core.invoker.AsyncInvoker;
import com.huaweicloud.sdk.kvs.v1.IKvsAsyncClient;
import com.huaweicloud.sdk.kvs.v1.KvsExceptionHandler;
import com.huaweicloud.sdk.kvs.v1.KvsMeta;
import com.huaweicloud.sdk.kvs.v1.model.BatchWriteKvRequest;
import com.huaweicloud.sdk.kvs.v1.model.BatchWriteKvResponse;
import com.huaweicloud.sdk.kvs.v1.model.CheckHealthRequest;
import com.huaweicloud.sdk.kvs.v1.model.CheckHealthResponse;
import com.huaweicloud.sdk.kvs.v1.model.CreateTableRequest;
import com.huaweicloud.sdk.kvs.v1.model.CreateTableResponse;
import com.huaweicloud.sdk.kvs.v1.model.DeleteKvRequest;
import com.huaweicloud.sdk.kvs.v1.model.DeleteKvResponse;
import com.huaweicloud.sdk.kvs.v1.model.DescribeTableRequest;
import com.huaweicloud.sdk.kvs.v1.model.DescribeTableResponse;
import com.huaweicloud.sdk.kvs.v1.model.GetKvRequest;
import com.huaweicloud.sdk.kvs.v1.model.GetKvResponse;
import com.huaweicloud.sdk.kvs.v1.model.ListStoreRequest;
import com.huaweicloud.sdk.kvs.v1.model.ListStoreResponse;
import com.huaweicloud.sdk.kvs.v1.model.ListTableRequest;
import com.huaweicloud.sdk.kvs.v1.model.ListTableResponse;
import com.huaweicloud.sdk.kvs.v1.model.PutKvRequest;
import com.huaweicloud.sdk.kvs.v1.model.PutKvResponse;
import com.huaweicloud.sdk.kvs.v1.model.ScanKvRequest;
import com.huaweicloud.sdk.kvs.v1.model.ScanKvResponse;
import com.huaweicloud.sdk.kvs.v1.model.ScanSkeyKvRequest;
import com.huaweicloud.sdk.kvs.v1.model.ScanSkeyKvResponse;
import com.huaweicloud.sdk.kvs.v1.model.UpdateKvRequest;
import com.huaweicloud.sdk.kvs.v1.model.UpdateKvResponse;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CompletableFuture;

public class KvsAsyncClient
implements IKvsAsyncClient {
    protected HcClient hcClient;

    public KvsAsyncClient(HcClient hcClient) {
        this.hcClient = hcClient;
    }

    public static ClientBuilder<KvsAsyncClient> newBuilder() {
        ClientBuilder clientBuilder = new ClientBuilder(KvsAsyncClient::new, "BasicCredentials,KvsCredentials");
        try {
            Class<?> exceptionHandler = Class.forName("com.huaweicloud.sdk.core.exception.ExceptionHandler");
            clientBuilder.getClass().getMethod("withExceptionHandler", exceptionHandler).invoke((Object)clientBuilder, new KvsExceptionHandler());
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return clientBuilder;
    }

    @Override
    public CompletableFuture<CreateTableResponse> createTableAsync(CreateTableRequest request) {
        return this.hcClient.asyncInvokeHttp((Object)request, KvsMeta.createTable);
    }

    @Override
    public AsyncInvoker<CreateTableRequest, CreateTableResponse> createTableAsyncInvoker(CreateTableRequest request) {
        return new AsyncInvoker((Object)request, KvsMeta.createTable, this.hcClient);
    }

    @Override
    public CompletableFuture<DescribeTableResponse> describeTableAsync(DescribeTableRequest request) {
        return this.hcClient.asyncInvokeHttp((Object)request, KvsMeta.describeTable);
    }

    @Override
    public AsyncInvoker<DescribeTableRequest, DescribeTableResponse> describeTableAsyncInvoker(DescribeTableRequest request) {
        return new AsyncInvoker((Object)request, KvsMeta.describeTable, this.hcClient);
    }

    @Override
    public CompletableFuture<ListStoreResponse> listStoreAsync(ListStoreRequest request) {
        return this.hcClient.asyncInvokeHttp((Object)request, KvsMeta.listStore);
    }

    @Override
    public AsyncInvoker<ListStoreRequest, ListStoreResponse> listStoreAsyncInvoker(ListStoreRequest request) {
        return new AsyncInvoker((Object)request, KvsMeta.listStore, this.hcClient);
    }

    @Override
    public CompletableFuture<ListTableResponse> listTableAsync(ListTableRequest request) {
        return this.hcClient.asyncInvokeHttp((Object)request, KvsMeta.listTable);
    }

    @Override
    public AsyncInvoker<ListTableRequest, ListTableResponse> listTableAsyncInvoker(ListTableRequest request) {
        return new AsyncInvoker((Object)request, KvsMeta.listTable, this.hcClient);
    }

    @Override
    public CompletableFuture<CheckHealthResponse> checkHealthAsync(CheckHealthRequest request) {
        return this.hcClient.asyncInvokeHttp((Object)request, KvsMeta.checkHealth);
    }

    @Override
    public AsyncInvoker<CheckHealthRequest, CheckHealthResponse> checkHealthAsyncInvoker(CheckHealthRequest request) {
        return new AsyncInvoker((Object)request, KvsMeta.checkHealth, this.hcClient);
    }

    @Override
    public CompletableFuture<BatchWriteKvResponse> batchWriteKvAsync(BatchWriteKvRequest request) {
        return this.hcClient.asyncInvokeHttp((Object)request, KvsMeta.batchWriteKv);
    }

    @Override
    public AsyncInvoker<BatchWriteKvRequest, BatchWriteKvResponse> batchWriteKvAsyncInvoker(BatchWriteKvRequest request) {
        return new AsyncInvoker((Object)request, KvsMeta.batchWriteKv, this.hcClient);
    }

    @Override
    public CompletableFuture<DeleteKvResponse> deleteKvAsync(DeleteKvRequest request) {
        return this.hcClient.asyncInvokeHttp((Object)request, KvsMeta.deleteKv);
    }

    @Override
    public AsyncInvoker<DeleteKvRequest, DeleteKvResponse> deleteKvAsyncInvoker(DeleteKvRequest request) {
        return new AsyncInvoker((Object)request, KvsMeta.deleteKv, this.hcClient);
    }

    @Override
    public CompletableFuture<GetKvResponse> getKvAsync(GetKvRequest request) {
        return this.hcClient.asyncInvokeHttp((Object)request, KvsMeta.getKv);
    }

    @Override
    public AsyncInvoker<GetKvRequest, GetKvResponse> getKvAsyncInvoker(GetKvRequest request) {
        return new AsyncInvoker((Object)request, KvsMeta.getKv, this.hcClient);
    }

    @Override
    public CompletableFuture<PutKvResponse> putKvAsync(PutKvRequest request) {
        return this.hcClient.asyncInvokeHttp((Object)request, KvsMeta.putKv);
    }

    @Override
    public AsyncInvoker<PutKvRequest, PutKvResponse> putKvAsyncInvoker(PutKvRequest request) {
        return new AsyncInvoker((Object)request, KvsMeta.putKv, this.hcClient);
    }

    @Override
    public CompletableFuture<ScanKvResponse> scanKvAsync(ScanKvRequest request) {
        return this.hcClient.asyncInvokeHttp((Object)request, KvsMeta.scanKv);
    }

    @Override
    public AsyncInvoker<ScanKvRequest, ScanKvResponse> scanKvAsyncInvoker(ScanKvRequest request) {
        return new AsyncInvoker((Object)request, KvsMeta.scanKv, this.hcClient);
    }

    @Override
    public CompletableFuture<ScanSkeyKvResponse> scanSkeyKvAsync(ScanSkeyKvRequest request) {
        return this.hcClient.asyncInvokeHttp((Object)request, KvsMeta.scanSkeyKv);
    }

    @Override
    public AsyncInvoker<ScanSkeyKvRequest, ScanSkeyKvResponse> scanSkeyKvAsyncInvoker(ScanSkeyKvRequest request) {
        return new AsyncInvoker((Object)request, KvsMeta.scanSkeyKv, this.hcClient);
    }

    @Override
    public CompletableFuture<UpdateKvResponse> updateKvAsync(UpdateKvRequest request) {
        return this.hcClient.asyncInvokeHttp((Object)request, KvsMeta.updateKv);
    }

    @Override
    public AsyncInvoker<UpdateKvRequest, UpdateKvResponse> updateKvAsyncInvoker(UpdateKvRequest request) {
        return new AsyncInvoker((Object)request, KvsMeta.updateKv, this.hcClient);
    }
}

