/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.kvs.v1;

import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.kvs.v1.ManagedKvsClient;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMultiChannelKvsClient {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMultiChannelKvsClient.class);
    protected final AtomicInteger tokenNum = new AtomicInteger(1);
    protected final AtomicInteger weightCount = new AtomicInteger(0);
    protected final ConcurrentHashMap<Integer, ManagedKvsClient> kvsClientMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<Long, ConcurrentHashMap<Integer, ManagedKvsClient>> oldKvsClientMaps = new ConcurrentHashMap();
    private final ReentrantLock pollingLock = new ReentrantLock();
    private final Random random = new Random();
    public static final int BASE_OF_EXPONENT = 2;

    protected ManagedKvsClient getKvsClientByPolling(Integer retryCount) {
        if (retryCount > 0) {
            try {
                Thread.sleep((long)this.random.nextInt((int)Math.pow(2.0, retryCount.intValue())) * 1000L);
            }
            catch (InterruptedException e) {
                LOG.warn("Thread.sleep is interrupted", (Throwable)e);
            }
        }
        return this.getKvsClientByPolling();
    }

    protected ManagedKvsClient getKvsClientByPolling() {
        int selectCount = 0;
        this.pollingLock.lock();
        do {
            if (selectCount > this.kvsClientMap.size()) {
                LOG.error("all web channel of kvs clients are unusable! please wait and retry");
                throw new SdkException("all web channel of kvs clients are unusable! please wait and retry");
            }
            ++selectCount;
            ManagedKvsClient kvsClient = this.kvsClientMap.get(this.tokenNum.get());
            if (kvsClient.isUsable().booleanValue() && this.weightCount.get() < kvsClient.getEndPointWeight()) {
                this.weightCount.getAndIncrement();
                continue;
            }
            if (this.tokenNum.get() >= this.kvsClientMap.size()) {
                this.tokenNum.getAndSet(1);
                this.weightCount.getAndSet(1);
                continue;
            }
            this.tokenNum.getAndIncrement();
            this.weightCount.getAndSet(1);
        } while (!this.kvsClientMap.get(this.tokenNum.get()).isUsable().booleanValue());
        int kvsClientNum = this.tokenNum.get();
        this.pollingLock.unlock();
        return this.kvsClientMap.get(kvsClientNum);
    }
}

