/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.imagesearch.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.imagesearch.v2.model.RangeParam;
import com.huaweicloud.sdk.imagesearch.v2.model.SearchAfterParam;
import com.huaweicloud.sdk.imagesearch.v2.model.SearchOptionalParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class SearchParam {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="search_type")
    private SearchTypeEnum searchType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="limit")
    private Integer limit;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="offset")
    private Integer offset;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="last_item")
    private SearchAfterParam lastItem;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="min_score")
    private Double minScore;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="custom_tags")
    private Map<String, List<String>> customTags = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="custom_num_tags")
    private Map<String, RangeParam> customNumTags = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="image_base64")
    private String imageBase64;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="image_url")
    private String imageUrl;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="keywords")
    private List<String> keywords = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="text")
    private String text;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="optional_params")
    private SearchOptionalParam optionalParams;

    public SearchParam withSearchType(SearchTypeEnum searchType) {
        this.searchType = searchType;
        return this;
    }

    public SearchTypeEnum getSearchType() {
        return this.searchType;
    }

    public void setSearchType(SearchTypeEnum searchType) {
        this.searchType = searchType;
    }

    public SearchParam withLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public SearchParam withOffset(Integer offset) {
        this.offset = offset;
        return this;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public SearchParam withLastItem(SearchAfterParam lastItem) {
        this.lastItem = lastItem;
        return this;
    }

    public SearchParam withLastItem(Consumer<SearchAfterParam> lastItemSetter) {
        if (this.lastItem == null) {
            this.lastItem = new SearchAfterParam();
            lastItemSetter.accept(this.lastItem);
        }
        return this;
    }

    public SearchAfterParam getLastItem() {
        return this.lastItem;
    }

    public void setLastItem(SearchAfterParam lastItem) {
        this.lastItem = lastItem;
    }

    public SearchParam withMinScore(Double minScore) {
        this.minScore = minScore;
        return this;
    }

    public Double getMinScore() {
        return this.minScore;
    }

    public void setMinScore(Double minScore) {
        this.minScore = minScore;
    }

    public SearchParam withCustomTags(Map<String, List<String>> customTags) {
        this.customTags = customTags;
        return this;
    }

    public SearchParam putCustomTagsItem(String key, List<String> customTagsItem) {
        if (this.customTags == null) {
            this.customTags = new HashMap<String, List<String>>();
        }
        this.customTags.put(key, customTagsItem);
        return this;
    }

    public SearchParam withCustomTags(Consumer<Map<String, List<String>>> customTagsSetter) {
        if (this.customTags == null) {
            this.customTags = new HashMap<String, List<String>>();
        }
        customTagsSetter.accept(this.customTags);
        return this;
    }

    public Map<String, List<String>> getCustomTags() {
        return this.customTags;
    }

    public void setCustomTags(Map<String, List<String>> customTags) {
        this.customTags = customTags;
    }

    public SearchParam withCustomNumTags(Map<String, RangeParam> customNumTags) {
        this.customNumTags = customNumTags;
        return this;
    }

    public SearchParam putCustomNumTagsItem(String key, RangeParam customNumTagsItem) {
        if (this.customNumTags == null) {
            this.customNumTags = new HashMap<String, RangeParam>();
        }
        this.customNumTags.put(key, customNumTagsItem);
        return this;
    }

    public SearchParam withCustomNumTags(Consumer<Map<String, RangeParam>> customNumTagsSetter) {
        if (this.customNumTags == null) {
            this.customNumTags = new HashMap<String, RangeParam>();
        }
        customNumTagsSetter.accept(this.customNumTags);
        return this;
    }

    public Map<String, RangeParam> getCustomNumTags() {
        return this.customNumTags;
    }

    public void setCustomNumTags(Map<String, RangeParam> customNumTags) {
        this.customNumTags = customNumTags;
    }

    public SearchParam withImageBase64(String imageBase64) {
        this.imageBase64 = imageBase64;
        return this;
    }

    public String getImageBase64() {
        return this.imageBase64;
    }

    public void setImageBase64(String imageBase64) {
        this.imageBase64 = imageBase64;
    }

    public SearchParam withImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
        return this;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public SearchParam withKeywords(List<String> keywords) {
        this.keywords = keywords;
        return this;
    }

    public SearchParam addKeywordsItem(String keywordsItem) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.add(keywordsItem);
        return this;
    }

    public SearchParam withKeywords(Consumer<List<String>> keywordsSetter) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        keywordsSetter.accept(this.keywords);
        return this;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public SearchParam withText(String text) {
        this.text = text;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public SearchParam withOptionalParams(SearchOptionalParam optionalParams) {
        this.optionalParams = optionalParams;
        return this;
    }

    public SearchParam withOptionalParams(Consumer<SearchOptionalParam> optionalParamsSetter) {
        if (this.optionalParams == null) {
            this.optionalParams = new SearchOptionalParam();
            optionalParamsSetter.accept(this.optionalParams);
        }
        return this;
    }

    public SearchOptionalParam getOptionalParams() {
        return this.optionalParams;
    }

    public void setOptionalParams(SearchOptionalParam optionalParams) {
        this.optionalParams = optionalParams;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SearchParam that = (SearchParam)obj;
        return Objects.equals(this.searchType, that.searchType) && Objects.equals(this.limit, that.limit) && Objects.equals(this.offset, that.offset) && Objects.equals(this.lastItem, that.lastItem) && Objects.equals(this.minScore, that.minScore) && Objects.equals(this.customTags, that.customTags) && Objects.equals(this.customNumTags, that.customNumTags) && Objects.equals(this.imageBase64, that.imageBase64) && Objects.equals(this.imageUrl, that.imageUrl) && Objects.equals(this.keywords, that.keywords) && Objects.equals(this.text, that.text) && Objects.equals(this.optionalParams, that.optionalParams);
    }

    public int hashCode() {
        return Objects.hash(this.searchType, this.limit, this.offset, this.lastItem, this.minScore, this.customTags, this.customNumTags, this.imageBase64, this.imageUrl, this.keywords, this.text, this.optionalParams);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchParam {\n");
        sb.append("    searchType: ").append(this.toIndentedString(this.searchType)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    offset: ").append(this.toIndentedString(this.offset)).append("\n");
        sb.append("    lastItem: ").append(this.toIndentedString(this.lastItem)).append("\n");
        sb.append("    minScore: ").append(this.toIndentedString(this.minScore)).append("\n");
        sb.append("    customTags: ").append(this.toIndentedString(this.customTags)).append("\n");
        sb.append("    customNumTags: ").append(this.toIndentedString(this.customNumTags)).append("\n");
        sb.append("    imageBase64: ").append(this.toIndentedString(this.imageBase64)).append("\n");
        sb.append("    imageUrl: ").append(this.toIndentedString(this.imageUrl)).append("\n");
        sb.append("    keywords: ").append(this.toIndentedString(this.keywords)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    optionalParams: ").append(this.toIndentedString(this.optionalParams)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class SearchTypeEnum {
        public static final SearchTypeEnum IMAGE = new SearchTypeEnum("IMAGE");
        public static final SearchTypeEnum KEYWORD = new SearchTypeEnum("KEYWORD");
        public static final SearchTypeEnum TEXT = new SearchTypeEnum("TEXT");
        public static final SearchTypeEnum CATEGORY = new SearchTypeEnum("CATEGORY");
        private static final Map<String, SearchTypeEnum> STATIC_FIELDS = SearchTypeEnum.createStaticFields();
        private String value;

        private static Map<String, SearchTypeEnum> createStaticFields() {
            HashMap<String, SearchTypeEnum> map = new HashMap<String, SearchTypeEnum>();
            map.put("IMAGE", IMAGE);
            map.put("KEYWORD", KEYWORD);
            map.put("TEXT", TEXT);
            map.put("CATEGORY", CATEGORY);
            return Collections.unmodifiableMap(map);
        }

        SearchTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SearchTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new SearchTypeEnum(value));
        }

        public static SearchTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof SearchTypeEnum) {
                return this.value.equals(((SearchTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

