/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.imagesearch.v2.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ItemSource {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="desc")
    private String desc;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="custom_tags")
    private Map<String, String> customTags = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="custom_num_tags")
    private Map<String, Double> customNumTags = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="keywords")
    private List<String> keywords = null;

    public ItemSource withDesc(String desc) {
        this.desc = desc;
        return this;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public ItemSource withCustomTags(Map<String, String> customTags) {
        this.customTags = customTags;
        return this;
    }

    public ItemSource putCustomTagsItem(String key, String customTagsItem) {
        if (this.customTags == null) {
            this.customTags = new HashMap<String, String>();
        }
        this.customTags.put(key, customTagsItem);
        return this;
    }

    public ItemSource withCustomTags(Consumer<Map<String, String>> customTagsSetter) {
        if (this.customTags == null) {
            this.customTags = new HashMap<String, String>();
        }
        customTagsSetter.accept(this.customTags);
        return this;
    }

    public Map<String, String> getCustomTags() {
        return this.customTags;
    }

    public void setCustomTags(Map<String, String> customTags) {
        this.customTags = customTags;
    }

    public ItemSource withCustomNumTags(Map<String, Double> customNumTags) {
        this.customNumTags = customNumTags;
        return this;
    }

    public ItemSource putCustomNumTagsItem(String key, Double customNumTagsItem) {
        if (this.customNumTags == null) {
            this.customNumTags = new HashMap<String, Double>();
        }
        this.customNumTags.put(key, customNumTagsItem);
        return this;
    }

    public ItemSource withCustomNumTags(Consumer<Map<String, Double>> customNumTagsSetter) {
        if (this.customNumTags == null) {
            this.customNumTags = new HashMap<String, Double>();
        }
        customNumTagsSetter.accept(this.customNumTags);
        return this;
    }

    public Map<String, Double> getCustomNumTags() {
        return this.customNumTags;
    }

    public void setCustomNumTags(Map<String, Double> customNumTags) {
        this.customNumTags = customNumTags;
    }

    public ItemSource withKeywords(List<String> keywords) {
        this.keywords = keywords;
        return this;
    }

    public ItemSource addKeywordsItem(String keywordsItem) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.add(keywordsItem);
        return this;
    }

    public ItemSource withKeywords(Consumer<List<String>> keywordsSetter) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        keywordsSetter.accept(this.keywords);
        return this;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ItemSource that = (ItemSource)obj;
        return Objects.equals(this.desc, that.desc) && Objects.equals(this.customTags, that.customTags) && Objects.equals(this.customNumTags, that.customNumTags) && Objects.equals(this.keywords, that.keywords);
    }

    public int hashCode() {
        return Objects.hash(this.desc, this.customTags, this.customNumTags, this.keywords);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemSource {\n");
        sb.append("    desc: ").append(this.toIndentedString(this.desc)).append("\n");
        sb.append("    customTags: ").append(this.toIndentedString(this.customTags)).append("\n");
        sb.append("    customNumTags: ").append(this.toIndentedString(this.customNumTags)).append("\n");
        sb.append("    keywords: ").append(this.toIndentedString(this.keywords)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

