/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.imagesearch.v2;

import com.huaweicloud.sdk.core.ClientBuilder;
import com.huaweicloud.sdk.core.HcClient;
import com.huaweicloud.sdk.core.invoker.AsyncInvoker;
import com.huaweicloud.sdk.imagesearch.v2.ImageSearchMeta;
import com.huaweicloud.sdk.imagesearch.v2.model.RunAddDataRequest;
import com.huaweicloud.sdk.imagesearch.v2.model.RunAddDataResponse;
import com.huaweicloud.sdk.imagesearch.v2.model.RunCheckDataRequest;
import com.huaweicloud.sdk.imagesearch.v2.model.RunCheckDataResponse;
import com.huaweicloud.sdk.imagesearch.v2.model.RunDeleteDataRequest;
import com.huaweicloud.sdk.imagesearch.v2.model.RunDeleteDataResponse;
import com.huaweicloud.sdk.imagesearch.v2.model.RunSearchRequest;
import com.huaweicloud.sdk.imagesearch.v2.model.RunSearchResponse;
import com.huaweicloud.sdk.imagesearch.v2.model.RunUpdateDataRequest;
import com.huaweicloud.sdk.imagesearch.v2.model.RunUpdateDataResponse;
import java.util.concurrent.CompletableFuture;

public class ImageSearchAsyncClient {
    protected HcClient hcClient;

    public ImageSearchAsyncClient(HcClient hcClient) {
        this.hcClient = hcClient;
    }

    public static ClientBuilder<ImageSearchAsyncClient> newBuilder() {
        ClientBuilder clientBuilder = new ClientBuilder(ImageSearchAsyncClient::new);
        return clientBuilder;
    }

    public CompletableFuture<RunAddDataResponse> runAddDataAsync(RunAddDataRequest request) {
        return this.hcClient.asyncInvokeHttp((Object)request, ImageSearchMeta.runAddData);
    }

    public AsyncInvoker<RunAddDataRequest, RunAddDataResponse> runAddDataAsyncInvoker(RunAddDataRequest request) {
        return new AsyncInvoker((Object)request, ImageSearchMeta.runAddData, this.hcClient);
    }

    public CompletableFuture<RunCheckDataResponse> runCheckDataAsync(RunCheckDataRequest request) {
        return this.hcClient.asyncInvokeHttp((Object)request, ImageSearchMeta.runCheckData);
    }

    public AsyncInvoker<RunCheckDataRequest, RunCheckDataResponse> runCheckDataAsyncInvoker(RunCheckDataRequest request) {
        return new AsyncInvoker((Object)request, ImageSearchMeta.runCheckData, this.hcClient);
    }

    public CompletableFuture<RunDeleteDataResponse> runDeleteDataAsync(RunDeleteDataRequest request) {
        return this.hcClient.asyncInvokeHttp((Object)request, ImageSearchMeta.runDeleteData);
    }

    public AsyncInvoker<RunDeleteDataRequest, RunDeleteDataResponse> runDeleteDataAsyncInvoker(RunDeleteDataRequest request) {
        return new AsyncInvoker((Object)request, ImageSearchMeta.runDeleteData, this.hcClient);
    }

    public CompletableFuture<RunSearchResponse> runSearchAsync(RunSearchRequest request) {
        return this.hcClient.asyncInvokeHttp((Object)request, ImageSearchMeta.runSearch);
    }

    public AsyncInvoker<RunSearchRequest, RunSearchResponse> runSearchAsyncInvoker(RunSearchRequest request) {
        return new AsyncInvoker((Object)request, ImageSearchMeta.runSearch, this.hcClient);
    }

    public CompletableFuture<RunUpdateDataResponse> runUpdateDataAsync(RunUpdateDataRequest request) {
        return this.hcClient.asyncInvokeHttp((Object)request, ImageSearchMeta.runUpdateData);
    }

    public AsyncInvoker<RunUpdateDataRequest, RunUpdateDataResponse> runUpdateDataAsyncInvoker(RunUpdateDataRequest request) {
        return new AsyncInvoker((Object)request, ImageSearchMeta.runUpdateData, this.hcClient);
    }
}

