/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.iamaccessanalyzer.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ResourceType {
    public static final ResourceType IAM_AGENCY = new ResourceType("iam:agency");
    public static final ResourceType IAM_USER = new ResourceType("iam:user");
    public static final ResourceType KMS_CMK = new ResourceType("kms:cmk");
    public static final ResourceType OBS_BUCKET = new ResourceType("obs:bucket");
    private static final Map<String, ResourceType> STATIC_FIELDS = ResourceType.createStaticFields();
    private String value;

    private static Map<String, ResourceType> createStaticFields() {
        HashMap<String, ResourceType> map = new HashMap<String, ResourceType>();
        map.put("iam:agency", IAM_AGENCY);
        map.put("iam:user", IAM_USER);
        map.put("kms:cmk", KMS_CMK);
        map.put("obs:bucket", OBS_BUCKET);
        return Collections.unmodifiableMap(map);
    }

    ResourceType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static ResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ResourceType(value));
    }

    public static ResourceType valueOf(String value) {
        if (value == null) {
            return null;
        }
        return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResourceType) {
            return this.value.equals(((ResourceType)obj).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

