/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.iamaccessanalyzer.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class PolicyType {
    public static final PolicyType IDENTITY_POLICY = new PolicyType("identity_policy");
    public static final PolicyType RESOURCE_POLICY = new PolicyType("resource_policy");
    public static final PolicyType SERVICE_CONTROL_POLICY = new PolicyType("service_control_policy");
    private static final Map<String, PolicyType> STATIC_FIELDS = PolicyType.createStaticFields();
    private String value;

    private static Map<String, PolicyType> createStaticFields() {
        HashMap<String, PolicyType> map = new HashMap<String, PolicyType>();
        map.put("identity_policy", IDENTITY_POLICY);
        map.put("resource_policy", RESOURCE_POLICY);
        map.put("service_control_policy", SERVICE_CONTROL_POLICY);
        return Collections.unmodifiableMap(map);
    }

    PolicyType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static PolicyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new PolicyType(value));
    }

    public static PolicyType valueOf(String value) {
        if (value == null) {
            return null;
        }
        return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
    }

    public boolean equals(Object obj) {
        if (obj instanceof PolicyType) {
            return this.value.equals(((PolicyType)obj).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

