/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.iamaccessanalyzer.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.iamaccessanalyzer.v1.model.Criterion;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class FindingFilter {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="criterion")
    private Criterion criterion;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="key")
    private KeyEnum key;

    public FindingFilter withCriterion(Criterion criterion) {
        this.criterion = criterion;
        return this;
    }

    public FindingFilter withCriterion(Consumer<Criterion> criterionSetter) {
        if (this.criterion == null) {
            this.criterion = new Criterion();
            criterionSetter.accept(this.criterion);
        }
        return this;
    }

    public Criterion getCriterion() {
        return this.criterion;
    }

    public void setCriterion(Criterion criterion) {
        this.criterion = criterion;
    }

    public FindingFilter withKey(KeyEnum key) {
        this.key = key;
        return this;
    }

    public KeyEnum getKey() {
        return this.key;
    }

    public void setKey(KeyEnum key) {
        this.key = key;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FindingFilter that = (FindingFilter)obj;
        return Objects.equals(this.criterion, that.criterion) && Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.criterion, this.key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FindingFilter {\n");
        sb.append("    criterion: ").append(this.toIndentedString(this.criterion)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class KeyEnum {
        public static final KeyEnum RESOURCE = new KeyEnum("resource");
        public static final KeyEnum RESOURCE_TYPE = new KeyEnum("resource_type");
        public static final KeyEnum RESOURCE_OWNER_ACCOUNT = new KeyEnum("resource_owner_account");
        public static final KeyEnum IS_PUBLIC = new KeyEnum("is_public");
        public static final KeyEnum ID = new KeyEnum("id");
        public static final KeyEnum STATUS = new KeyEnum("status");
        public static final KeyEnum PRINCIPAL_TYPE = new KeyEnum("principal_type");
        public static final KeyEnum PRINCIPAL_IDENTIFIER = new KeyEnum("principal_identifier");
        public static final KeyEnum CHANGE_TYPE = new KeyEnum("change_type");
        public static final KeyEnum EXISTING_FINDING_ID = new KeyEnum("existing_finding_id");
        public static final KeyEnum EXISTING_FINDING_STATUS = new KeyEnum("existing_finding_status");
        public static final KeyEnum CONDITION_G_PRINCIPALURN = new KeyEnum("condition.g:PrincipalUrn");
        public static final KeyEnum CONDITION_G_PRINCIPALID = new KeyEnum("condition.g:PrincipalId");
        public static final KeyEnum CONDITION_G_PRINCIPALACCOUNT = new KeyEnum("condition.g:PrincipalAccount");
        public static final KeyEnum CONDITION_G_PRINCIPALORGID = new KeyEnum("condition.g:PrincipalOrgId");
        public static final KeyEnum CONDITION_G_PRINCIPALORGPATH = new KeyEnum("condition.g:PrincipalOrgPath");
        public static final KeyEnum CONDITION_G_PRINCIPALORGMANAGEMENTACCOUNTID = new KeyEnum("condition.g:PrincipalOrgManagementAccountId");
        public static final KeyEnum CONDITION_G_SOURCEIP = new KeyEnum("condition.g:SourceIp");
        public static final KeyEnum CONDITION_G_SOURCEVPC = new KeyEnum("condition.g:SourceVpc");
        public static final KeyEnum CONDITION_G_SOURCEVPCE = new KeyEnum("condition.g:SourceVpce");
        public static final KeyEnum FINDING_TYPE = new KeyEnum("finding_type");
        private static final Map<String, KeyEnum> STATIC_FIELDS = KeyEnum.createStaticFields();
        private String value;

        private static Map<String, KeyEnum> createStaticFields() {
            HashMap<String, KeyEnum> map = new HashMap<String, KeyEnum>();
            map.put("resource", RESOURCE);
            map.put("resource_type", RESOURCE_TYPE);
            map.put("resource_owner_account", RESOURCE_OWNER_ACCOUNT);
            map.put("is_public", IS_PUBLIC);
            map.put("id", ID);
            map.put("status", STATUS);
            map.put("principal_type", PRINCIPAL_TYPE);
            map.put("principal_identifier", PRINCIPAL_IDENTIFIER);
            map.put("change_type", CHANGE_TYPE);
            map.put("existing_finding_id", EXISTING_FINDING_ID);
            map.put("existing_finding_status", EXISTING_FINDING_STATUS);
            map.put("condition.g:PrincipalUrn", CONDITION_G_PRINCIPALURN);
            map.put("condition.g:PrincipalId", CONDITION_G_PRINCIPALID);
            map.put("condition.g:PrincipalAccount", CONDITION_G_PRINCIPALACCOUNT);
            map.put("condition.g:PrincipalOrgId", CONDITION_G_PRINCIPALORGID);
            map.put("condition.g:PrincipalOrgPath", CONDITION_G_PRINCIPALORGPATH);
            map.put("condition.g:PrincipalOrgManagementAccountId", CONDITION_G_PRINCIPALORGMANAGEMENTACCOUNTID);
            map.put("condition.g:SourceIp", CONDITION_G_SOURCEIP);
            map.put("condition.g:SourceVpc", CONDITION_G_SOURCEVPC);
            map.put("condition.g:SourceVpce", CONDITION_G_SOURCEVPCE);
            map.put("finding_type", FINDING_TYPE);
            return Collections.unmodifiableMap(map);
        }

        KeyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static KeyEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new KeyEnum(value));
        }

        public static KeyEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof KeyEnum) {
                return this.value.equals(((KeyEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

