/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.iamaccessanalyzer.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class AnalyzerType {
    public static final AnalyzerType ACCOUNT = new AnalyzerType("account");
    public static final AnalyzerType ORGANIZATION = new AnalyzerType("organization");
    public static final AnalyzerType ACCOUNT_UNUSED_ACCESS = new AnalyzerType("account_unused_access");
    public static final AnalyzerType ORGANIZATION_UNUSED_ACCESS = new AnalyzerType("organization_unused_access");
    private static final Map<String, AnalyzerType> STATIC_FIELDS = AnalyzerType.createStaticFields();
    private String value;

    private static Map<String, AnalyzerType> createStaticFields() {
        HashMap<String, AnalyzerType> map = new HashMap<String, AnalyzerType>();
        map.put("account", ACCOUNT);
        map.put("organization", ORGANIZATION);
        map.put("account_unused_access", ACCOUNT_UNUSED_ACCESS);
        map.put("organization_unused_access", ORGANIZATION_UNUSED_ACCESS);
        return Collections.unmodifiableMap(map);
    }

    AnalyzerType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static AnalyzerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new AnalyzerType(value));
    }

    public static AnalyzerType valueOf(String value) {
        if (value == null) {
            return null;
        }
        return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
    }

    public boolean equals(Object obj) {
        if (obj instanceof AnalyzerType) {
            return this.value.equals(((AnalyzerType)obj).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

