/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.iamaccessanalyzer.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.iamaccessanalyzer.v1.model.AnalyzerConfiguration;
import com.huaweicloud.sdk.iamaccessanalyzer.v1.model.AnalyzerType;
import com.huaweicloud.sdk.iamaccessanalyzer.v1.model.StatusReason;
import com.huaweicloud.sdk.iamaccessanalyzer.v1.model.Tag;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class AnalyzerSummary {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="configuration")
    private AnalyzerConfiguration _configuration;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="created_at")
    private OffsetDateTime createdAt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="id")
    private String id;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="last_analyzed_resource")
    private String lastAnalyzedResource;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="last_resource_analyzed_at")
    private OffsetDateTime lastResourceAnalyzedAt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="name")
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="organization_id")
    private String organizationId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="status")
    private StatusEnum status;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="status_reason")
    private StatusReason statusReason;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="tags")
    private List<Tag> tags = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="type")
    private AnalyzerType type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="urn")
    private String urn;

    public AnalyzerSummary withConfiguration(AnalyzerConfiguration _configuration) {
        this._configuration = _configuration;
        return this;
    }

    public AnalyzerSummary withConfiguration(Consumer<AnalyzerConfiguration> _configurationSetter) {
        if (this._configuration == null) {
            this._configuration = new AnalyzerConfiguration();
            _configurationSetter.accept(this._configuration);
        }
        return this;
    }

    public AnalyzerConfiguration getConfiguration() {
        return this._configuration;
    }

    public void setConfiguration(AnalyzerConfiguration _configuration) {
        this._configuration = _configuration;
    }

    public AnalyzerSummary withCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public AnalyzerSummary withId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AnalyzerSummary withLastAnalyzedResource(String lastAnalyzedResource) {
        this.lastAnalyzedResource = lastAnalyzedResource;
        return this;
    }

    public String getLastAnalyzedResource() {
        return this.lastAnalyzedResource;
    }

    public void setLastAnalyzedResource(String lastAnalyzedResource) {
        this.lastAnalyzedResource = lastAnalyzedResource;
    }

    public AnalyzerSummary withLastResourceAnalyzedAt(OffsetDateTime lastResourceAnalyzedAt) {
        this.lastResourceAnalyzedAt = lastResourceAnalyzedAt;
        return this;
    }

    public OffsetDateTime getLastResourceAnalyzedAt() {
        return this.lastResourceAnalyzedAt;
    }

    public void setLastResourceAnalyzedAt(OffsetDateTime lastResourceAnalyzedAt) {
        this.lastResourceAnalyzedAt = lastResourceAnalyzedAt;
    }

    public AnalyzerSummary withName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AnalyzerSummary withOrganizationId(String organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public AnalyzerSummary withStatus(StatusEnum status) {
        this.status = status;
        return this;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public AnalyzerSummary withStatusReason(StatusReason statusReason) {
        this.statusReason = statusReason;
        return this;
    }

    public AnalyzerSummary withStatusReason(Consumer<StatusReason> statusReasonSetter) {
        if (this.statusReason == null) {
            this.statusReason = new StatusReason();
            statusReasonSetter.accept(this.statusReason);
        }
        return this;
    }

    public StatusReason getStatusReason() {
        return this.statusReason;
    }

    public void setStatusReason(StatusReason statusReason) {
        this.statusReason = statusReason;
    }

    public AnalyzerSummary withTags(List<Tag> tags) {
        this.tags = tags;
        return this;
    }

    public AnalyzerSummary addTagsItem(Tag tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    public AnalyzerSummary withTags(Consumer<List<Tag>> tagsSetter) {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        tagsSetter.accept(this.tags);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public AnalyzerSummary withType(AnalyzerType type) {
        this.type = type;
        return this;
    }

    public AnalyzerType getType() {
        return this.type;
    }

    public void setType(AnalyzerType type) {
        this.type = type;
    }

    public AnalyzerSummary withUrn(String urn) {
        this.urn = urn;
        return this;
    }

    public String getUrn() {
        return this.urn;
    }

    public void setUrn(String urn) {
        this.urn = urn;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AnalyzerSummary that = (AnalyzerSummary)obj;
        return Objects.equals(this._configuration, that._configuration) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.id, that.id) && Objects.equals(this.lastAnalyzedResource, that.lastAnalyzedResource) && Objects.equals(this.lastResourceAnalyzedAt, that.lastResourceAnalyzedAt) && Objects.equals(this.name, that.name) && Objects.equals(this.organizationId, that.organizationId) && Objects.equals(this.status, that.status) && Objects.equals(this.statusReason, that.statusReason) && Objects.equals(this.tags, that.tags) && Objects.equals(this.type, that.type) && Objects.equals(this.urn, that.urn);
    }

    public int hashCode() {
        return Objects.hash(this._configuration, this.createdAt, this.id, this.lastAnalyzedResource, this.lastResourceAnalyzedAt, this.name, this.organizationId, this.status, this.statusReason, this.tags, this.type, this.urn);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnalyzerSummary {\n");
        sb.append("    _configuration: ").append(this.toIndentedString(this._configuration)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastAnalyzedResource: ").append(this.toIndentedString(this.lastAnalyzedResource)).append("\n");
        sb.append("    lastResourceAnalyzedAt: ").append(this.toIndentedString(this.lastResourceAnalyzedAt)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    organizationId: ").append(this.toIndentedString(this.organizationId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    statusReason: ").append(this.toIndentedString(this.statusReason)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    urn: ").append(this.toIndentedString(this.urn)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class StatusEnum {
        public static final StatusEnum ACTIVE = new StatusEnum("active");
        public static final StatusEnum CREATING = new StatusEnum("creating");
        public static final StatusEnum DISABLED = new StatusEnum("disabled");
        public static final StatusEnum FAILED = new StatusEnum("failed");
        private static final Map<String, StatusEnum> STATIC_FIELDS = StatusEnum.createStaticFields();
        private String value;

        private static Map<String, StatusEnum> createStaticFields() {
            HashMap<String, StatusEnum> map = new HashMap<String, StatusEnum>();
            map.put("active", ACTIVE);
            map.put("creating", CREATING);
            map.put("disabled", DISABLED);
            map.put("failed", FAILED);
            return Collections.unmodifiableMap(map);
        }

        StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new StatusEnum(value));
        }

        public static StatusEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof StatusEnum) {
                return this.value.equals(((StatusEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

