/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.hss.v5.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.hss.v5.model.RuntimeRequestBody;
import com.huaweicloud.sdk.hss.v5.model.UpdateDaemonsetRequestBodyScheduleInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class UpdateDaemonsetRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="agent_version")
    private String agentVersion;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="cluster_name")
    private String clusterName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="auto_upgrade")
    private Boolean autoUpgrade;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="runtime_info")
    private List<RuntimeRequestBody> runtimeInfo = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="schedule_info")
    private UpdateDaemonsetRequestBodyScheduleInfo scheduleInfo;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="invoked_service")
    private String invokedService;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="charging_mode")
    private ChargingModeEnum chargingMode;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="cce_protection_type")
    private CceProtectionTypeEnum cceProtectionType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="prefer_packet_cycle")
    private Boolean preferPacketCycle;

    public UpdateDaemonsetRequestBody withAgentVersion(String agentVersion) {
        this.agentVersion = agentVersion;
        return this;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public void setAgentVersion(String agentVersion) {
        this.agentVersion = agentVersion;
    }

    public UpdateDaemonsetRequestBody withClusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public UpdateDaemonsetRequestBody withAutoUpgrade(Boolean autoUpgrade) {
        this.autoUpgrade = autoUpgrade;
        return this;
    }

    public Boolean getAutoUpgrade() {
        return this.autoUpgrade;
    }

    public void setAutoUpgrade(Boolean autoUpgrade) {
        this.autoUpgrade = autoUpgrade;
    }

    public UpdateDaemonsetRequestBody withRuntimeInfo(List<RuntimeRequestBody> runtimeInfo) {
        this.runtimeInfo = runtimeInfo;
        return this;
    }

    public UpdateDaemonsetRequestBody addRuntimeInfoItem(RuntimeRequestBody runtimeInfoItem) {
        if (this.runtimeInfo == null) {
            this.runtimeInfo = new ArrayList<RuntimeRequestBody>();
        }
        this.runtimeInfo.add(runtimeInfoItem);
        return this;
    }

    public UpdateDaemonsetRequestBody withRuntimeInfo(Consumer<List<RuntimeRequestBody>> runtimeInfoSetter) {
        if (this.runtimeInfo == null) {
            this.runtimeInfo = new ArrayList<RuntimeRequestBody>();
        }
        runtimeInfoSetter.accept(this.runtimeInfo);
        return this;
    }

    public List<RuntimeRequestBody> getRuntimeInfo() {
        return this.runtimeInfo;
    }

    public void setRuntimeInfo(List<RuntimeRequestBody> runtimeInfo) {
        this.runtimeInfo = runtimeInfo;
    }

    public UpdateDaemonsetRequestBody withScheduleInfo(UpdateDaemonsetRequestBodyScheduleInfo scheduleInfo) {
        this.scheduleInfo = scheduleInfo;
        return this;
    }

    public UpdateDaemonsetRequestBody withScheduleInfo(Consumer<UpdateDaemonsetRequestBodyScheduleInfo> scheduleInfoSetter) {
        if (this.scheduleInfo == null) {
            this.scheduleInfo = new UpdateDaemonsetRequestBodyScheduleInfo();
            scheduleInfoSetter.accept(this.scheduleInfo);
        }
        return this;
    }

    public UpdateDaemonsetRequestBodyScheduleInfo getScheduleInfo() {
        return this.scheduleInfo;
    }

    public void setScheduleInfo(UpdateDaemonsetRequestBodyScheduleInfo scheduleInfo) {
        this.scheduleInfo = scheduleInfo;
    }

    public UpdateDaemonsetRequestBody withInvokedService(String invokedService) {
        this.invokedService = invokedService;
        return this;
    }

    public String getInvokedService() {
        return this.invokedService;
    }

    public void setInvokedService(String invokedService) {
        this.invokedService = invokedService;
    }

    public UpdateDaemonsetRequestBody withChargingMode(ChargingModeEnum chargingMode) {
        this.chargingMode = chargingMode;
        return this;
    }

    public ChargingModeEnum getChargingMode() {
        return this.chargingMode;
    }

    public void setChargingMode(ChargingModeEnum chargingMode) {
        this.chargingMode = chargingMode;
    }

    public UpdateDaemonsetRequestBody withCceProtectionType(CceProtectionTypeEnum cceProtectionType) {
        this.cceProtectionType = cceProtectionType;
        return this;
    }

    public CceProtectionTypeEnum getCceProtectionType() {
        return this.cceProtectionType;
    }

    public void setCceProtectionType(CceProtectionTypeEnum cceProtectionType) {
        this.cceProtectionType = cceProtectionType;
    }

    public UpdateDaemonsetRequestBody withPreferPacketCycle(Boolean preferPacketCycle) {
        this.preferPacketCycle = preferPacketCycle;
        return this;
    }

    public Boolean getPreferPacketCycle() {
        return this.preferPacketCycle;
    }

    public void setPreferPacketCycle(Boolean preferPacketCycle) {
        this.preferPacketCycle = preferPacketCycle;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateDaemonsetRequestBody that = (UpdateDaemonsetRequestBody)obj;
        return Objects.equals(this.agentVersion, that.agentVersion) && Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.autoUpgrade, that.autoUpgrade) && Objects.equals(this.runtimeInfo, that.runtimeInfo) && Objects.equals(this.scheduleInfo, that.scheduleInfo) && Objects.equals(this.invokedService, that.invokedService) && Objects.equals(this.chargingMode, that.chargingMode) && Objects.equals(this.cceProtectionType, that.cceProtectionType) && Objects.equals(this.preferPacketCycle, that.preferPacketCycle);
    }

    public int hashCode() {
        return Objects.hash(this.agentVersion, this.clusterName, this.autoUpgrade, this.runtimeInfo, this.scheduleInfo, this.invokedService, this.chargingMode, this.cceProtectionType, this.preferPacketCycle);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateDaemonsetRequestBody {\n");
        sb.append("    agentVersion: ").append(this.toIndentedString(this.agentVersion)).append("\n");
        sb.append("    clusterName: ").append(this.toIndentedString(this.clusterName)).append("\n");
        sb.append("    autoUpgrade: ").append(this.toIndentedString(this.autoUpgrade)).append("\n");
        sb.append("    runtimeInfo: ").append(this.toIndentedString(this.runtimeInfo)).append("\n");
        sb.append("    scheduleInfo: ").append(this.toIndentedString(this.scheduleInfo)).append("\n");
        sb.append("    invokedService: ").append(this.toIndentedString(this.invokedService)).append("\n");
        sb.append("    chargingMode: ").append(this.toIndentedString(this.chargingMode)).append("\n");
        sb.append("    cceProtectionType: ").append(this.toIndentedString(this.cceProtectionType)).append("\n");
        sb.append("    preferPacketCycle: ").append(this.toIndentedString(this.preferPacketCycle)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class CceProtectionTypeEnum {
        public static final CceProtectionTypeEnum CLUSTER_LEVEL = new CceProtectionTypeEnum("cluster_level");
        public static final CceProtectionTypeEnum NODE_LEVEL = new CceProtectionTypeEnum("node_level");
        private static final Map<String, CceProtectionTypeEnum> STATIC_FIELDS = CceProtectionTypeEnum.createStaticFields();
        private String value;

        private static Map<String, CceProtectionTypeEnum> createStaticFields() {
            HashMap<String, CceProtectionTypeEnum> map = new HashMap<String, CceProtectionTypeEnum>();
            map.put("cluster_level", CLUSTER_LEVEL);
            map.put("node_level", NODE_LEVEL);
            return Collections.unmodifiableMap(map);
        }

        CceProtectionTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CceProtectionTypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new CceProtectionTypeEnum(value));
        }

        public static CceProtectionTypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof CceProtectionTypeEnum) {
                return this.value.equals(((CceProtectionTypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class ChargingModeEnum {
        public static final ChargingModeEnum ON_DEMAND = new ChargingModeEnum("on_demand");
        public static final ChargingModeEnum FREE_SECURITY_CHECK = new ChargingModeEnum("free_security_check");
        private static final Map<String, ChargingModeEnum> STATIC_FIELDS = ChargingModeEnum.createStaticFields();
        private String value;

        private static Map<String, ChargingModeEnum> createStaticFields() {
            HashMap<String, ChargingModeEnum> map = new HashMap<String, ChargingModeEnum>();
            map.put("on_demand", ON_DEMAND);
            map.put("free_security_check", FREE_SECURITY_CHECK);
            return Collections.unmodifiableMap(map);
        }

        ChargingModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChargingModeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ChargingModeEnum(value));
        }

        public static ChargingModeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ChargingModeEnum) {
                return this.value.equals(((ChargingModeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

