/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.hss.v5.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RuntimeRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="runtime_name")
    private RuntimeNameEnum runtimeName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="runtime_path")
    private String runtimePath;

    public RuntimeRequestBody withRuntimeName(RuntimeNameEnum runtimeName) {
        this.runtimeName = runtimeName;
        return this;
    }

    public RuntimeNameEnum getRuntimeName() {
        return this.runtimeName;
    }

    public void setRuntimeName(RuntimeNameEnum runtimeName) {
        this.runtimeName = runtimeName;
    }

    public RuntimeRequestBody withRuntimePath(String runtimePath) {
        this.runtimePath = runtimePath;
        return this;
    }

    public String getRuntimePath() {
        return this.runtimePath;
    }

    public void setRuntimePath(String runtimePath) {
        this.runtimePath = runtimePath;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RuntimeRequestBody that = (RuntimeRequestBody)obj;
        return Objects.equals(this.runtimeName, that.runtimeName) && Objects.equals(this.runtimePath, that.runtimePath);
    }

    public int hashCode() {
        return Objects.hash(this.runtimeName, this.runtimePath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RuntimeRequestBody {\n");
        sb.append("    runtimeName: ").append(this.toIndentedString(this.runtimeName)).append("\n");
        sb.append("    runtimePath: ").append(this.toIndentedString(this.runtimePath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class RuntimeNameEnum {
        public static final RuntimeNameEnum CRIO_ENDPOINT = new RuntimeNameEnum("crio_endpoint");
        public static final RuntimeNameEnum CONTAINERD_ENDPOINT = new RuntimeNameEnum("containerd_endpoint");
        public static final RuntimeNameEnum DOCKER_ENDPOINT = new RuntimeNameEnum("docker_endpoint");
        public static final RuntimeNameEnum ISULAD_ENDPOINT = new RuntimeNameEnum("isulad_endpoint");
        public static final RuntimeNameEnum PODMAN_ENDPOINT = new RuntimeNameEnum("podman_endpoint");
        private static final Map<String, RuntimeNameEnum> STATIC_FIELDS = RuntimeNameEnum.createStaticFields();
        private String value;

        private static Map<String, RuntimeNameEnum> createStaticFields() {
            HashMap<String, RuntimeNameEnum> map = new HashMap<String, RuntimeNameEnum>();
            map.put("crio_endpoint", CRIO_ENDPOINT);
            map.put("containerd_endpoint", CONTAINERD_ENDPOINT);
            map.put("docker_endpoint", DOCKER_ENDPOINT);
            map.put("isulad_endpoint", ISULAD_ENDPOINT);
            map.put("podman_endpoint", PODMAN_ENDPOINT);
            return Collections.unmodifiableMap(map);
        }

        RuntimeNameEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RuntimeNameEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new RuntimeNameEnum(value));
        }

        public static RuntimeNameEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof RuntimeNameEnum) {
                return this.value.equals(((RuntimeNameEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

