/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.ecs.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.ecs.v2.model.NovaLink;
import com.huaweicloud.sdk.ecs.v2.model.NovaVersionMediaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class NovaVersionDetail {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="id")
    private String id;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="links")
    private List<NovaLink> links = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="media-types")
    private List<NovaVersionMediaType> mediaTypes = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="min_version")
    private String minVersion;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="status")
    private StatusEnum status;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="updated")
    private String updated;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="version")
    private String version;

    public NovaVersionDetail withId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public NovaVersionDetail withLinks(List<NovaLink> links) {
        this.links = links;
        return this;
    }

    public NovaVersionDetail addLinksItem(NovaLink linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<NovaLink>();
        }
        this.links.add(linksItem);
        return this;
    }

    public NovaVersionDetail withLinks(Consumer<List<NovaLink>> linksSetter) {
        if (this.links == null) {
            this.links = new ArrayList<NovaLink>();
        }
        linksSetter.accept(this.links);
        return this;
    }

    public List<NovaLink> getLinks() {
        return this.links;
    }

    public void setLinks(List<NovaLink> links) {
        this.links = links;
    }

    public NovaVersionDetail withMediaTypes(List<NovaVersionMediaType> mediaTypes) {
        this.mediaTypes = mediaTypes;
        return this;
    }

    public NovaVersionDetail addMediaTypesItem(NovaVersionMediaType mediaTypesItem) {
        if (this.mediaTypes == null) {
            this.mediaTypes = new ArrayList<NovaVersionMediaType>();
        }
        this.mediaTypes.add(mediaTypesItem);
        return this;
    }

    public NovaVersionDetail withMediaTypes(Consumer<List<NovaVersionMediaType>> mediaTypesSetter) {
        if (this.mediaTypes == null) {
            this.mediaTypes = new ArrayList<NovaVersionMediaType>();
        }
        mediaTypesSetter.accept(this.mediaTypes);
        return this;
    }

    public List<NovaVersionMediaType> getMediaTypes() {
        return this.mediaTypes;
    }

    public void setMediaTypes(List<NovaVersionMediaType> mediaTypes) {
        this.mediaTypes = mediaTypes;
    }

    public NovaVersionDetail withMinVersion(String minVersion) {
        this.minVersion = minVersion;
        return this;
    }

    public String getMinVersion() {
        return this.minVersion;
    }

    public void setMinVersion(String minVersion) {
        this.minVersion = minVersion;
    }

    public NovaVersionDetail withStatus(StatusEnum status) {
        this.status = status;
        return this;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public NovaVersionDetail withUpdated(String updated) {
        this.updated = updated;
        return this;
    }

    public String getUpdated() {
        return this.updated;
    }

    public void setUpdated(String updated) {
        this.updated = updated;
    }

    public NovaVersionDetail withVersion(String version) {
        this.version = version;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NovaVersionDetail that = (NovaVersionDetail)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.links, that.links) && Objects.equals(this.mediaTypes, that.mediaTypes) && Objects.equals(this.minVersion, that.minVersion) && Objects.equals(this.status, that.status) && Objects.equals(this.updated, that.updated) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.links, this.mediaTypes, this.minVersion, this.status, this.updated, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NovaVersionDetail {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    mediaTypes: ").append(this.toIndentedString(this.mediaTypes)).append("\n");
        sb.append("    minVersion: ").append(this.toIndentedString(this.minVersion)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    updated: ").append(this.toIndentedString(this.updated)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class StatusEnum {
        public static final StatusEnum CURRENT = new StatusEnum("CURRENT");
        public static final StatusEnum SUPPORTED = new StatusEnum("SUPPORTED");
        public static final StatusEnum DEPRECATED = new StatusEnum("DEPRECATED");
        private static final Map<String, StatusEnum> STATIC_FIELDS = StatusEnum.createStaticFields();
        private String value;

        private static Map<String, StatusEnum> createStaticFields() {
            HashMap<String, StatusEnum> map = new HashMap<String, StatusEnum>();
            map.put("CURRENT", CURRENT);
            map.put("SUPPORTED", SUPPORTED);
            map.put("DEPRECATED", DEPRECATED);
            return Collections.unmodifiableMap(map);
        }

        StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new StatusEnum(value));
        }

        public static StatusEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof StatusEnum) {
                return this.value.equals(((StatusEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

