/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.ecs.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.ecs.v2.model.NovaLink;
import com.huaweicloud.sdk.ecs.v2.model.NovaNetwork;
import com.huaweicloud.sdk.ecs.v2.model.NovaServerFault;
import com.huaweicloud.sdk.ecs.v2.model.NovaServerFlavor;
import com.huaweicloud.sdk.ecs.v2.model.NovaServerImage;
import com.huaweicloud.sdk.ecs.v2.model.NovaServerSchedulerHints;
import com.huaweicloud.sdk.ecs.v2.model.NovaServerSecurityGroup;
import com.huaweicloud.sdk.ecs.v2.model.NovaServerVolume;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class NovaServer {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="name")
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="id")
    private String id;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="status")
    private StatusEnum status;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="created")
    private String created;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="updated")
    private String updated;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="flavor")
    private NovaServerFlavor flavor;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="image")
    private NovaServerImage image;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="key_name")
    private String keyName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="user_id")
    private String userId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="metadata")
    private Map<String, String> metadata = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="hostId")
    private String hostId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="addresses")
    private Map<String, List<NovaNetwork>> addresses = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="security_groups")
    private List<NovaServerSecurityGroup> securityGroups = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="links")
    private List<NovaLink> links = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="OS-DCF:diskConfig")
    private OsDCFDiskConfigEnum osDCFDiskConfig;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="OS-EXT-AZ:availability_zone")
    private String osEXTAZAvailabilityZone;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="OS-EXT-SRV-ATTR:host")
    private String osEXTSRVATTRHost;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="OS-EXT-SRV-ATTR:hypervisor_hostname")
    private String osEXTSRVATTRHypervisorHostname;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="OS-EXT-SRV-ATTR:instance_name")
    private String osEXTSRVATTRInstanceName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="OS-EXT-STS:power_state")
    private Integer osEXTSTSPowerState;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="OS-EXT-STS:task_state")
    private OsEXTSTSTaskStateEnum osEXTSTSTaskState;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="OS-EXT-STS:vm_state")
    private OsEXTSTSVmStateEnum osEXTSTSVmState;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="OS-SRV-USG:launched_at")
    private String osSRVUSGLaunchedAt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="OS-SRV-USG:terminated_at")
    private String osSRVUSGTerminatedAt;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="os-extended-volumes:volumes_attached")
    private List<NovaServerVolume> osExtendedVolumesVolumesAttached = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="fault")
    private NovaServerFault fault;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="description")
    private String description;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="host_status")
    private HostStatusEnum hostStatus;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="OS-EXT-SRV-ATTR:hostname")
    private String osEXTSRVATTRHostname;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="OS-EXT-SRV-ATTR:reservation_id")
    private String osEXTSRVATTRReservationId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="OS-EXT-SRV-ATTR:launch_index")
    private Integer osEXTSRVATTRLaunchIndex;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="OS-EXT-SRV-ATTR:kernel_id")
    private String osEXTSRVATTRKernelId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="OS-EXT-SRV-ATTR:ramdisk_id")
    private String osEXTSRVATTRRamdiskId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="OS-EXT-SRV-ATTR:root_device_name")
    private String osEXTSRVATTRRootDeviceName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="OS-EXT-SRV-ATTR:user_data")
    private String osEXTSRVATTRUserData;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="tags")
    private List<String> tags = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="locked")
    private Boolean locked;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="accessIPv4")
    private String accessIPv4;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="accessIPv6")
    private String accessIPv6;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="config_drive")
    private String configDrive;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="progress")
    private Integer progress;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="os:scheduler_hints")
    private NovaServerSchedulerHints osSchedulerHints;

    public NovaServer withName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NovaServer withId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public NovaServer withStatus(StatusEnum status) {
        this.status = status;
        return this;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public NovaServer withCreated(String created) {
        this.created = created;
        return this;
    }

    public String getCreated() {
        return this.created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public NovaServer withUpdated(String updated) {
        this.updated = updated;
        return this;
    }

    public String getUpdated() {
        return this.updated;
    }

    public void setUpdated(String updated) {
        this.updated = updated;
    }

    public NovaServer withFlavor(NovaServerFlavor flavor) {
        this.flavor = flavor;
        return this;
    }

    public NovaServer withFlavor(Consumer<NovaServerFlavor> flavorSetter) {
        if (this.flavor == null) {
            this.flavor = new NovaServerFlavor();
            flavorSetter.accept(this.flavor);
        }
        return this;
    }

    public NovaServerFlavor getFlavor() {
        return this.flavor;
    }

    public void setFlavor(NovaServerFlavor flavor) {
        this.flavor = flavor;
    }

    public NovaServer withImage(NovaServerImage image) {
        this.image = image;
        return this;
    }

    public NovaServer withImage(Consumer<NovaServerImage> imageSetter) {
        if (this.image == null) {
            this.image = new NovaServerImage();
            imageSetter.accept(this.image);
        }
        return this;
    }

    public NovaServerImage getImage() {
        return this.image;
    }

    public void setImage(NovaServerImage image) {
        this.image = image;
    }

    public NovaServer withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public NovaServer withKeyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public NovaServer withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public NovaServer withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public NovaServer putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    public NovaServer withMetadata(Consumer<Map<String, String>> metadataSetter) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        metadataSetter.accept(this.metadata);
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public NovaServer withHostId(String hostId) {
        this.hostId = hostId;
        return this;
    }

    public String getHostId() {
        return this.hostId;
    }

    public void setHostId(String hostId) {
        this.hostId = hostId;
    }

    public NovaServer withAddresses(Map<String, List<NovaNetwork>> addresses) {
        this.addresses = addresses;
        return this;
    }

    public NovaServer putAddressesItem(String key, List<NovaNetwork> addressesItem) {
        if (this.addresses == null) {
            this.addresses = new HashMap<String, List<NovaNetwork>>();
        }
        this.addresses.put(key, addressesItem);
        return this;
    }

    public NovaServer withAddresses(Consumer<Map<String, List<NovaNetwork>>> addressesSetter) {
        if (this.addresses == null) {
            this.addresses = new HashMap<String, List<NovaNetwork>>();
        }
        addressesSetter.accept(this.addresses);
        return this;
    }

    public Map<String, List<NovaNetwork>> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(Map<String, List<NovaNetwork>> addresses) {
        this.addresses = addresses;
    }

    public NovaServer withSecurityGroups(List<NovaServerSecurityGroup> securityGroups) {
        this.securityGroups = securityGroups;
        return this;
    }

    public NovaServer addSecurityGroupsItem(NovaServerSecurityGroup securityGroupsItem) {
        if (this.securityGroups == null) {
            this.securityGroups = new ArrayList<NovaServerSecurityGroup>();
        }
        this.securityGroups.add(securityGroupsItem);
        return this;
    }

    public NovaServer withSecurityGroups(Consumer<List<NovaServerSecurityGroup>> securityGroupsSetter) {
        if (this.securityGroups == null) {
            this.securityGroups = new ArrayList<NovaServerSecurityGroup>();
        }
        securityGroupsSetter.accept(this.securityGroups);
        return this;
    }

    public List<NovaServerSecurityGroup> getSecurityGroups() {
        return this.securityGroups;
    }

    public void setSecurityGroups(List<NovaServerSecurityGroup> securityGroups) {
        this.securityGroups = securityGroups;
    }

    public NovaServer withLinks(List<NovaLink> links) {
        this.links = links;
        return this;
    }

    public NovaServer addLinksItem(NovaLink linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<NovaLink>();
        }
        this.links.add(linksItem);
        return this;
    }

    public NovaServer withLinks(Consumer<List<NovaLink>> linksSetter) {
        if (this.links == null) {
            this.links = new ArrayList<NovaLink>();
        }
        linksSetter.accept(this.links);
        return this;
    }

    public List<NovaLink> getLinks() {
        return this.links;
    }

    public void setLinks(List<NovaLink> links) {
        this.links = links;
    }

    public NovaServer withOsDCFDiskConfig(OsDCFDiskConfigEnum osDCFDiskConfig) {
        this.osDCFDiskConfig = osDCFDiskConfig;
        return this;
    }

    public OsDCFDiskConfigEnum getOsDCFDiskConfig() {
        return this.osDCFDiskConfig;
    }

    public void setOsDCFDiskConfig(OsDCFDiskConfigEnum osDCFDiskConfig) {
        this.osDCFDiskConfig = osDCFDiskConfig;
    }

    public NovaServer withOsEXTAZAvailabilityZone(String osEXTAZAvailabilityZone) {
        this.osEXTAZAvailabilityZone = osEXTAZAvailabilityZone;
        return this;
    }

    public String getOsEXTAZAvailabilityZone() {
        return this.osEXTAZAvailabilityZone;
    }

    public void setOsEXTAZAvailabilityZone(String osEXTAZAvailabilityZone) {
        this.osEXTAZAvailabilityZone = osEXTAZAvailabilityZone;
    }

    public NovaServer withOsEXTSRVATTRHost(String osEXTSRVATTRHost) {
        this.osEXTSRVATTRHost = osEXTSRVATTRHost;
        return this;
    }

    public String getOsEXTSRVATTRHost() {
        return this.osEXTSRVATTRHost;
    }

    public void setOsEXTSRVATTRHost(String osEXTSRVATTRHost) {
        this.osEXTSRVATTRHost = osEXTSRVATTRHost;
    }

    public NovaServer withOsEXTSRVATTRHypervisorHostname(String osEXTSRVATTRHypervisorHostname) {
        this.osEXTSRVATTRHypervisorHostname = osEXTSRVATTRHypervisorHostname;
        return this;
    }

    public String getOsEXTSRVATTRHypervisorHostname() {
        return this.osEXTSRVATTRHypervisorHostname;
    }

    public void setOsEXTSRVATTRHypervisorHostname(String osEXTSRVATTRHypervisorHostname) {
        this.osEXTSRVATTRHypervisorHostname = osEXTSRVATTRHypervisorHostname;
    }

    public NovaServer withOsEXTSRVATTRInstanceName(String osEXTSRVATTRInstanceName) {
        this.osEXTSRVATTRInstanceName = osEXTSRVATTRInstanceName;
        return this;
    }

    public String getOsEXTSRVATTRInstanceName() {
        return this.osEXTSRVATTRInstanceName;
    }

    public void setOsEXTSRVATTRInstanceName(String osEXTSRVATTRInstanceName) {
        this.osEXTSRVATTRInstanceName = osEXTSRVATTRInstanceName;
    }

    public NovaServer withOsEXTSTSPowerState(Integer osEXTSTSPowerState) {
        this.osEXTSTSPowerState = osEXTSTSPowerState;
        return this;
    }

    public Integer getOsEXTSTSPowerState() {
        return this.osEXTSTSPowerState;
    }

    public void setOsEXTSTSPowerState(Integer osEXTSTSPowerState) {
        this.osEXTSTSPowerState = osEXTSTSPowerState;
    }

    public NovaServer withOsEXTSTSTaskState(OsEXTSTSTaskStateEnum osEXTSTSTaskState) {
        this.osEXTSTSTaskState = osEXTSTSTaskState;
        return this;
    }

    public OsEXTSTSTaskStateEnum getOsEXTSTSTaskState() {
        return this.osEXTSTSTaskState;
    }

    public void setOsEXTSTSTaskState(OsEXTSTSTaskStateEnum osEXTSTSTaskState) {
        this.osEXTSTSTaskState = osEXTSTSTaskState;
    }

    public NovaServer withOsEXTSTSVmState(OsEXTSTSVmStateEnum osEXTSTSVmState) {
        this.osEXTSTSVmState = osEXTSTSVmState;
        return this;
    }

    public OsEXTSTSVmStateEnum getOsEXTSTSVmState() {
        return this.osEXTSTSVmState;
    }

    public void setOsEXTSTSVmState(OsEXTSTSVmStateEnum osEXTSTSVmState) {
        this.osEXTSTSVmState = osEXTSTSVmState;
    }

    public NovaServer withOsSRVUSGLaunchedAt(String osSRVUSGLaunchedAt) {
        this.osSRVUSGLaunchedAt = osSRVUSGLaunchedAt;
        return this;
    }

    public String getOsSRVUSGLaunchedAt() {
        return this.osSRVUSGLaunchedAt;
    }

    public void setOsSRVUSGLaunchedAt(String osSRVUSGLaunchedAt) {
        this.osSRVUSGLaunchedAt = osSRVUSGLaunchedAt;
    }

    public NovaServer withOsSRVUSGTerminatedAt(String osSRVUSGTerminatedAt) {
        this.osSRVUSGTerminatedAt = osSRVUSGTerminatedAt;
        return this;
    }

    public String getOsSRVUSGTerminatedAt() {
        return this.osSRVUSGTerminatedAt;
    }

    public void setOsSRVUSGTerminatedAt(String osSRVUSGTerminatedAt) {
        this.osSRVUSGTerminatedAt = osSRVUSGTerminatedAt;
    }

    public NovaServer withOsExtendedVolumesVolumesAttached(List<NovaServerVolume> osExtendedVolumesVolumesAttached) {
        this.osExtendedVolumesVolumesAttached = osExtendedVolumesVolumesAttached;
        return this;
    }

    public NovaServer addOsExtendedVolumesVolumesAttachedItem(NovaServerVolume osExtendedVolumesVolumesAttachedItem) {
        if (this.osExtendedVolumesVolumesAttached == null) {
            this.osExtendedVolumesVolumesAttached = new ArrayList<NovaServerVolume>();
        }
        this.osExtendedVolumesVolumesAttached.add(osExtendedVolumesVolumesAttachedItem);
        return this;
    }

    public NovaServer withOsExtendedVolumesVolumesAttached(Consumer<List<NovaServerVolume>> osExtendedVolumesVolumesAttachedSetter) {
        if (this.osExtendedVolumesVolumesAttached == null) {
            this.osExtendedVolumesVolumesAttached = new ArrayList<NovaServerVolume>();
        }
        osExtendedVolumesVolumesAttachedSetter.accept(this.osExtendedVolumesVolumesAttached);
        return this;
    }

    public List<NovaServerVolume> getOsExtendedVolumesVolumesAttached() {
        return this.osExtendedVolumesVolumesAttached;
    }

    public void setOsExtendedVolumesVolumesAttached(List<NovaServerVolume> osExtendedVolumesVolumesAttached) {
        this.osExtendedVolumesVolumesAttached = osExtendedVolumesVolumesAttached;
    }

    public NovaServer withFault(NovaServerFault fault) {
        this.fault = fault;
        return this;
    }

    public NovaServer withFault(Consumer<NovaServerFault> faultSetter) {
        if (this.fault == null) {
            this.fault = new NovaServerFault();
            faultSetter.accept(this.fault);
        }
        return this;
    }

    public NovaServerFault getFault() {
        return this.fault;
    }

    public void setFault(NovaServerFault fault) {
        this.fault = fault;
    }

    public NovaServer withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public NovaServer withHostStatus(HostStatusEnum hostStatus) {
        this.hostStatus = hostStatus;
        return this;
    }

    public HostStatusEnum getHostStatus() {
        return this.hostStatus;
    }

    public void setHostStatus(HostStatusEnum hostStatus) {
        this.hostStatus = hostStatus;
    }

    public NovaServer withOsEXTSRVATTRHostname(String osEXTSRVATTRHostname) {
        this.osEXTSRVATTRHostname = osEXTSRVATTRHostname;
        return this;
    }

    public String getOsEXTSRVATTRHostname() {
        return this.osEXTSRVATTRHostname;
    }

    public void setOsEXTSRVATTRHostname(String osEXTSRVATTRHostname) {
        this.osEXTSRVATTRHostname = osEXTSRVATTRHostname;
    }

    public NovaServer withOsEXTSRVATTRReservationId(String osEXTSRVATTRReservationId) {
        this.osEXTSRVATTRReservationId = osEXTSRVATTRReservationId;
        return this;
    }

    public String getOsEXTSRVATTRReservationId() {
        return this.osEXTSRVATTRReservationId;
    }

    public void setOsEXTSRVATTRReservationId(String osEXTSRVATTRReservationId) {
        this.osEXTSRVATTRReservationId = osEXTSRVATTRReservationId;
    }

    public NovaServer withOsEXTSRVATTRLaunchIndex(Integer osEXTSRVATTRLaunchIndex) {
        this.osEXTSRVATTRLaunchIndex = osEXTSRVATTRLaunchIndex;
        return this;
    }

    public Integer getOsEXTSRVATTRLaunchIndex() {
        return this.osEXTSRVATTRLaunchIndex;
    }

    public void setOsEXTSRVATTRLaunchIndex(Integer osEXTSRVATTRLaunchIndex) {
        this.osEXTSRVATTRLaunchIndex = osEXTSRVATTRLaunchIndex;
    }

    public NovaServer withOsEXTSRVATTRKernelId(String osEXTSRVATTRKernelId) {
        this.osEXTSRVATTRKernelId = osEXTSRVATTRKernelId;
        return this;
    }

    public String getOsEXTSRVATTRKernelId() {
        return this.osEXTSRVATTRKernelId;
    }

    public void setOsEXTSRVATTRKernelId(String osEXTSRVATTRKernelId) {
        this.osEXTSRVATTRKernelId = osEXTSRVATTRKernelId;
    }

    public NovaServer withOsEXTSRVATTRRamdiskId(String osEXTSRVATTRRamdiskId) {
        this.osEXTSRVATTRRamdiskId = osEXTSRVATTRRamdiskId;
        return this;
    }

    public String getOsEXTSRVATTRRamdiskId() {
        return this.osEXTSRVATTRRamdiskId;
    }

    public void setOsEXTSRVATTRRamdiskId(String osEXTSRVATTRRamdiskId) {
        this.osEXTSRVATTRRamdiskId = osEXTSRVATTRRamdiskId;
    }

    public NovaServer withOsEXTSRVATTRRootDeviceName(String osEXTSRVATTRRootDeviceName) {
        this.osEXTSRVATTRRootDeviceName = osEXTSRVATTRRootDeviceName;
        return this;
    }

    public String getOsEXTSRVATTRRootDeviceName() {
        return this.osEXTSRVATTRRootDeviceName;
    }

    public void setOsEXTSRVATTRRootDeviceName(String osEXTSRVATTRRootDeviceName) {
        this.osEXTSRVATTRRootDeviceName = osEXTSRVATTRRootDeviceName;
    }

    public NovaServer withOsEXTSRVATTRUserData(String osEXTSRVATTRUserData) {
        this.osEXTSRVATTRUserData = osEXTSRVATTRUserData;
        return this;
    }

    public String getOsEXTSRVATTRUserData() {
        return this.osEXTSRVATTRUserData;
    }

    public void setOsEXTSRVATTRUserData(String osEXTSRVATTRUserData) {
        this.osEXTSRVATTRUserData = osEXTSRVATTRUserData;
    }

    public NovaServer withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public NovaServer addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    public NovaServer withTags(Consumer<List<String>> tagsSetter) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        tagsSetter.accept(this.tags);
        return this;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public NovaServer withLocked(Boolean locked) {
        this.locked = locked;
        return this;
    }

    public Boolean getLocked() {
        return this.locked;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public NovaServer withAccessIPv4(String accessIPv4) {
        this.accessIPv4 = accessIPv4;
        return this;
    }

    public String getAccessIPv4() {
        return this.accessIPv4;
    }

    public void setAccessIPv4(String accessIPv4) {
        this.accessIPv4 = accessIPv4;
    }

    public NovaServer withAccessIPv6(String accessIPv6) {
        this.accessIPv6 = accessIPv6;
        return this;
    }

    public String getAccessIPv6() {
        return this.accessIPv6;
    }

    public void setAccessIPv6(String accessIPv6) {
        this.accessIPv6 = accessIPv6;
    }

    public NovaServer withConfigDrive(String configDrive) {
        this.configDrive = configDrive;
        return this;
    }

    public String getConfigDrive() {
        return this.configDrive;
    }

    public void setConfigDrive(String configDrive) {
        this.configDrive = configDrive;
    }

    public NovaServer withProgress(Integer progress) {
        this.progress = progress;
        return this;
    }

    public Integer getProgress() {
        return this.progress;
    }

    public void setProgress(Integer progress) {
        this.progress = progress;
    }

    public NovaServer withOsSchedulerHints(NovaServerSchedulerHints osSchedulerHints) {
        this.osSchedulerHints = osSchedulerHints;
        return this;
    }

    public NovaServer withOsSchedulerHints(Consumer<NovaServerSchedulerHints> osSchedulerHintsSetter) {
        if (this.osSchedulerHints == null) {
            this.osSchedulerHints = new NovaServerSchedulerHints();
            osSchedulerHintsSetter.accept(this.osSchedulerHints);
        }
        return this;
    }

    public NovaServerSchedulerHints getOsSchedulerHints() {
        return this.osSchedulerHints;
    }

    public void setOsSchedulerHints(NovaServerSchedulerHints osSchedulerHints) {
        this.osSchedulerHints = osSchedulerHints;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NovaServer that = (NovaServer)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.id, that.id) && Objects.equals(this.status, that.status) && Objects.equals(this.created, that.created) && Objects.equals(this.updated, that.updated) && Objects.equals(this.flavor, that.flavor) && Objects.equals(this.image, that.image) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.keyName, that.keyName) && Objects.equals(this.userId, that.userId) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.hostId, that.hostId) && Objects.equals(this.addresses, that.addresses) && Objects.equals(this.securityGroups, that.securityGroups) && Objects.equals(this.links, that.links) && Objects.equals(this.osDCFDiskConfig, that.osDCFDiskConfig) && Objects.equals(this.osEXTAZAvailabilityZone, that.osEXTAZAvailabilityZone) && Objects.equals(this.osEXTSRVATTRHost, that.osEXTSRVATTRHost) && Objects.equals(this.osEXTSRVATTRHypervisorHostname, that.osEXTSRVATTRHypervisorHostname) && Objects.equals(this.osEXTSRVATTRInstanceName, that.osEXTSRVATTRInstanceName) && Objects.equals(this.osEXTSTSPowerState, that.osEXTSTSPowerState) && Objects.equals(this.osEXTSTSTaskState, that.osEXTSTSTaskState) && Objects.equals(this.osEXTSTSVmState, that.osEXTSTSVmState) && Objects.equals(this.osSRVUSGLaunchedAt, that.osSRVUSGLaunchedAt) && Objects.equals(this.osSRVUSGTerminatedAt, that.osSRVUSGTerminatedAt) && Objects.equals(this.osExtendedVolumesVolumesAttached, that.osExtendedVolumesVolumesAttached) && Objects.equals(this.fault, that.fault) && Objects.equals(this.description, that.description) && Objects.equals(this.hostStatus, that.hostStatus) && Objects.equals(this.osEXTSRVATTRHostname, that.osEXTSRVATTRHostname) && Objects.equals(this.osEXTSRVATTRReservationId, that.osEXTSRVATTRReservationId) && Objects.equals(this.osEXTSRVATTRLaunchIndex, that.osEXTSRVATTRLaunchIndex) && Objects.equals(this.osEXTSRVATTRKernelId, that.osEXTSRVATTRKernelId) && Objects.equals(this.osEXTSRVATTRRamdiskId, that.osEXTSRVATTRRamdiskId) && Objects.equals(this.osEXTSRVATTRRootDeviceName, that.osEXTSRVATTRRootDeviceName) && Objects.equals(this.osEXTSRVATTRUserData, that.osEXTSRVATTRUserData) && Objects.equals(this.tags, that.tags) && Objects.equals(this.locked, that.locked) && Objects.equals(this.accessIPv4, that.accessIPv4) && Objects.equals(this.accessIPv6, that.accessIPv6) && Objects.equals(this.configDrive, that.configDrive) && Objects.equals(this.progress, that.progress) && Objects.equals(this.osSchedulerHints, that.osSchedulerHints);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.id, this.status, this.created, this.updated, this.flavor, this.image, this.tenantId, this.keyName, this.userId, this.metadata, this.hostId, this.addresses, this.securityGroups, this.links, this.osDCFDiskConfig, this.osEXTAZAvailabilityZone, this.osEXTSRVATTRHost, this.osEXTSRVATTRHypervisorHostname, this.osEXTSRVATTRInstanceName, this.osEXTSTSPowerState, this.osEXTSTSTaskState, this.osEXTSTSVmState, this.osSRVUSGLaunchedAt, this.osSRVUSGTerminatedAt, this.osExtendedVolumesVolumesAttached, this.fault, this.description, this.hostStatus, this.osEXTSRVATTRHostname, this.osEXTSRVATTRReservationId, this.osEXTSRVATTRLaunchIndex, this.osEXTSRVATTRKernelId, this.osEXTSRVATTRRamdiskId, this.osEXTSRVATTRRootDeviceName, this.osEXTSRVATTRUserData, this.tags, this.locked, this.accessIPv4, this.accessIPv6, this.configDrive, this.progress, this.osSchedulerHints);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NovaServer {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    updated: ").append(this.toIndentedString(this.updated)).append("\n");
        sb.append("    flavor: ").append(this.toIndentedString(this.flavor)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    keyName: ").append(this.toIndentedString(this.keyName)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    hostId: ").append(this.toIndentedString(this.hostId)).append("\n");
        sb.append("    addresses: ").append(this.toIndentedString(this.addresses)).append("\n");
        sb.append("    securityGroups: ").append(this.toIndentedString(this.securityGroups)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    osDCFDiskConfig: ").append(this.toIndentedString(this.osDCFDiskConfig)).append("\n");
        sb.append("    osEXTAZAvailabilityZone: ").append(this.toIndentedString(this.osEXTAZAvailabilityZone)).append("\n");
        sb.append("    osEXTSRVATTRHost: ").append(this.toIndentedString(this.osEXTSRVATTRHost)).append("\n");
        sb.append("    osEXTSRVATTRHypervisorHostname: ").append(this.toIndentedString(this.osEXTSRVATTRHypervisorHostname)).append("\n");
        sb.append("    osEXTSRVATTRInstanceName: ").append(this.toIndentedString(this.osEXTSRVATTRInstanceName)).append("\n");
        sb.append("    osEXTSTSPowerState: ").append(this.toIndentedString(this.osEXTSTSPowerState)).append("\n");
        sb.append("    osEXTSTSTaskState: ").append(this.toIndentedString(this.osEXTSTSTaskState)).append("\n");
        sb.append("    osEXTSTSVmState: ").append(this.toIndentedString(this.osEXTSTSVmState)).append("\n");
        sb.append("    osSRVUSGLaunchedAt: ").append(this.toIndentedString(this.osSRVUSGLaunchedAt)).append("\n");
        sb.append("    osSRVUSGTerminatedAt: ").append(this.toIndentedString(this.osSRVUSGTerminatedAt)).append("\n");
        sb.append("    osExtendedVolumesVolumesAttached: ").append(this.toIndentedString(this.osExtendedVolumesVolumesAttached)).append("\n");
        sb.append("    fault: ").append(this.toIndentedString(this.fault)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    hostStatus: ").append(this.toIndentedString(this.hostStatus)).append("\n");
        sb.append("    osEXTSRVATTRHostname: ").append(this.toIndentedString(this.osEXTSRVATTRHostname)).append("\n");
        sb.append("    osEXTSRVATTRReservationId: ").append(this.toIndentedString(this.osEXTSRVATTRReservationId)).append("\n");
        sb.append("    osEXTSRVATTRLaunchIndex: ").append(this.toIndentedString(this.osEXTSRVATTRLaunchIndex)).append("\n");
        sb.append("    osEXTSRVATTRKernelId: ").append(this.toIndentedString(this.osEXTSRVATTRKernelId)).append("\n");
        sb.append("    osEXTSRVATTRRamdiskId: ").append(this.toIndentedString(this.osEXTSRVATTRRamdiskId)).append("\n");
        sb.append("    osEXTSRVATTRRootDeviceName: ").append(this.toIndentedString(this.osEXTSRVATTRRootDeviceName)).append("\n");
        sb.append("    osEXTSRVATTRUserData: ").append(this.toIndentedString(this.osEXTSRVATTRUserData)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    locked: ").append(this.toIndentedString(this.locked)).append("\n");
        sb.append("    accessIPv4: ").append(this.toIndentedString(this.accessIPv4)).append("\n");
        sb.append("    accessIPv6: ").append(this.toIndentedString(this.accessIPv6)).append("\n");
        sb.append("    configDrive: ").append(this.toIndentedString(this.configDrive)).append("\n");
        sb.append("    progress: ").append(this.toIndentedString(this.progress)).append("\n");
        sb.append("    osSchedulerHints: ").append(this.toIndentedString(this.osSchedulerHints)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class HostStatusEnum {
        public static final HostStatusEnum UP = new HostStatusEnum("UP");
        public static final HostStatusEnum UNKNOWN = new HostStatusEnum("UNKNOWN");
        public static final HostStatusEnum DOWN = new HostStatusEnum("DOWN");
        public static final HostStatusEnum MAINTENANCE = new HostStatusEnum("MAINTENANCE");
        private static final Map<String, HostStatusEnum> STATIC_FIELDS = HostStatusEnum.createStaticFields();
        private String value;

        private static Map<String, HostStatusEnum> createStaticFields() {
            HashMap<String, HostStatusEnum> map = new HashMap<String, HostStatusEnum>();
            map.put("UP", UP);
            map.put("UNKNOWN", UNKNOWN);
            map.put("DOWN", DOWN);
            map.put("MAINTENANCE", MAINTENANCE);
            return Collections.unmodifiableMap(map);
        }

        HostStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static HostStatusEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new HostStatusEnum(value));
        }

        public static HostStatusEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof HostStatusEnum) {
                return this.value.equals(((HostStatusEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class OsEXTSTSVmStateEnum {
        public static final OsEXTSTSVmStateEnum ACTIVE = new OsEXTSTSVmStateEnum("ACTIVE");
        public static final OsEXTSTSVmStateEnum BUILDING = new OsEXTSTSVmStateEnum("BUILDING");
        public static final OsEXTSTSVmStateEnum STOPPED = new OsEXTSTSVmStateEnum("STOPPED");
        public static final OsEXTSTSVmStateEnum RESIZED = new OsEXTSTSVmStateEnum("RESIZED");
        public static final OsEXTSTSVmStateEnum PAUSED = new OsEXTSTSVmStateEnum("PAUSED");
        public static final OsEXTSTSVmStateEnum SUSPENDED = new OsEXTSTSVmStateEnum("SUSPENDED");
        public static final OsEXTSTSVmStateEnum RESCUED = new OsEXTSTSVmStateEnum("RESCUED");
        public static final OsEXTSTSVmStateEnum ERROR = new OsEXTSTSVmStateEnum("ERROR");
        public static final OsEXTSTSVmStateEnum DELETED = new OsEXTSTSVmStateEnum("DELETED");
        public static final OsEXTSTSVmStateEnum SOFT_DELETED = new OsEXTSTSVmStateEnum("SOFT_DELETED");
        public static final OsEXTSTSVmStateEnum SHELVED = new OsEXTSTSVmStateEnum("SHELVED");
        public static final OsEXTSTSVmStateEnum SHELVED_OFFLOADED = new OsEXTSTSVmStateEnum("SHELVED_OFFLOADED");
        private static final Map<String, OsEXTSTSVmStateEnum> STATIC_FIELDS = OsEXTSTSVmStateEnum.createStaticFields();
        private String value;

        private static Map<String, OsEXTSTSVmStateEnum> createStaticFields() {
            HashMap<String, OsEXTSTSVmStateEnum> map = new HashMap<String, OsEXTSTSVmStateEnum>();
            map.put("ACTIVE", ACTIVE);
            map.put("BUILDING", BUILDING);
            map.put("STOPPED", STOPPED);
            map.put("RESIZED", RESIZED);
            map.put("PAUSED", PAUSED);
            map.put("SUSPENDED", SUSPENDED);
            map.put("RESCUED", RESCUED);
            map.put("ERROR", ERROR);
            map.put("DELETED", DELETED);
            map.put("SOFT_DELETED", SOFT_DELETED);
            map.put("SHELVED", SHELVED);
            map.put("SHELVED_OFFLOADED", SHELVED_OFFLOADED);
            return Collections.unmodifiableMap(map);
        }

        OsEXTSTSVmStateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OsEXTSTSVmStateEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new OsEXTSTSVmStateEnum(value));
        }

        public static OsEXTSTSVmStateEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof OsEXTSTSVmStateEnum) {
                return this.value.equals(((OsEXTSTSVmStateEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class OsEXTSTSTaskStateEnum {
        public static final OsEXTSTSTaskStateEnum SHOUTOFF = new OsEXTSTSTaskStateEnum("SHOUTOFF");
        public static final OsEXTSTSTaskStateEnum _RESIZE = new OsEXTSTSTaskStateEnum(" RESIZE");
        public static final OsEXTSTSTaskStateEnum _REBUILD = new OsEXTSTSTaskStateEnum(" REBUILD");
        public static final OsEXTSTSTaskStateEnum _VERIFY_RESIZE = new OsEXTSTSTaskStateEnum(" VERIFY_RESIZE");
        public static final OsEXTSTSTaskStateEnum _REVERT_RESIZE = new OsEXTSTSTaskStateEnum(" REVERT_RESIZE");
        public static final OsEXTSTSTaskStateEnum _PAUSED = new OsEXTSTSTaskStateEnum(" PAUSED");
        public static final OsEXTSTSTaskStateEnum _MIGRATING = new OsEXTSTSTaskStateEnum(" MIGRATING");
        public static final OsEXTSTSTaskStateEnum _SUSPENDED = new OsEXTSTSTaskStateEnum(" SUSPENDED");
        public static final OsEXTSTSTaskStateEnum _RESCUE = new OsEXTSTSTaskStateEnum(" RESCUE");
        public static final OsEXTSTSTaskStateEnum _ERROR = new OsEXTSTSTaskStateEnum(" ERROR");
        public static final OsEXTSTSTaskStateEnum _DELETED = new OsEXTSTSTaskStateEnum(" DELETED");
        public static final OsEXTSTSTaskStateEnum SOFT_DELETED = new OsEXTSTSTaskStateEnum("SOFT_DELETED");
        public static final OsEXTSTSTaskStateEnum SHELVED = new OsEXTSTSTaskStateEnum("SHELVED");
        public static final OsEXTSTSTaskStateEnum SHELVED_OFFLOADED = new OsEXTSTSTaskStateEnum("SHELVED_OFFLOADED");
        private static final Map<String, OsEXTSTSTaskStateEnum> STATIC_FIELDS = OsEXTSTSTaskStateEnum.createStaticFields();
        private String value;

        private static Map<String, OsEXTSTSTaskStateEnum> createStaticFields() {
            HashMap<String, OsEXTSTSTaskStateEnum> map = new HashMap<String, OsEXTSTSTaskStateEnum>();
            map.put("SHOUTOFF", SHOUTOFF);
            map.put(" RESIZE", _RESIZE);
            map.put(" REBUILD", _REBUILD);
            map.put(" VERIFY_RESIZE", _VERIFY_RESIZE);
            map.put(" REVERT_RESIZE", _REVERT_RESIZE);
            map.put(" PAUSED", _PAUSED);
            map.put(" MIGRATING", _MIGRATING);
            map.put(" SUSPENDED", _SUSPENDED);
            map.put(" RESCUE", _RESCUE);
            map.put(" ERROR", _ERROR);
            map.put(" DELETED", _DELETED);
            map.put("SOFT_DELETED", SOFT_DELETED);
            map.put("SHELVED", SHELVED);
            map.put("SHELVED_OFFLOADED", SHELVED_OFFLOADED);
            return Collections.unmodifiableMap(map);
        }

        OsEXTSTSTaskStateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OsEXTSTSTaskStateEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new OsEXTSTSTaskStateEnum(value));
        }

        public static OsEXTSTSTaskStateEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof OsEXTSTSTaskStateEnum) {
                return this.value.equals(((OsEXTSTSTaskStateEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class OsDCFDiskConfigEnum {
        public static final OsDCFDiskConfigEnum AUTO = new OsDCFDiskConfigEnum("AUTO");
        public static final OsDCFDiskConfigEnum MANUAL = new OsDCFDiskConfigEnum("MANUAL");
        private static final Map<String, OsDCFDiskConfigEnum> STATIC_FIELDS = OsDCFDiskConfigEnum.createStaticFields();
        private String value;

        private static Map<String, OsDCFDiskConfigEnum> createStaticFields() {
            HashMap<String, OsDCFDiskConfigEnum> map = new HashMap<String, OsDCFDiskConfigEnum>();
            map.put("AUTO", AUTO);
            map.put("MANUAL", MANUAL);
            return Collections.unmodifiableMap(map);
        }

        OsDCFDiskConfigEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OsDCFDiskConfigEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new OsDCFDiskConfigEnum(value));
        }

        public static OsDCFDiskConfigEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof OsDCFDiskConfigEnum) {
                return this.value.equals(((OsDCFDiskConfigEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class StatusEnum {
        public static final StatusEnum ACTIVE = new StatusEnum("ACTIVE");
        public static final StatusEnum _BUILD = new StatusEnum(" BUILD");
        public static final StatusEnum DELETED = new StatusEnum("DELETED");
        public static final StatusEnum ERROR = new StatusEnum("ERROR");
        public static final StatusEnum HARD_REBOOT = new StatusEnum("HARD_REBOOT");
        public static final StatusEnum MIGRATING = new StatusEnum("MIGRATING");
        public static final StatusEnum REBOOT = new StatusEnum("REBOOT");
        public static final StatusEnum RESIZE = new StatusEnum("RESIZE");
        public static final StatusEnum REVERT_RESIZE = new StatusEnum("REVERT_RESIZE");
        public static final StatusEnum SHELVED = new StatusEnum("SHELVED");
        public static final StatusEnum SHELVED_OFFLOADED = new StatusEnum("SHELVED_OFFLOADED");
        public static final StatusEnum SHUTOFF = new StatusEnum("SHUTOFF");
        public static final StatusEnum UNKNOWN = new StatusEnum("UNKNOWN");
        public static final StatusEnum VERIFY_RESIZE = new StatusEnum("VERIFY_RESIZE");
        private static final Map<String, StatusEnum> STATIC_FIELDS = StatusEnum.createStaticFields();
        private String value;

        private static Map<String, StatusEnum> createStaticFields() {
            HashMap<String, StatusEnum> map = new HashMap<String, StatusEnum>();
            map.put("ACTIVE", ACTIVE);
            map.put(" BUILD", _BUILD);
            map.put("DELETED", DELETED);
            map.put("ERROR", ERROR);
            map.put("HARD_REBOOT", HARD_REBOOT);
            map.put("MIGRATING", MIGRATING);
            map.put("REBOOT", REBOOT);
            map.put("RESIZE", RESIZE);
            map.put("REVERT_RESIZE", REVERT_RESIZE);
            map.put("SHELVED", SHELVED);
            map.put("SHELVED_OFFLOADED", SHELVED_OFFLOADED);
            map.put("SHUTOFF", SHUTOFF);
            map.put("UNKNOWN", UNKNOWN);
            map.put("VERIFY_RESIZE", VERIFY_RESIZE);
            return Collections.unmodifiableMap(map);
        }

        StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new StatusEnum(value));
        }

        public static StatusEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof StatusEnum) {
                return this.value.equals(((StatusEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

