/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.ecs.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.ecs.v2.model.MarketModelPrepaidInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class MarketModel {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="charge_mode")
    private ChargeModeEnum chargeMode;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="prepaid_info")
    private MarketModelPrepaidInfo prepaidInfo;

    public MarketModel withChargeMode(ChargeModeEnum chargeMode) {
        this.chargeMode = chargeMode;
        return this;
    }

    public ChargeModeEnum getChargeMode() {
        return this.chargeMode;
    }

    public void setChargeMode(ChargeModeEnum chargeMode) {
        this.chargeMode = chargeMode;
    }

    public MarketModel withPrepaidInfo(MarketModelPrepaidInfo prepaidInfo) {
        this.prepaidInfo = prepaidInfo;
        return this;
    }

    public MarketModel withPrepaidInfo(Consumer<MarketModelPrepaidInfo> prepaidInfoSetter) {
        if (this.prepaidInfo == null) {
            this.prepaidInfo = new MarketModelPrepaidInfo();
            prepaidInfoSetter.accept(this.prepaidInfo);
        }
        return this;
    }

    public MarketModelPrepaidInfo getPrepaidInfo() {
        return this.prepaidInfo;
    }

    public void setPrepaidInfo(MarketModelPrepaidInfo prepaidInfo) {
        this.prepaidInfo = prepaidInfo;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MarketModel that = (MarketModel)obj;
        return Objects.equals(this.chargeMode, that.chargeMode) && Objects.equals(this.prepaidInfo, that.prepaidInfo);
    }

    public int hashCode() {
        return Objects.hash(this.chargeMode, this.prepaidInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MarketModel {\n");
        sb.append("    chargeMode: ").append(this.toIndentedString(this.chargeMode)).append("\n");
        sb.append("    prepaidInfo: ").append(this.toIndentedString(this.prepaidInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ChargeModeEnum {
        public static final ChargeModeEnum SPOT = new ChargeModeEnum("spot");
        public static final ChargeModeEnum PREPAID = new ChargeModeEnum("prepaid");
        public static final ChargeModeEnum POSTPAID = new ChargeModeEnum("postpaid");
        private static final Map<String, ChargeModeEnum> STATIC_FIELDS = ChargeModeEnum.createStaticFields();
        private String value;

        private static Map<String, ChargeModeEnum> createStaticFields() {
            HashMap<String, ChargeModeEnum> map = new HashMap<String, ChargeModeEnum>();
            map.put("spot", SPOT);
            map.put("prepaid", PREPAID);
            map.put("postpaid", POSTPAID);
            return Collections.unmodifiableMap(map);
        }

        ChargeModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChargeModeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ChargeModeEnum(value));
        }

        public static ChargeModeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ChargeModeEnum) {
                return this.value.equals(((ChargeModeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

