/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.ecs.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class CreateServerGroupOption {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="name")
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="policies")
    private List<PoliciesEnum> policies = null;

    public CreateServerGroupOption withName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateServerGroupOption withPolicies(List<PoliciesEnum> policies) {
        this.policies = policies;
        return this;
    }

    public CreateServerGroupOption addPoliciesItem(PoliciesEnum policiesItem) {
        if (this.policies == null) {
            this.policies = new ArrayList<PoliciesEnum>();
        }
        this.policies.add(policiesItem);
        return this;
    }

    public CreateServerGroupOption withPolicies(Consumer<List<PoliciesEnum>> policiesSetter) {
        if (this.policies == null) {
            this.policies = new ArrayList<PoliciesEnum>();
        }
        policiesSetter.accept(this.policies);
        return this;
    }

    public List<PoliciesEnum> getPolicies() {
        return this.policies;
    }

    public void setPolicies(List<PoliciesEnum> policies) {
        this.policies = policies;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateServerGroupOption that = (CreateServerGroupOption)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.policies, that.policies);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.policies);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateServerGroupOption {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    policies: ").append(this.toIndentedString(this.policies)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class PoliciesEnum {
        public static final PoliciesEnum ANTI_AFFINITY = new PoliciesEnum("anti-affinity");
        private static final Map<String, PoliciesEnum> STATIC_FIELDS = PoliciesEnum.createStaticFields();
        private String value;

        private static Map<String, PoliciesEnum> createStaticFields() {
            HashMap<String, PoliciesEnum> map = new HashMap<String, PoliciesEnum>();
            map.put("anti-affinity", ANTI_AFFINITY);
            return Collections.unmodifiableMap(map);
        }

        PoliciesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PoliciesEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new PoliciesEnum(value));
        }

        public static PoliciesEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof PoliciesEnum) {
                return this.value.equals(((PoliciesEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

