/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.ec.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class QuotaObject {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="unit")
    private String unit;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="min")
    private Integer min;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="max")
    private Integer max;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="quota")
    private Integer quota;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="used")
    private Integer used;

    public QuotaObject withType(TypeEnum type) {
        this.type = type;
        return this;
    }

    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public QuotaObject withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public QuotaObject withMin(Integer min) {
        this.min = min;
        return this;
    }

    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    public QuotaObject withMax(Integer max) {
        this.max = max;
        return this;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public QuotaObject withQuota(Integer quota) {
        this.quota = quota;
        return this;
    }

    public Integer getQuota() {
        return this.quota;
    }

    public void setQuota(Integer quota) {
        this.quota = quota;
    }

    public QuotaObject withUsed(Integer used) {
        this.used = used;
        return this;
    }

    public Integer getUsed() {
        return this.used;
    }

    public void setUsed(Integer used) {
        this.used = used;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QuotaObject that = (QuotaObject)obj;
        return Objects.equals(this.type, that.type) && Objects.equals(this.unit, that.unit) && Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max) && Objects.equals(this.quota, that.quota) && Objects.equals(this.used, that.used);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.unit, this.min, this.max, this.quota, this.used);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QuotaObject {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("    min: ").append(this.toIndentedString(this.min)).append("\n");
        sb.append("    max: ").append(this.toIndentedString(this.max)).append("\n");
        sb.append("    quota: ").append(this.toIndentedString(this.quota)).append("\n");
        sb.append("    used: ").append(this.toIndentedString(this.used)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class TypeEnum {
        public static final TypeEnum IEG_NUM_LIMIT = new TypeEnum("ieg_num_limit");
        public static final TypeEnum ECN_NUM_LIMIT = new TypeEnum("ecn_num_limit");
        public static final TypeEnum ECN_STANDARD_BANDWIDTH_LIMIT = new TypeEnum("ecn_standard_bandwidth_limit");
        public static final TypeEnum ECN_PROFESSIONAL_BANDWIDTH_LIMIT = new TypeEnum("ecn_professional_bandwidth_limit");
        public static final TypeEnum ROUTE_LIMIT = new TypeEnum("route_limit");
        private static final Map<String, TypeEnum> STATIC_FIELDS = TypeEnum.createStaticFields();
        private String value;

        private static Map<String, TypeEnum> createStaticFields() {
            HashMap<String, TypeEnum> map = new HashMap<String, TypeEnum>();
            map.put("ieg_num_limit", IEG_NUM_LIMIT);
            map.put("ecn_num_limit", ECN_NUM_LIMIT);
            map.put("ecn_standard_bandwidth_limit", ECN_STANDARD_BANDWIDTH_LIMIT);
            map.put("ecn_professional_bandwidth_limit", ECN_PROFESSIONAL_BANDWIDTH_LIMIT);
            map.put("route_limit", ROUTE_LIMIT);
            return Collections.unmodifiableMap(map);
        }

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new TypeEnum(value));
        }

        public static TypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeEnum) {
                return this.value.equals(((TypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

